/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.ide.utils.PsiModificationUtil;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsCondition;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsIfExpr;
import org.rust.lang.core.psi.RsLetExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.LogicOp;
import org.rust.lang.core.psi.ext.RsBlockKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.psi.ext.RsIfExprKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\f\u0010\u001a\u001a\u00020\u0006*\u00020\u0017H\u0002R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/rust/ide/intentions/MergeIfsIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/ide/intentions/MergeIfsIntention$Context;", "<init>", "()V", "getText", "", "getFamilyName", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "createConjunction", "Lorg/rust/lang/core/psi/RsExpr;", "expr1", "expr2", "getTextForConjunctionOperand", "Context", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMergeIfsIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeIfsIntention.kt\norg/rust/ide/intentions/MergeIfsIntention\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,74:1\n9#2:75\n124#3:76\n124#3:77\n*S KotlinDebug\n*F\n+ 1 MergeIfsIntention.kt\norg/rust/ide/intentions/MergeIfsIntention\n*L\n31#1:75\n41#1:76\n42#1:77\n*E\n"})
public final class MergeIfsIntention
extends RsElementBaseIntentionAction<Context> {
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.merge.with.nested.if.expression", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    @Override
    @Nullable
    public Context findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        RsLetExpr rsLetExpr;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$ancestorStrict$iv = element;
        boolean $i$f$ancestorStrict = false;
        RsIfExpr rsIfExpr = (RsIfExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsIfExpr.class, (boolean)true);
        if (rsIfExpr == null) {
            return null;
        }
        RsIfExpr ifExpr = rsIfExpr;
        if (!Intrinsics.areEqual((Object)element, (Object)ifExpr.getIf())) {
            return null;
        }
        RsBlock rsBlock = RsIfExprKt.getBlock(ifExpr);
        if (rsBlock == null) {
            return null;
        }
        RsBlock ifExprBlock = rsBlock;
        RsExprStmt rsExprStmt = RsBlockKt.singleTailStmt(ifExprBlock);
        RsExpr rsExpr = rsExprStmt != null ? rsExprStmt.getExpr() : null;
        RsIfExpr rsIfExpr2 = rsExpr instanceof RsIfExpr ? (RsIfExpr)rsExpr : null;
        if (rsIfExpr2 == null) {
            return null;
        }
        RsIfExpr nestedIfExpr = rsIfExpr2;
        RsElement rsElement = ifExpr.getCondition();
        if (rsElement == null || (rsElement = rsElement.getExpr()) == null) {
            return null;
        }
        RsElement ifCondition = rsElement;
        RsCondition rsCondition = nestedIfExpr.getCondition();
        if (rsCondition == null) {
            return null;
        }
        RsCondition nestedIfCondition = rsCondition;
        RsBlock nestedIfExprBlock = RsIfExprKt.getBlock(nestedIfExpr);
        PsiElement $this$descendantOfTypeOrSelf$iv = ifCondition;
        boolean $i$f$descendantOfTypeOrSelf = false;
        if (PsiTreeUtil.findChildOfType((PsiElement)$this$descendantOfTypeOrSelf$iv, RsLetExpr.class, (boolean)false) != null) {
            return null;
        }
        RsExpr rsExpr2 = nestedIfCondition.getExpr();
        if (rsExpr2 != null) {
            PsiElement $this$descendantOfTypeOrSelf$iv2 = rsExpr2;
            boolean $i$f$descendantOfTypeOrSelf2 = false;
            rsLetExpr = (RsLetExpr)PsiTreeUtil.findChildOfType((PsiElement)$this$descendantOfTypeOrSelf$iv2, RsLetExpr.class, (boolean)false);
        } else {
            rsLetExpr = null;
        }
        if (rsLetExpr != null) {
            return null;
        }
        if (ifExpr.getElseBranch() != null || nestedIfExpr.getElseBranch() != null) {
            return null;
        }
        if (!PsiModificationUtil.INSTANCE.canReplace(ifCondition)) {
            return null;
        }
        if (nestedIfExprBlock != null && !PsiModificationUtil.INSTANCE.canReplace(ifExprBlock)) {
            return null;
        }
        RsExpr rsExpr3 = nestedIfCondition.getExpr();
        if (rsExpr3 == null) {
            return null;
        }
        return new Context(ifExprBlock, nestedIfExprBlock, (RsExpr)ifCondition, rsExpr3);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        RsExpr condition = this.createConjunction(ctx.getIfCondition(), ctx.getNestedIfCondition());
        ctx.getIfCondition().replace(condition);
        RsBlock rsBlock = ctx.getNestedIfExprBlock();
        if (rsBlock == null) {
            return;
        }
        ctx.getIfExprBlock().replace(rsBlock);
    }

    private final RsExpr createConjunction(RsExpr expr1, RsExpr expr2) {
        String text1 = this.getTextForConjunctionOperand(expr1);
        String text2 = this.getTextForConjunctionOperand(expr2);
        Project project = expr1.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new RsPsiFactory(project, false, false, 6, null).createExpression(text1 + " && " + text2);
    }

    private final String getTextForConjunctionOperand(RsExpr $this$getTextForConjunctionOperand) {
        Object object;
        if ($this$getTextForConjunctionOperand instanceof RsBinaryExpr && Intrinsics.areEqual((Object)RsExprKt.getOperatorType((RsBinaryExpr)$this$getTextForConjunctionOperand), (Object)LogicOp.OR.INSTANCE)) {
            object = "(" + ((RsBinaryExpr)$this$getTextForConjunctionOperand).getText() + ")";
        } else {
            String string = $this$getTextForConjunctionOperand.getText();
            Intrinsics.checkNotNull((Object)string);
            object = string;
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/intentions/MergeIfsIntention$Context;", "", "ifExprBlock", "Lorg/rust/lang/core/psi/RsBlock;", "nestedIfExprBlock", "ifCondition", "Lorg/rust/lang/core/psi/RsExpr;", "nestedIfCondition", "<init>", "(Lorg/rust/lang/core/psi/RsBlock;Lorg/rust/lang/core/psi/RsBlock;Lorg/rust/lang/core/psi/RsExpr;Lorg/rust/lang/core/psi/RsExpr;)V", "getIfExprBlock", "()Lorg/rust/lang/core/psi/RsBlock;", "getNestedIfExprBlock", "getIfCondition", "()Lorg/rust/lang/core/psi/RsExpr;", "getNestedIfCondition", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final RsBlock ifExprBlock;
        @Nullable
        private final RsBlock nestedIfExprBlock;
        @NotNull
        private final RsExpr ifCondition;
        @NotNull
        private final RsExpr nestedIfCondition;

        public Context(@NotNull RsBlock ifExprBlock, @Nullable RsBlock nestedIfExprBlock, @NotNull RsExpr ifCondition, @NotNull RsExpr nestedIfCondition) {
            Intrinsics.checkNotNullParameter((Object)ifExprBlock, (String)"ifExprBlock");
            Intrinsics.checkNotNullParameter((Object)ifCondition, (String)"ifCondition");
            Intrinsics.checkNotNullParameter((Object)nestedIfCondition, (String)"nestedIfCondition");
            this.ifExprBlock = ifExprBlock;
            this.nestedIfExprBlock = nestedIfExprBlock;
            this.ifCondition = ifCondition;
            this.nestedIfCondition = nestedIfCondition;
        }

        @NotNull
        public final RsBlock getIfExprBlock() {
            return this.ifExprBlock;
        }

        @Nullable
        public final RsBlock getNestedIfExprBlock() {
            return this.nestedIfExprBlock;
        }

        @NotNull
        public final RsExpr getIfCondition() {
            return this.ifCondition;
        }

        @NotNull
        public final RsExpr getNestedIfCondition() {
            return this.nestedIfCondition;
        }
    }
}

