/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.ide.refactoring.ExtraxtExpressionUtilsKt;
import org.rust.ide.utils.PsiModificationUtil;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsMatchArm;
import org.rust.lang.core.psi.RsMatchBody;
import org.rust.lang.core.psi.RsMatchExpr;
import org.rust.lang.core.psi.RsOuterAttr;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsUnitExpr;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyTuple;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/rust/ide/intentions/MatchToIfLetIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/ide/intentions/MatchToIfLetIntention$Context;", "<init>", "()V", "getText", "", "getFamilyName", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "Context", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMatchToIfLetIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatchToIfLetIntention.kt\norg/rust/ide/intentions/MatchToIfLetIntention\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n9#2:123\n1761#3,3:124\n*S KotlinDebug\n*F\n+ 1 MatchToIfLetIntention.kt\norg/rust/ide/intentions/MatchToIfLetIntention\n*L\n33#1:123\n38#1:124,3\n*E\n"})
public final class MatchToIfLetIntention
extends RsElementBaseIntentionAction<Context> {
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.convert.match.statement.to.if.let", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Context findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$ancestorStrict$iv = element;
        boolean $i$f$ancestorStrict = false;
        RsMatchExpr rsMatchExpr = (RsMatchExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsMatchExpr.class, (boolean)true);
        if (rsMatchExpr == null) {
            return null;
        }
        RsMatchExpr matchExpr2 = rsMatchExpr;
        if (!Intrinsics.areEqual((Object)element, (Object)matchExpr2.getMatch())) {
            return null;
        }
        RsExpr rsExpr = matchExpr2.getScrutinee();
        if (rsExpr == null) {
            return null;
        }
        RsExpr matchTarget = rsExpr;
        RsMatchBody rsMatchBody = matchExpr2.getMatchBody();
        if (rsMatchBody == null) {
            return null;
        }
        RsMatchBody matchBody = rsMatchBody;
        if (matchBody.getMatchArmList().isEmpty()) {
            return null;
        }
        List<RsMatchArm> list = matchBody.getMatchArmList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getMatchArmList(...)");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                RsMatchArm it2 = (RsMatchArm)element$iv;
                boolean bl2 = false;
                if (it2.getMatchArmGuard() != null) return null;
                List<RsOuterAttr> list2 = it2.getOuterAttrList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"<get-outerAttrList>(...)");
                if (!((Collection)list2).isEmpty()) {
                    return null;
                }
                boolean bl3 = false;
                if (bl3) {
                    return null;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return null;
            }
            bl = false;
        }
        if (bl) {
            return null;
        }
        if (PsiModificationUtil.INSTANCE.canReplace(matchExpr2)) return new Context(matchExpr2, matchTarget, matchBody);
        return null;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull Context ctx) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List<RsMatchArm> list = ctx.getMatchBody().getMatchArmList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getMatchArmList(...)");
        List<RsMatchArm> arms = list;
        RsMatchArm rsMatchArm = (RsMatchArm)CollectionsKt.lastOrNull(arms);
        if (rsMatchArm == null) {
            return;
        }
        RsMatchArm lastArm = rsMatchArm;
        Ty type = ExtensionsKt.getType(ctx.getMatch());
        boolean hasUnitType = type instanceof TyTuple && ((TyTuple)type).getTypes().isEmpty();
        RsPat rsPat = lastArm.getPat();
        Intrinsics.checkNotNullExpressionValue((Object)rsPat, (String)"getPat(...)");
        boolean lastArmHasBinding = ExtraxtExpressionUtilsKt.findBinding(rsPat) != null;
        boolean lastArmExprEmpty = MatchToIfLetIntention.invoke$isExprEmpty(lastArm.getExpr());
        StringBuilder $this$invoke_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean hasElseBlock = false;
        Iterator iterator2 = ((Iterable)arms).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            String string;
            RsExpr expr;
            int index = n++;
            RsMatchArm arm = (RsMatchArm)iterator2.next();
            if (arm.getExpr() == null) continue;
            Object armText = "if let " + arm.getPat().getText() + " = " + ctx.getMatchTarget().getText();
            int n2 = index;
            if (n2 != 0) {
                if (n2 == arms.size() - 1) {
                    if (hasUnitType && lastArmExprEmpty) break;
                    if (!lastArmHasBinding) {
                        armText = " else";
                        hasElseBlock = true;
                    } else {
                        armText = " else " + (String)armText;
                    }
                } else {
                    armText = " else " + (String)armText;
                }
            }
            $this$invoke_u24lambda_u241.append((String)armText);
            $this$invoke_u24lambda_u241.append(' ');
            if (!hasUnitType && MatchToIfLetIntention.invoke$isExprEmpty(expr)) {
                string = "unreachable!()";
            } else if (expr instanceof RsBlockExpr) {
                String text = ((RsBlockExpr)expr).getBlock().getText();
                int start2 = ((RsBlockExpr)expr).getBlock().getLbrace().getStartOffsetInParent() + 1;
                PsiElement psiElement2 = ((RsBlockExpr)expr).getBlock().getRbrace();
                int end = psiElement2 != null ? psiElement2.getStartOffsetInParent() : text.length();
                Intrinsics.checkNotNull((Object)text);
                String string2 = text.substring(start2, end);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = expr.getText();
            }
            String innerExprText = string;
            String exprText = "{\n    " + innerExprText + "\n}";
            $this$invoke_u24lambda_u241.append(exprText);
        }
        if (!hasUnitType && !hasElseBlock) {
            $this$invoke_u24lambda_u241.append(" else {\n    unreachable!()\n}");
        }
        String text = stringBuilder.toString();
        RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
        RsExpr ifLetExpr = factory2.createExpression(text);
        ctx.getMatch().replace(ifLetExpr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean invoke$isExprEmpty(RsExpr expr) {
        RsExpr rsExpr = expr;
        if (rsExpr == null) return false;
        RsExpr it2 = rsExpr;
        boolean bl = false;
        if (it2 instanceof RsUnitExpr) {
            return true;
        }
        if (!(it2 instanceof RsBlockExpr)) return false;
        PsiElement[] psiElementArray = ((RsBlockExpr)it2).getBlock().getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        if (((Object[])psiElementArray).length != 0) return false;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/rust/ide/intentions/MatchToIfLetIntention$Context;", "", "match", "Lorg/rust/lang/core/psi/RsMatchExpr;", "matchTarget", "Lorg/rust/lang/core/psi/RsExpr;", "matchBody", "Lorg/rust/lang/core/psi/RsMatchBody;", "<init>", "(Lorg/rust/lang/core/psi/RsMatchExpr;Lorg/rust/lang/core/psi/RsExpr;Lorg/rust/lang/core/psi/RsMatchBody;)V", "getMatch", "()Lorg/rust/lang/core/psi/RsMatchExpr;", "getMatchTarget", "()Lorg/rust/lang/core/psi/RsExpr;", "getMatchBody", "()Lorg/rust/lang/core/psi/RsMatchBody;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final RsMatchExpr match;
        @NotNull
        private final RsExpr matchTarget;
        @NotNull
        private final RsMatchBody matchBody;

        public Context(@NotNull RsMatchExpr match2, @NotNull RsExpr matchTarget, @NotNull RsMatchBody matchBody) {
            Intrinsics.checkNotNullParameter((Object)match2, (String)"match");
            Intrinsics.checkNotNullParameter((Object)matchTarget, (String)"matchTarget");
            Intrinsics.checkNotNullParameter((Object)matchBody, (String)"matchBody");
            this.match = match2;
            this.matchTarget = matchTarget;
            this.matchBody = matchBody;
        }

        @NotNull
        public final RsMatchExpr getMatch() {
            return this.match;
        }

        @NotNull
        public final RsExpr getMatchTarget() {
            return this.matchTarget;
        }

        @NotNull
        public final RsMatchBody getMatchBody() {
            return this.matchBody;
        }

        @NotNull
        public final RsMatchExpr component1() {
            return this.match;
        }

        @NotNull
        public final RsExpr component2() {
            return this.matchTarget;
        }

        @NotNull
        public final RsMatchBody component3() {
            return this.matchBody;
        }

        @NotNull
        public final Context copy(@NotNull RsMatchExpr match2, @NotNull RsExpr matchTarget, @NotNull RsMatchBody matchBody) {
            Intrinsics.checkNotNullParameter((Object)match2, (String)"match");
            Intrinsics.checkNotNullParameter((Object)matchTarget, (String)"matchTarget");
            Intrinsics.checkNotNullParameter((Object)matchBody, (String)"matchBody");
            return new Context(match2, matchTarget, matchBody);
        }

        public static /* synthetic */ Context copy$default(Context context, RsMatchExpr rsMatchExpr, RsExpr rsExpr, RsMatchBody rsMatchBody, int n, Object object) {
            if ((n & 1) != 0) {
                rsMatchExpr = context.match;
            }
            if ((n & 2) != 0) {
                rsExpr = context.matchTarget;
            }
            if ((n & 4) != 0) {
                rsMatchBody = context.matchBody;
            }
            return context.copy(rsMatchExpr, rsExpr, rsMatchBody);
        }

        @NotNull
        public String toString() {
            return "Context(match=" + this.match + ", matchTarget=" + this.matchTarget + ", matchBody=" + this.matchBody + ")";
        }

        public int hashCode() {
            int result2 = this.match.hashCode();
            result2 = result2 * 31 + this.matchTarget.hashCode();
            result2 = result2 * 31 + this.matchBody.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.match, (Object)context.match)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.matchTarget, (Object)context.matchTarget)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.matchBody, (Object)context.matchBody);
        }
    }
}

