/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.intentions.GenerateDocStubIntentionKt;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.psi.impl.RsFunctionImpl;
import org.rust.lang.core.types.ty.Ty;
import org.rust.openapiext.EditorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/rust/ide/intentions/GenerateDocStubIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/ide/intentions/GenerateDocStubIntention$Context;", "<init>", "()V", "getText", "", "getFamilyName", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "Context", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nGenerateDocStubIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateDocStubIntention.kt\norg/rust/ide/intentions/GenerateDocStubIntention\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,98:1\n15#2:99\n*S KotlinDebug\n*F\n+ 1 GenerateDocStubIntention.kt\norg/rust/ide/intentions/GenerateDocStubIntention\n*L\n35#1:99\n*E\n"})
public final class GenerateDocStubIntention
extends RsElementBaseIntentionAction<Context> {
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.generate.documentation.stub", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    @Override
    @Nullable
    public Context findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$ancestorOrSelf$iv = element;
        boolean $i$f$ancestorOrSelf = false;
        RsGenericDeclaration rsGenericDeclaration = (RsGenericDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsGenericDeclaration.class, (boolean)false);
        if (rsGenericDeclaration == null) {
            return null;
        }
        RsGenericDeclaration targetFunc = rsGenericDeclaration;
        if (!(targetFunc instanceof RsFunctionImpl)) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)((RsFunctionImpl)targetFunc).getName(), (Object)element.getText())) {
            return null;
        }
        String string = ((RsFunctionImpl)targetFunc).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.startsWith$default((String)string, (String)"///", (boolean)false, (int)2, null)) {
            return null;
        }
        List<RsValueParameter> params = RsFunctionKt.getValueParameters((RsFunction)targetFunc);
        if (params.isEmpty()) {
            return null;
        }
        Ty returnType = RsFunctionKt.getRawReturnType((RsFunction)targetFunc);
        return new Context(targetFunc, params, returnType);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        RsElement targetFunc = ctx.component1();
        List<RsValueParameter> params = ctx.component2();
        Ty returnType = ctx.component3();
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int commentStartOffset = targetFunc.getTextRange().getStartOffset();
        int lineStartOffset = document2.getLineStartOffset(document2.getLineNumber(commentStartOffset));
        boolean bl = 1 <= lineStartOffset ? lineStartOffset < commentStartOffset : false;
        if (bl) {
            int nonWhiteSpaceOffset = CharArrayUtil.shiftBackward((CharSequence)document2.getCharsSequence(), (int)(commentStartOffset - 1), (String)" \t");
            commentStartOffset = Math.max(nonWhiteSpaceOffset, lineStartOffset);
        }
        StringBuilder buffer = new StringBuilder();
        int commentBodyRelativeOffset = 0;
        int indentOffset = PsiElementKt.getStartOffset(targetFunc) - lineStartOffset;
        String indentation = StringsKt.repeat((CharSequence)" ", (int)indentOffset);
        buffer.append(indentation + "/// \n");
        commentBodyRelativeOffset += buffer.length();
        document2.insertString(commentStartOffset, (CharSequence)buffer);
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project);
        docManager.commitDocument(document2);
        String stub = GenerateDocStubIntentionKt.access$generateDocumentStub(indentation, params, returnType);
        if (((CharSequence)stub).length() > 0) {
            int insertionOffset = commentStartOffset + commentBodyRelativeOffset;
            document2.insertString(insertionOffset, (CharSequence)stub);
            docManager.commitDocument(document2);
        }
        EditorKt.moveCaretToOffset(editor2, targetFunc, PsiElementKt.getStartOffset(targetFunc) + buffer.length() - indentOffset - 1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/rust/ide/intentions/GenerateDocStubIntention$Context;", "", "func", "Lorg/rust/lang/core/psi/ext/RsElement;", "params", "", "Lorg/rust/lang/core/psi/RsValueParameter;", "returnType", "Lorg/rust/lang/core/types/ty/Ty;", "<init>", "(Lorg/rust/lang/core/psi/ext/RsElement;Ljava/util/List;Lorg/rust/lang/core/types/ty/Ty;)V", "getFunc", "()Lorg/rust/lang/core/psi/ext/RsElement;", "getParams", "()Ljava/util/List;", "getReturnType", "()Lorg/rust/lang/core/types/ty/Ty;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final RsElement func;
        @NotNull
        private final List<RsValueParameter> params;
        @NotNull
        private final Ty returnType;

        public Context(@NotNull RsElement func, @NotNull List<? extends RsValueParameter> params, @NotNull Ty returnType) {
            Intrinsics.checkNotNullParameter((Object)func, (String)"func");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
            this.func = func;
            this.params = params;
            this.returnType = returnType;
        }

        @NotNull
        public final RsElement getFunc() {
            return this.func;
        }

        @NotNull
        public final List<RsValueParameter> getParams() {
            return this.params;
        }

        @NotNull
        public final Ty getReturnType() {
            return this.returnType;
        }

        @NotNull
        public final RsElement component1() {
            return this.func;
        }

        @NotNull
        public final List<RsValueParameter> component2() {
            return this.params;
        }

        @NotNull
        public final Ty component3() {
            return this.returnType;
        }

        @NotNull
        public final Context copy(@NotNull RsElement func, @NotNull List<? extends RsValueParameter> params, @NotNull Ty returnType) {
            Intrinsics.checkNotNullParameter((Object)func, (String)"func");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
            return new Context(func, params, returnType);
        }

        public static /* synthetic */ Context copy$default(Context context, RsElement rsElement, List list, Ty ty2, int n, Object object) {
            if ((n & 1) != 0) {
                rsElement = context.func;
            }
            if ((n & 2) != 0) {
                list = context.params;
            }
            if ((n & 4) != 0) {
                ty2 = context.returnType;
            }
            return context.copy(rsElement, list, ty2);
        }

        @NotNull
        public String toString() {
            return "Context(func=" + this.func + ", params=" + this.params + ", returnType=" + this.returnType + ")";
        }

        public int hashCode() {
            int result2 = this.func.hashCode();
            result2 = result2 * 31 + ((Object)this.params).hashCode();
            result2 = result2 * 31 + this.returnType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.func, (Object)context.func)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.params, context.params)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.returnType, (Object)context.returnType);
        }
    }
}

