/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.ide.utils.PsiModificationUtil;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsExprKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/rust/ide/intentions/FlipBinaryExpressionIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/lang/core/psi/RsBinaryExpr;", "<init>", "()V", "getText", "", "getFamilyName", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "Helper", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nFlipBinaryExpressionIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlipBinaryExpressionIntention.kt\norg/rust/ide/intentions/FlipBinaryExpressionIntention\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n9#2:70\n1#3:71\n*S KotlinDebug\n*F\n+ 1 FlipBinaryExpressionIntention.kt\norg/rust/ide/intentions/FlipBinaryExpressionIntention\n*L\n29#1:70\n*E\n"})
public final class FlipBinaryExpressionIntention
extends RsElementBaseIntentionAction<RsBinaryExpr> {
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.flip.binary.expression", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    @Override
    @Nullable
    public RsBinaryExpr findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$ancestorStrict$iv = element;
        boolean $i$f$ancestorStrict = false;
        RsBinaryExpr rsBinaryExpr = (RsBinaryExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsBinaryExpr.class, (boolean)true);
        if (rsBinaryExpr == null) {
            return null;
        }
        RsBinaryExpr binaryExpr = rsBinaryExpr;
        if (!Intrinsics.areEqual((Object)element.getParent(), (Object)binaryExpr.getBinaryOp())) {
            return null;
        }
        if (binaryExpr.getRight() == null) {
            return null;
        }
        if (!PsiModificationUtil.INSTANCE.canReplace(binaryExpr)) {
            return null;
        }
        PsiElement op = RsExprKt.getOperator(binaryExpr);
        String opText = op.getText();
        IElementType iElementType = PsiElementExtensionsKt.getElementType(op);
        if (Helper.INSTANCE.getCOMMUNICATIVE_OPERATORS().contains(iElementType)) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)opText);
            objectArray[0] = opText;
            string = RsBundle.INSTANCE.message("intention.name.flip", objectArray);
        } else if (Helper.INSTANCE.getCHANGE_SEMANTICS_OPERATORS().contains(iElementType)) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)opText);
            objectArray[0] = opText;
            string = RsBundle.INSTANCE.message("intention.name.flip.changes.semantics", objectArray);
        } else if (Helper.INSTANCE.getCOMPARISON_OPERATORS().contains(iElementType)) {
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNull((Object)opText);
            objectArray[0] = opText;
            objectArray[1] = Helper.INSTANCE.flippedOp(opText);
            string = RsBundle.INSTANCE.message("intention.name.flip.to", objectArray);
        } else {
            return null;
        }
        this.setText(string);
        return binaryExpr;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull RsBinaryExpr ctx) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object object = ctx.getRight();
        if (object == null || (object = object.getText()) == null) {
            return;
        }
        Object right = object;
        String left = ctx.getLeft().getText();
        String string2 = RsExprKt.getOperator(ctx).getText();
        if (string2 != null) {
            String it2 = string2;
            boolean bl = false;
            string = Helper.INSTANCE.flippedOp(it2);
        } else {
            string = null;
        }
        String op = string;
        ctx.replace(new RsPsiFactory(project, false, false, 6, null).createExpression((String)right + " " + op + " " + left));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/intentions/FlipBinaryExpressionIntention$Helper;", "", "<init>", "()V", "COMMUNICATIVE_OPERATORS", "", "Lcom/intellij/psi/tree/IElementType;", "getCOMMUNICATIVE_OPERATORS", "()Ljava/util/List;", "CHANGE_SEMANTICS_OPERATORS", "getCHANGE_SEMANTICS_OPERATORS", "COMPARISON_OPERATORS", "getCOMPARISON_OPERATORS", "flippedOp", "", "op", "intellij.rustrover.core"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();
        @NotNull
        private static final List<IElementType> COMMUNICATIVE_OPERATORS;
        @NotNull
        private static final List<IElementType> CHANGE_SEMANTICS_OPERATORS;
        @NotNull
        private static final List<IElementType> COMPARISON_OPERATORS;

        private Helper() {
        }

        @NotNull
        public final List<IElementType> getCOMMUNICATIVE_OPERATORS() {
            return COMMUNICATIVE_OPERATORS;
        }

        @NotNull
        public final List<IElementType> getCHANGE_SEMANTICS_OPERATORS() {
            return CHANGE_SEMANTICS_OPERATORS;
        }

        @NotNull
        public final List<IElementType> getCOMPARISON_OPERATORS() {
            return COMPARISON_OPERATORS;
        }

        @NotNull
        public final String flippedOp(@NotNull String op) {
            Intrinsics.checkNotNullParameter((Object)op, (String)"op");
            return switch (op) {
                case ">" -> "<";
                case ">=" -> "<=";
                case "<" -> ">";
                case "<=" -> ">=";
                default -> op;
            };
        }

        static {
            Object[] objectArray = new IElementType[]{RsElementTypes.PLUS, RsElementTypes.MUL, RsElementTypes.AND, RsElementTypes.OR, RsElementTypes.XOR, RsElementTypes.EQEQ, RsElementTypes.EXCLEQ};
            COMMUNICATIVE_OPERATORS = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new IElementType[]{RsElementTypes.MINUS, RsElementTypes.DIV, RsElementTypes.REM, RsElementTypes.ANDAND, RsElementTypes.OROR, RsElementTypes.GTGT, RsElementTypes.LTLT};
            CHANGE_SEMANTICS_OPERATORS = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new IElementType[]{RsElementTypes.GT, RsElementTypes.GTEQ, RsElementTypes.LT, RsElementTypes.LTEQ};
            COMPARISON_OPERATORS = CollectionsKt.listOf((Object[])objectArray);
        }
    }
}

