/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.ide.utils.PsiInsertionPlace;
import org.rust.ide.utils.PsiModificationUtil;
import org.rust.ide.utils.WhiteSpaceUtil;
import org.rust.lang.core.psi.RsModDeclItem;
import org.rust.lang.core.psi.RsModItem;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsVis;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsModDeclItemKt;
import org.rust.openapiext.Testmark;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/rust/ide/intentions/ExtractInlineModuleIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/lang/core/psi/RsModItem;", "<init>", "()V", "getFamilyName", "", "getText", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "psiFile", "Lcom/intellij/psi/PsiFile;", "Testmarks", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nExtractInlineModuleIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractInlineModuleIntention.kt\norg/rust/ide/intentions/ExtractInlineModuleIntention\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,74:1\n15#2:75\n*S KotlinDebug\n*F\n+ 1 ExtractInlineModuleIntention.kt\norg/rust/ide/intentions/ExtractInlineModuleIntention\n*L\n31#1:75\n*E\n"})
public final class ExtractInlineModuleIntention
extends RsElementBaseIntentionAction<RsModItem> {
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.extract.inline.module.structure", new Object[0]);
    }

    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.extract.inline.module", new Object[0]);
    }

    @Override
    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    @Override
    @Nullable
    public RsModItem findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$ancestorOrSelf$iv = element;
        boolean $i$f$ancestorOrSelf = false;
        RsModItem rsModItem = (RsModItem)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsModItem.class, (boolean)false);
        if (rsModItem == null) {
            return null;
        }
        RsModItem mod = rsModItem;
        if (!Intrinsics.areEqual((Object)element, (Object)mod.getMod()) && !Intrinsics.areEqual((Object)element, (Object)mod.getIdentifier())) {
            RsVis rsVis = mod.getVis();
            if (!(rsVis != null ? PsiElementKt.isAncestorOf(rsVis, element) : false)) {
                return null;
            }
        }
        if (!PsiModificationUtil.INSTANCE.canReplace(mod)) {
            return null;
        }
        return mod;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull RsModItem ctx) {
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String string = ctx.getName();
        if (string == null) {
            return;
        }
        String modName = string;
        Object decl = new RsPsiFactory(project, false, false, 6, null).createModDeclItem(modName);
        Object object = PsiInsertionPlace.Companion.before(ctx);
        if (object == null || (object = (RsModDeclItem)object.insert((PsiElement)decl)) == null) {
            return;
        }
        decl = object;
        if (!Intrinsics.areEqual((Object)ctx.getFirstChild(), (Object)ctx.getMod())) {
            Testmarks.CopyAttrs.INSTANCE.hit();
            decl.addRangeBefore(ctx.getFirstChild(), ctx.getMod().getPrevSibling(), decl.getMod());
        }
        PsiFile psiFile = RsModDeclItemKt.getOrCreateModuleFile((RsModDeclItem)decl);
        if (psiFile == null) {
            return;
        }
        PsiFile modFile = psiFile;
        PsiElement psiElement3 = ctx.getLbrace().getNextSibling();
        if (psiElement3 == null) {
            return;
        }
        PsiElement startElement = psiElement3;
        PsiElement psiElement4 = ctx.getRbrace();
        if (psiElement4 == null || (psiElement4 = psiElement4.getPrevSibling()) == null) {
            return;
        }
        PsiElement endElement = psiElement4;
        if (startElement instanceof PsiWhiteSpace) {
            PsiElement psiElement5 = PsiElementExtensionsKt.getNextNonWhitespaceSibling(startElement);
            if (psiElement5 == null) {
                return;
            }
            PsiElement nonWhiteSpaceStartElement = psiElement5;
            modFile.addRange(startElement, nonWhiteSpaceStartElement.getPrevSibling());
            psiElement2 = modFile.addRange(nonWhiteSpaceStartElement, endElement);
        } else {
            psiElement2 = modFile.addRange(startElement, endElement);
        }
        PsiElement firstAdded = psiElement2;
        PsiElement psiElement6 = PsiElementExtensionsKt.getPrevNonWhitespaceSibling(firstAdded);
        if (psiElement6 != null) {
            PsiElement lastExisted = psiElement6;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)firstAdded);
            WhiteSpaceUtil.ensureLineFeedsBetween$default(WhiteSpaceUtil.INSTANCE, lastExisted, firstAdded, null, false, 12, null);
        }
        ctx.delete();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/rust/ide/intentions/ExtractInlineModuleIntention$Testmarks;", "", "<init>", "()V", "CopyAttrs", "intellij.rustrover.core"})
    public static final class Testmarks {
        @NotNull
        public static final Testmarks INSTANCE = new Testmarks();

        private Testmarks() {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/ide/intentions/ExtractInlineModuleIntention$Testmarks$CopyAttrs;", "Lorg/rust/openapiext/Testmark;", "<init>", "()V", "intellij.rustrover.core"})
        public static final class CopyAttrs
        extends Testmark {
            @NotNull
            public static final CopyAttrs INSTANCE = new CopyAttrs();

            private CopyAttrs() {
            }
        }
    }
}

