/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsBinaryOp;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsParenExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.ext.BinaryOperator;
import org.rust.lang.core.psi.ext.LogicOp;
import org.rust.lang.core.psi.ext.RsBinaryOpKt;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.utils.RsBooleanExpUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\f\u0010\u0017\u001a\u00020\n*\u00020\nH\u0002J \u0010\u0018\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020!H\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\u00062\u0006\u0010%\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lorg/rust/ide/intentions/DemorgansLawIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/ide/intentions/DemorgansLawIntention$Context;", "<init>", "()V", "getFamilyName", "", "setTextForElement", "", "element", "Lorg/rust/lang/core/psi/RsBinaryExpr;", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/psi/PsiElement;", "invoke", "ctx", "getTopmostBinaryExprWithSameOpType", "applyDemorgan", "topBinExpr", "opType", "Lorg/rust/lang/core/psi/ext/BinaryOperator;", "canOmitParensFor", "", "Lorg/rust/lang/core/psi/ext/LogicOp;", "isConjunctionExpression", "expression", "Lorg/rust/lang/core/psi/RsExpr;", "convertLeafExpression", "condition", "convertConjunctionExpression", "exp", "Context", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nDemorgansLawIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DemorgansLawIntention.kt\norg/rust/ide/intentions/DemorgansLawIntention\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,145:1\n9#2:146\n*S KotlinDebug\n*F\n+ 1 DemorgansLawIntention.kt\norg/rust/ide/intentions/DemorgansLawIntention\n*L\n39#1:146\n*E\n"})
public final class DemorgansLawIntention
extends RsElementBaseIntentionAction<Context> {
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.demorgan.s.law", new Object[0]);
    }

    private final void setTextForElement(RsBinaryExpr element) {
        BinaryOperator binaryOperator = RsExprKt.getOperatorType(element);
        this.setText(Intrinsics.areEqual((Object)binaryOperator, (Object)LogicOp.AND.INSTANCE) ? RsBundle.INSTANCE.message("intention.name.demorgan.s.law.replace.with2", new Object[0]) : (Intrinsics.areEqual((Object)binaryOperator, (Object)LogicOp.OR.INSTANCE) ? RsBundle.INSTANCE.message("intention.name.demorgan.s.law.replace.with", new Object[0]) : ""));
    }

    @Override
    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    @Override
    @Nullable
    public Context findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$ancestorStrict$iv = element;
        boolean $i$f$ancestorStrict = false;
        RsBinaryExpr rsBinaryExpr = (RsBinaryExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsBinaryExpr.class, (boolean)true);
        if (rsBinaryExpr == null) {
            return null;
        }
        RsBinaryExpr binExpr = rsBinaryExpr;
        BinaryOperator opType = RsExprKt.getOperatorType(binExpr);
        if (opType instanceof LogicOp) {
            this.setTextForElement(binExpr);
            return new Context(binExpr, opType);
        }
        return null;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        RsBinaryExpr binaryExpr = ctx.component1();
        BinaryOperator opType = ctx.component2();
        RsBinaryExpr topBinaryExpr = this.getTopmostBinaryExprWithSameOpType(binaryExpr);
        this.applyDemorgan(project, topBinaryExpr, opType);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final RsBinaryExpr getTopmostBinaryExprWithSameOpType(RsBinaryExpr $this$getTopmostBinaryExprWithSameOpType) {
        RsBinaryExpr rsBinaryExpr;
        PsiElement parent2 = $this$getTopmostBinaryExprWithSameOpType.getParent();
        if (parent2 instanceof RsBinaryExpr) {
            RsBinaryOp rsBinaryOp = ((RsBinaryExpr)parent2).getBinaryOp();
            Intrinsics.checkNotNullExpressionValue((Object)rsBinaryOp, (String)"getBinaryOp(...)");
            String string = RsBinaryOpKt.getOp(rsBinaryOp);
            RsBinaryOp rsBinaryOp2 = $this$getTopmostBinaryExprWithSameOpType.getBinaryOp();
            Intrinsics.checkNotNullExpressionValue((Object)rsBinaryOp2, (String)"getBinaryOp(...)");
            if (Intrinsics.areEqual((Object)string, (Object)RsBinaryOpKt.getOp(rsBinaryOp2))) {
                rsBinaryExpr = this.getTopmostBinaryExprWithSameOpType((RsBinaryExpr)parent2);
                return rsBinaryExpr;
            }
        }
        rsBinaryExpr = $this$getTopmostBinaryExprWithSameOpType;
        return rsBinaryExpr;
    }

    private final void applyDemorgan(Project project, RsBinaryExpr topBinExpr, BinaryOperator opType) {
        Pair pair;
        PsiElement parent2;
        String string = this.convertConjunctionExpression(topBinExpr, opType);
        if (string == null) {
            return;
        }
        String converted = string;
        PsiElement psiElement2 = topBinExpr.getParent();
        Object object = parent2 = psiElement2 != null ? psiElement2.getParent() : null;
        if (parent2 != null && RsBooleanExpUtilsKt.isNegation(parent2)) {
            PsiElement grandParent = parent2.getParent();
            LogicOp convertedOpType = Intrinsics.areEqual((Object)opType, (Object)LogicOp.OR.INSTANCE) ? (LogicOp)LogicOp.AND.INSTANCE : (LogicOp)LogicOp.OR.INSTANCE;
            Intrinsics.checkNotNull((Object)grandParent);
            boolean canOmitParens = this.canOmitParensFor(grandParent, convertedOpType);
            Object expString = canOmitParens ? converted : "(" + converted + ")";
            pair = TuplesKt.to((Object)expString, (Object)((RsExpr)parent2));
        } else {
            pair = TuplesKt.to((Object)("!(" + converted + ")"), (Object)topBinExpr);
        }
        Pair pair2 = pair;
        String expString = (String)pair2.component1();
        RsExpr expressionToReplace = (RsExpr)pair2.component2();
        RsExpr newExpr = new RsPsiFactory(project, false, false, 6, null).createExpression(expString);
        expressionToReplace.replace(newExpr);
    }

    private final boolean canOmitParensFor(PsiElement $this$canOmitParensFor, LogicOp opType) {
        if (!($this$canOmitParensFor instanceof RsBinaryExpr)) {
            return true;
        }
        RsBinaryOp rsBinaryOp = ((RsBinaryExpr)$this$canOmitParensFor).getBinaryOp();
        Intrinsics.checkNotNullExpressionValue((Object)rsBinaryOp, (String)"getBinaryOp(...)");
        BinaryOperator binaryOperator = RsExprKt.getOperatorType(rsBinaryOp);
        return Intrinsics.areEqual((Object)binaryOperator, (Object)LogicOp.AND.INSTANCE) ? Intrinsics.areEqual((Object)opType, (Object)LogicOp.AND.INSTANCE) : Intrinsics.areEqual((Object)binaryOperator, (Object)LogicOp.OR.INSTANCE);
    }

    private final boolean isConjunctionExpression(RsExpr expression, BinaryOperator opType) {
        return expression instanceof RsBinaryExpr && Intrinsics.areEqual((Object)RsExprKt.getOperatorType((RsBinaryExpr)expression), (Object)opType);
    }

    private final String convertLeafExpression(RsExpr condition) {
        Object object;
        if (RsBooleanExpUtilsKt.isNegation(condition)) {
            Intrinsics.checkNotNull((Object)condition, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsUnaryExpr");
            Object object2 = ((RsUnaryExpr)condition).getExpr();
            if (object2 == null || (object2 = object2.getText()) == null) {
                object2 = "";
            }
            return object2;
        }
        RsExpr rsExpr = condition;
        if (rsExpr instanceof RsParenExpr) {
            RsExpr c = ((RsParenExpr)condition).getExpr();
            int level = 1;
            while (c instanceof RsParenExpr) {
                ++level;
                c = ((RsParenExpr)c).getExpr();
            }
            object = c instanceof RsBinaryExpr && !(RsExprKt.getOperatorType((RsBinaryExpr)c) instanceof LogicOp) ? StringsKt.repeat((CharSequence)"(", (int)level) + RsBooleanExpUtilsKt.negateToString((RsBinaryExpr)c) + StringsKt.repeat((CharSequence)")", (int)level) : "!" + ((RsParenExpr)condition).getText();
        } else {
            object = rsExpr instanceof RsBinaryExpr ? RsBooleanExpUtilsKt.negateToString((RsBinaryExpr)condition) : "!" + condition.getText();
        }
        return object;
    }

    private final String convertConjunctionExpression(RsBinaryExpr exp, BinaryOperator opType) {
        String rhsText;
        String lhsText;
        RsExpr rsExpr = exp.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getLeft(...)");
        RsExpr lhs = rsExpr;
        String string = lhsText = this.isConjunctionExpression(lhs, opType) ? this.convertConjunctionExpression((RsBinaryExpr)lhs, opType) : this.convertLeafExpression(lhs);
        if (exp.getRight() == null) {
            return null;
        }
        RsExpr rsExpr2 = exp.getRight();
        if (rsExpr2 == null) {
            return null;
        }
        RsExpr rhs = rsExpr2;
        String string2 = rhsText = this.isConjunctionExpression(rhs, opType) ? this.convertConjunctionExpression((RsBinaryExpr)rhs, opType) : this.convertLeafExpression(rhs);
        String flippedConjunction = Intrinsics.areEqual((Object)RsExprKt.getOperatorType(exp), (Object)opType) ? (Intrinsics.areEqual((Object)opType, (Object)LogicOp.AND.INSTANCE) ? "||" : "&&") : RsExprKt.getOperator(exp).getText();
        return lhsText + " " + flippedConjunction + " " + rhsText;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/intentions/DemorgansLawIntention$Context;", "", "binaryExpr", "Lorg/rust/lang/core/psi/RsBinaryExpr;", "binaryOpType", "Lorg/rust/lang/core/psi/ext/BinaryOperator;", "<init>", "(Lorg/rust/lang/core/psi/RsBinaryExpr;Lorg/rust/lang/core/psi/ext/BinaryOperator;)V", "getBinaryExpr", "()Lorg/rust/lang/core/psi/RsBinaryExpr;", "getBinaryOpType", "()Lorg/rust/lang/core/psi/ext/BinaryOperator;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final RsBinaryExpr binaryExpr;
        @NotNull
        private final BinaryOperator binaryOpType;

        public Context(@NotNull RsBinaryExpr binaryExpr, @NotNull BinaryOperator binaryOpType) {
            Intrinsics.checkNotNullParameter((Object)binaryExpr, (String)"binaryExpr");
            Intrinsics.checkNotNullParameter((Object)binaryOpType, (String)"binaryOpType");
            this.binaryExpr = binaryExpr;
            this.binaryOpType = binaryOpType;
        }

        @NotNull
        public final RsBinaryExpr getBinaryExpr() {
            return this.binaryExpr;
        }

        @NotNull
        public final BinaryOperator getBinaryOpType() {
            return this.binaryOpType;
        }

        @NotNull
        public final RsBinaryExpr component1() {
            return this.binaryExpr;
        }

        @NotNull
        public final BinaryOperator component2() {
            return this.binaryOpType;
        }

        @NotNull
        public final Context copy(@NotNull RsBinaryExpr binaryExpr, @NotNull BinaryOperator binaryOpType) {
            Intrinsics.checkNotNullParameter((Object)binaryExpr, (String)"binaryExpr");
            Intrinsics.checkNotNullParameter((Object)binaryOpType, (String)"binaryOpType");
            return new Context(binaryExpr, binaryOpType);
        }

        public static /* synthetic */ Context copy$default(Context context, RsBinaryExpr rsBinaryExpr, BinaryOperator binaryOperator, int n, Object object) {
            if ((n & 1) != 0) {
                rsBinaryExpr = context.binaryExpr;
            }
            if ((n & 2) != 0) {
                binaryOperator = context.binaryOpType;
            }
            return context.copy(rsBinaryExpr, binaryOperator);
        }

        @NotNull
        public String toString() {
            return "Context(binaryExpr=" + this.binaryExpr + ", binaryOpType=" + this.binaryOpType + ")";
        }

        public int hashCode() {
            int result2 = this.binaryExpr.hashCode();
            result2 = result2 * 31 + this.binaryOpType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.binaryExpr, (Object)context.binaryExpr)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.binaryOpType, (Object)context.binaryOpType);
        }
    }
}

