/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.inspections.import.AutoImportFix;
import org.rust.ide.inspections.import.AutoImportFixContext;
import org.rust.ide.intentions.ConvertMethodCallToUFCSIntentionKt;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.SelfType;
import org.rust.ide.utils.PsiModificationUtil;
import org.rust.ide.utils.import.ImportCandidate;
import org.rust.ide.utils.import.ImportUtilsKt;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.RsDotExpr;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsMethodOrFieldKt;
import org.rust.lang.core.resolve.ref.MethodResolveVariant;
import org.rust.lang.core.stubs.RsPlaceholderStub;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.infer.RsInferenceResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/intentions/ConvertMethodCallToUFCSIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/ide/intentions/ConvertMethodCallToUFCSIntention$Context;", "<init>", "()V", "getText", "", "getFamilyName", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "Context", "intellij.rustrover.core"})
public final class ConvertMethodCallToUFCSIntention
extends RsElementBaseIntentionAction<Context> {
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.convert.to.ufcs", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @Nullable
    public Context findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        List methodVariants;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement2 = element.getParent();
        RsMethodCall rsMethodCall = psiElement2 instanceof RsMethodCall ? (RsMethodCall)psiElement2 : null;
        if (rsMethodCall == null) {
            return null;
        }
        RsMethodCall methodCall = rsMethodCall;
        RsElement rsElement = methodCall.getReference().resolve();
        RsFunction rsFunction = rsElement instanceof RsFunction ? (RsFunction)rsElement : null;
        if (rsFunction == null) {
            return null;
        }
        RsFunction function = rsFunction;
        RsInferenceResult rsInferenceResult = ExtensionsKt.getInference(methodCall);
        List list = rsInferenceResult != null ? rsInferenceResult.getResolvedMethod(methodCall) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if ((methodVariants = list).isEmpty()) {
            return null;
        }
        if (!PsiModificationUtil.INSTANCE.canReplace(methodCall.getParent())) {
            return null;
        }
        return new Context(methodCall, function, methodVariants);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull Context ctx) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            RsMethodCall methodCall = ctx.getMethodCall();
            RsFunction function = ctx.getFunction();
            String string = function.getName();
            if (string == null) {
                return;
            }
            String functionName = string;
            RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
            SelfType selfType = ConvertMethodCallToUFCSIntentionKt.access$getSelfType(function);
            if (selfType == null) {
                return;
            }
            SelfType selfType2 = selfType;
            RsExpr receiver = RsMethodOrFieldKt.getReceiver(methodCall);
            String prefix = ConvertMethodCallToUFCSIntentionKt.access$getSelfArgumentPrefix(selfType2, receiver);
            RsExpr selfArgument = factory2.createExpression(prefix + receiver.getText());
            Collection collection = CollectionsKt.listOf((Object)selfArgument);
            List<RsExpr> list = methodCall.getValueArgumentList().getExprList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
            List arguments = CollectionsKt.plus((Collection)collection, (Iterable)list);
            String ownerName = ConvertMethodCallToUFCSIntentionKt.access$getOwnerName(ctx.getMethodVariants());
            RsCallExpr ufcs = factory2.createAssocFunctionCall(ownerName, functionName, arguments);
            RsDotExpr parentDot = methodCall.getParent();
            PsiElement psiElement2 = parentDot.replace(ufcs);
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsCallExpr");
            RsCallExpr inserted = (RsCallExpr)psiElement2;
            RsExpr rsExpr = inserted.getExpr();
            StubBasedPsiElement<RsPlaceholderStub<?>> stubBasedPsiElement = rsExpr instanceof RsPathExpr ? (RsPathExpr)rsExpr : null;
            if (stubBasedPsiElement == null || (stubBasedPsiElement = stubBasedPsiElement.getPath()) == null) {
                return;
            }
            StubBasedPsiElement<RsPlaceholderStub<?>> path = stubBasedPsiElement;
            AutoImportFixContext importCtx = AutoImportFix.Companion.findApplicableContext$default(AutoImportFix.Companion, (RsPath)path, null, false, 6, null);
            Object object = importCtx;
            if (object == null || (object = ((AutoImportFixContext)object).getCandidates()) == null || (object = (ImportCandidate)CollectionsKt.firstOrNull((List)object)) == null) break block3;
            ImportUtilsKt.import((ImportCandidate)object, (RsElement)inserted);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/rust/ide/intentions/ConvertMethodCallToUFCSIntention$Context;", "", "methodCall", "Lorg/rust/lang/core/psi/RsMethodCall;", "function", "Lorg/rust/lang/core/psi/RsFunction;", "methodVariants", "", "Lorg/rust/lang/core/resolve/ref/MethodResolveVariant;", "<init>", "(Lorg/rust/lang/core/psi/RsMethodCall;Lorg/rust/lang/core/psi/RsFunction;Ljava/util/List;)V", "getMethodCall", "()Lorg/rust/lang/core/psi/RsMethodCall;", "getFunction", "()Lorg/rust/lang/core/psi/RsFunction;", "getMethodVariants", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final RsMethodCall methodCall;
        @NotNull
        private final RsFunction function;
        @NotNull
        private final List<MethodResolveVariant> methodVariants;

        public Context(@NotNull RsMethodCall methodCall, @NotNull RsFunction function, @NotNull List<MethodResolveVariant> methodVariants) {
            Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter(methodVariants, (String)"methodVariants");
            this.methodCall = methodCall;
            this.function = function;
            this.methodVariants = methodVariants;
        }

        @NotNull
        public final RsMethodCall getMethodCall() {
            return this.methodCall;
        }

        @NotNull
        public final RsFunction getFunction() {
            return this.function;
        }

        @NotNull
        public final List<MethodResolveVariant> getMethodVariants() {
            return this.methodVariants;
        }

        @NotNull
        public final RsMethodCall component1() {
            return this.methodCall;
        }

        @NotNull
        public final RsFunction component2() {
            return this.function;
        }

        @NotNull
        public final List<MethodResolveVariant> component3() {
            return this.methodVariants;
        }

        @NotNull
        public final Context copy(@NotNull RsMethodCall methodCall, @NotNull RsFunction function, @NotNull List<MethodResolveVariant> methodVariants) {
            Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter(methodVariants, (String)"methodVariants");
            return new Context(methodCall, function, methodVariants);
        }

        public static /* synthetic */ Context copy$default(Context context, RsMethodCall rsMethodCall, RsFunction rsFunction, List list, int n, Object object) {
            if ((n & 1) != 0) {
                rsMethodCall = context.methodCall;
            }
            if ((n & 2) != 0) {
                rsFunction = context.function;
            }
            if ((n & 4) != 0) {
                list = context.methodVariants;
            }
            return context.copy(rsMethodCall, rsFunction, list);
        }

        @NotNull
        public String toString() {
            return "Context(methodCall=" + this.methodCall + ", function=" + this.function + ", methodVariants=" + this.methodVariants + ")";
        }

        public int hashCode() {
            int result2 = this.methodCall.hashCode();
            result2 = result2 * 31 + this.function.hashCode();
            result2 = result2 * 31 + ((Object)this.methodVariants).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.methodCall, (Object)context.methodCall)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.function, (Object)context.function)) {
                return false;
            }
            return Intrinsics.areEqual(this.methodVariants, context.methodVariants);
        }
    }
}

