/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.intentions.ConvertFunctionToClosureIntention;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.ide.utils.PsiModificationUtil;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsLetDecl;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsRetType;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.openapiext.EditorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J \u0010\u0016\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/rust/ide/intentions/ConvertFunctionToClosureIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/ide/intentions/ConvertFunctionToClosureIntention$Context;", "<init>", "()V", "getText", "", "getFamilyName", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "doInvoke", "function", "Lorg/rust/lang/core/psi/RsFunction;", "Context", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nConvertFunctionToClosureIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertFunctionToClosureIntention.kt\norg/rust/ide/intentions/ConvertFunctionToClosureIntention\n+ 2 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,66:1\n84#2:67\n84#2:68\n*S KotlinDebug\n*F\n+ 1 ConvertFunctionToClosureIntention.kt\norg/rust/ide/intentions/ConvertFunctionToClosureIntention\n*L\n31#1:67\n40#1:68\n*E\n"})
public final class ConvertFunctionToClosureIntention
extends RsElementBaseIntentionAction<Context> {
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.convert.function.to.closure", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    @Override
    @Nullable
    public Context findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        int n;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$contextStrict$iv = element;
        boolean $i$f$contextStrict = false;
        RsFunction rsFunction = (RsFunction)PsiTreeUtil.getContextOfType((PsiElement)$this$contextStrict$iv, RsFunction.class, (boolean)true);
        if (rsFunction == null) {
            return null;
        }
        RsFunction possibleTarget = rsFunction;
        PsiElement psiElement2 = possibleTarget.getFn();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getFn(...)");
        int n2 = PsiElementKt.getStartOffset(psiElement2);
        RsRetType rsRetType = possibleTarget.getRetType();
        if (rsRetType != null) {
            n = PsiElementKt.getEndOffset(rsRetType);
        } else {
            RsValueParameterList rsValueParameterList = possibleTarget.getValueParameterList();
            if (rsValueParameterList != null) {
                n = PsiElementKt.getEndOffset(rsValueParameterList);
            } else {
                return null;
            }
        }
        TextRange availabilityRange = new TextRange(n2, n);
        if (!availabilityRange.contains(PsiElementKt.getStartOffset(element))) {
            return null;
        }
        $this$contextStrict$iv = possibleTarget;
        $i$f$contextStrict = false;
        if (PsiTreeUtil.getContextOfType((PsiElement)$this$contextStrict$iv, RsFunction.class, (boolean)true) == null) {
            return null;
        }
        if (possibleTarget.getTypeParameterList() != null) {
            return null;
        }
        if (!PsiModificationUtil.INSTANCE.canReplace(possibleTarget)) {
            return null;
        }
        return new Context(possibleTarget);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.doInvoke(project, editor2, ctx.getTargetFunction());
    }

    public final void doInvoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsFunction function) {
        block3: {
            Object object;
            Object returnText;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
            String parametersText2 = CollectionsKt.joinToString$default((Iterable)RsFunctionKt.getRawValueParameters(function), (CharSequence)", ", null, null, (int)0, null, (Function1)doInvoke.parametersText.1.INSTANCE, (int)30, null);
            Object object2 = function.getRetType();
            if (object2 == null || (object2 = object2.getText()) == null) {
                object2 = returnText = "";
            }
            if ((object = RsFunctionKt.getBlock(function)) == null || (object = object.getText()) == null) {
                return;
            }
            Object bodyText = object;
            RsLambdaExpr lambda = factory2.createLambda("|" + parametersText2 + "| " + (String)returnText + " " + (String)bodyText);
            String string = function.getIdentifier().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            RsLetDecl declaration = RsPsiFactory.createLetDeclaration$default(factory2, string, lambda, false, null, 12, null);
            PsiElement psiElement2 = function.replace(declaration);
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsLetDecl");
            RsLetDecl replaced = (RsLetDecl)psiElement2;
            PsiElement psiElement3 = replaced.getSemicolon();
            if (psiElement3 == null) break block3;
            int it2 = PsiElementKt.getEndOffset(psiElement3);
            boolean bl = false;
            Editor editor3 = editor2;
            if (editor3 != null) {
                EditorKt.moveCaretToOffset(editor3, replaced, it2);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/intentions/ConvertFunctionToClosureIntention$Context;", "", "targetFunction", "Lorg/rust/lang/core/psi/RsFunction;", "<init>", "(Lorg/rust/lang/core/psi/RsFunction;)V", "getTargetFunction", "()Lorg/rust/lang/core/psi/RsFunction;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final RsFunction targetFunction;

        public Context(@NotNull RsFunction targetFunction) {
            Intrinsics.checkNotNullParameter((Object)targetFunction, (String)"targetFunction");
            this.targetFunction = targetFunction;
        }

        @NotNull
        public final RsFunction getTargetFunction() {
            return this.targetFunction;
        }

        @NotNull
        public final RsFunction component1() {
            return this.targetFunction;
        }

        @NotNull
        public final Context copy(@NotNull RsFunction targetFunction) {
            Intrinsics.checkNotNullParameter((Object)targetFunction, (String)"targetFunction");
            return new Context(targetFunction);
        }

        public static /* synthetic */ Context copy$default(Context context, RsFunction rsFunction, int n, Object object) {
            if ((n & 1) != 0) {
                rsFunction = context.targetFunction;
            }
            return context.copy(rsFunction);
        }

        @NotNull
        public String toString() {
            return "Context(targetFunction=" + this.targetFunction + ")";
        }

        public int hashCode() {
            return this.targetFunction.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            return Intrinsics.areEqual((Object)this.targetFunction, (Object)context.targetFunction);
        }
    }
}

