/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.intentions.ListIntentionBase;
import org.rust.ide.utils.PsiModificationUtil;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B-\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/rust/ide/intentions/ChopListIntentionBase;", "TList", "Lorg/rust/lang/core/psi/ext/RsElement;", "TElement", "Lorg/rust/ide/intentions/ListIntentionBase;", "listClass", "Ljava/lang/Class;", "elementClass", "intentionText", "", "<init>", "(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/String;)V", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiElement;)Lorg/rust/lang/core/psi/ext/RsElement;", "invoke", "", "ctx", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/rust/lang/core/psi/ext/RsElement;)V", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nChopListIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChopListIntention.kt\norg/rust/ide/intentions/ChopListIntentionBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1740#2,3:103\n1869#2,2:107\n1#3:106\n*S KotlinDebug\n*F\n+ 1 ChopListIntention.kt\norg/rust/ide/intentions/ChopListIntentionBase\n*L\n30#1:103,3\n45#1:107,2\n*E\n"})
public abstract class ChopListIntentionBase<TList extends RsElement, TElement extends RsElement>
extends ListIntentionBase<TList, TElement> {
    public ChopListIntentionBase(@NotNull Class<TList> listClass, @NotNull Class<TElement> elementClass, @IntentionName @NotNull String intentionText) {
        Intrinsics.checkNotNullParameter(listClass, (String)"listClass");
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        Intrinsics.checkNotNullParameter((Object)intentionText, (String)"intentionText");
        super(listClass, elementClass, intentionText);
    }

    @Override
    @Nullable
    public TList findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Object list;
        block11: {
            block10: {
                boolean bl;
                block9: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Object TList = this.getListContext(element);
                    if (TList == null) {
                        return null;
                    }
                    list = TList;
                    List<PsiElement> elements2 = this.getElements(list);
                    if (elements2.size() < 2) break block10;
                    Iterable $this$all$iv = CollectionsKt.dropLast(elements2, (int)1);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PsiElement it2 = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if (this.hasLineBreakAfter(list, it2)) continue;
                            bl = false;
                            break block9;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block11;
            }
            return null;
        }
        if (!PsiModificationUtil.INSTANCE.canReplace((PsiElement)list)) {
            return null;
        }
        return list;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull TList ctx) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int startOffset = PsiElementKt.getStartOffset((PsiElement)ctx);
            List<PsiElement> elements2 = this.getElements(ctx);
            PsiElement last = (PsiElement)CollectionsKt.last(elements2);
            if (!this.hasLineBreakAfter(ctx, last)) {
                TextRange textRange = this.getEndElement(ctx, last).getTextRange();
                if (textRange != null) {
                    Integer n = textRange.getEndOffset();
                    int it2 = ((Number)n).intValue();
                    boolean bl = false;
                    document2.insertString(it2, (CharSequence)"\n");
                }
            }
            Iterable $this$forEach$iv = CollectionsKt.asReversed(elements2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement it3 = (PsiElement)element$iv;
                boolean bl = false;
                if (this.hasLineBreakBefore(it3)) continue;
                document2.insertString(PsiElementKt.getStartOffset(it3), (CharSequence)"\n");
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.commitDocument(document2);
            PsiFile psiFile = documentManager.getPsiFile(document2);
            if (psiFile == null) break block4;
            Object object = psiFile.findElementAt(startOffset);
            if (object != null && (object = this.getListContext((PsiElement)object)) != null) {
                Object object2;
                Object it4 = object2 = object;
                boolean bl = false;
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(psiFile, it4.getTextRange());
            }
        }
    }
}

