/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.intentions.RsElementBaseIntentionAction;
import org.rust.ide.intentions.util.macros.InvokeInside;
import org.rust.lang.core.psi.RsMetaItemArgs;
import org.rust.lang.core.psi.RsOuterAttr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElement;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElementKt;
import org.rust.openapiext.EditorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0017H\u0002R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/rust/ide/intentions/AddDeriveIntention;", "Lorg/rust/ide/intentions/RsElementBaseIntentionAction;", "Lorg/rust/ide/intentions/AddDeriveIntention$Context;", "<init>", "()V", "getFamilyName", "", "getText", "attributeMacroHandlingStrategy", "Lorg/rust/ide/intentions/util/macros/InvokeInside;", "getAttributeMacroHandlingStrategy", "()Lorg/rust/ide/intentions/util/macros/InvokeInside;", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "findOrCreateDeriveAttr", "Lorg/rust/lang/core/psi/RsOuterAttr;", "item", "Lorg/rust/lang/core/psi/ext/RsStructOrEnumItemElement;", "keyword", "moveCaret", "deriveAttr", "Context", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nAddDeriveIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddDeriveIntention.kt\norg/rust/ide/intentions/AddDeriveIntention\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,62:1\n9#2:63\n*S KotlinDebug\n*F\n+ 1 AddDeriveIntention.kt\norg/rust/ide/intentions/AddDeriveIntention\n*L\n33#1:63\n*E\n"})
public final class AddDeriveIntention
extends RsElementBaseIntentionAction<Context> {
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.name.add.derive.clause", new Object[0]);
    }

    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.add.derive.clause", new Object[0]);
    }

    @Override
    @NotNull
    public InvokeInside getAttributeMacroHandlingStrategy() {
        return InvokeInside.MACRO_CALL;
    }

    @Override
    @Nullable
    public Context findApplicableContext(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$ancestorStrict$iv = element;
        boolean $i$f$ancestorStrict = false;
        RsStructOrEnumItemElement rsStructOrEnumItemElement = (RsStructOrEnumItemElement)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsStructOrEnumItemElement.class, (boolean)true);
        if (rsStructOrEnumItemElement == null) {
            return null;
        }
        RsStructOrEnumItemElement item = rsStructOrEnumItemElement;
        PsiElement psiElement2 = RsStructOrEnumItemElementKt.getFirstKeyword(item);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement keyword = psiElement2;
        return new Context(item, keyword);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        RsOuterAttr deriveAttr = this.findOrCreateDeriveAttr(project, ctx.getItem(), ctx.getItemStart());
        this.moveCaret(editor2, deriveAttr);
    }

    private final RsOuterAttr findOrCreateDeriveAttr(Project project, RsStructOrEnumItemElement item, PsiElement keyword) {
        RsOuterAttr existingDeriveAttr = RsDocAndAttributeOwnerKt.findOuterAttr(item, "derive");
        if (existingDeriveAttr != null) {
            return existingDeriveAttr;
        }
        RsOuterAttr attr = new RsPsiFactory(project, false, false, 6, null).createOuterAttr("derive()");
        PsiElement psiElement2 = item.addBefore(attr, keyword);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsOuterAttr");
        return (RsOuterAttr)psiElement2;
    }

    private final void moveCaret(Editor editor2, RsOuterAttr deriveAttr) {
        RsMetaItemArgs rsMetaItemArgs = deriveAttr.getMetaItem().getMetaItemArgs();
        int offset = rsMetaItemArgs != null && (rsMetaItemArgs = rsMetaItemArgs.getRparen()) != null ? rsMetaItemArgs.getTextOffset() : deriveAttr.getRbrack().getTextOffset();
        EditorKt.moveCaretToOffset(editor2, deriveAttr, offset);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/rust/ide/intentions/AddDeriveIntention$Context;", "", "item", "Lorg/rust/lang/core/psi/ext/RsStructOrEnumItemElement;", "itemStart", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lorg/rust/lang/core/psi/ext/RsStructOrEnumItemElement;Lcom/intellij/psi/PsiElement;)V", "getItem", "()Lorg/rust/lang/core/psi/ext/RsStructOrEnumItemElement;", "getItemStart", "()Lcom/intellij/psi/PsiElement;", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final RsStructOrEnumItemElement item;
        @NotNull
        private final PsiElement itemStart;

        public Context(@NotNull RsStructOrEnumItemElement item, @NotNull PsiElement itemStart) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)itemStart, (String)"itemStart");
            this.item = item;
            this.itemStart = itemStart;
        }

        @NotNull
        public final RsStructOrEnumItemElement getItem() {
            return this.item;
        }

        @NotNull
        public final PsiElement getItemStart() {
            return this.itemStart;
        }
    }
}

