/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.ide.utils.ExprUtilsKt;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsCondition;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLoopExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.RsWhileExpr;
import org.rust.lang.core.psi.ext.PsiElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016R\u0014\u0010\u0010\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/inspections/lints/RsWhileTrueLoopInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getDisplayName", "", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "isSyntaxOnly", "()Z", "isDumbAware", "UseLoopFix", "intellij.rustrover.core"})
public final class RsWhileTrueLoopInspection
extends RsLintInspection {
    private final boolean isSyntaxOnly;

    public RsWhileTrueLoopInspection() {
        this.isSyntaxOnly = true;
    }

    @NotNull
    public String getDisplayName() {
        return RsBundle.INSTANCE.message("while.true.loop", new Object[0]);
    }

    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.WhileTrue.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsWhileTrueLoopInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitWhileExpr(RsWhileExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCondition rsCondition = o.getCondition();
                if (rsCondition == null) {
                    return;
                }
                RsCondition condition = rsCondition;
                RsExpr rsExpr = ExprUtilsKt.skipParenExprDown(condition);
                RsLitExpr rsLitExpr = rsExpr instanceof RsLitExpr ? (RsLitExpr)rsExpr : null;
                if (rsLitExpr == null) {
                    return;
                }
                RsLitExpr expr = rsLitExpr;
                if (o.getBlock() == null) {
                    return;
                }
                if (expr.textMatches("true")) {
                    PsiElement psiElement2 = o;
                    String string = RsBundle.INSTANCE.message("inspection.message.denote.infinite.loops.with.loop", new Object[0]);
                    TextRange textRange = TextRange.create((int)o.getWhile().getStartOffsetInParent(), (int)PsiElementKt.getEndOffsetInParent(condition));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
                    this.this$0.registerLintProblem(this.$holder, psiElement2, string, textRange, RsLintHighlightingType.Companion.getWEAK_WARNING(), CollectionsKt.listOf((Object)((Object)new UseLoopFix(o))));
                }
            }
        };
    }

    @Override
    public boolean isSyntaxOnly() {
        return this.isSyntaxOnly;
    }

    @Override
    public boolean isDumbAware() {
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/inspections/lints/RsWhileTrueLoopInspection$UseLoopFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsWhileExpr;", "element", "<init>", "(Lorg/rust/lang/core/psi/RsWhileExpr;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
    private static final class UseLoopFix
    extends RsQuickFixBase<RsWhileExpr> {
        public UseLoopFix(@NotNull RsWhileExpr element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super((PsiElement)element);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return RsBundle.INSTANCE.message("intention.family.name.use.loop", new Object[0]);
        }

        @Override
        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @Override
        public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsWhileExpr element) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            RsBlock rsBlock = element.getBlock();
            if (rsBlock == null) {
                return;
            }
            RsBlock block = rsBlock;
            Object object = element.getLabelDecl();
            if (object == null || (object = object.getText()) == null) {
                object = "";
            }
            Object label = object;
            RsExpr rsExpr = new RsPsiFactory(project, false, false, 6, null).createExpression((String)label + "loop " + block.getText());
            Intrinsics.checkNotNull((Object)rsExpr, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsLoopExpr");
            RsLoopExpr loopExpr = (RsLoopExpr)rsExpr;
            element.replace(loopExpr);
        }
    }
}

