/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.RemoveElementFix;
import org.rust.ide.injected.RsDoctestLanguageInjectorKt;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.lang.core.psi.RsAssertEqMacroArgument;
import org.rust.lang.core.psi.RsAssertMacroArgument;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsBindingMode;
import org.rust.lang.core.psi.RsConcatMacroArgument;
import org.rust.lang.core.psi.RsEnvMacroArgument;
import org.rust.lang.core.psi.RsExprMacroArgument;
import org.rust.lang.core.psi.RsFormatMacroArg;
import org.rust.lang.core.psi.RsFormatMacroArgument;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsSelfParameter;
import org.rust.lang.core.psi.RsTupleExpr;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.RsValueArgumentList;
import org.rust.lang.core.psi.RsVecMacroArgument;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsMacroCallKt;
import org.rust.lang.core.psi.ext.RsPatBindingKt;
import org.rust.lang.core.psi.ext.RsSelfParameterKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\tR\u0018\u0010\u0012\u001a\u00020\u000f*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/inspections/lints/RsUnusedMutInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getDisplayName", "", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkOccurrenceNeedMutable", "occurrence", "isMutable", "Lorg/rust/lang/core/psi/RsUnaryExpr;", "(Lorg/rust/lang/core/psi/RsUnaryExpr;)Z", "RsRemoveUnusedMutFix", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsUnusedMutInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsUnusedMutInspection.kt\norg/rust/ide/inspections/lints/RsUnusedMutInspection\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,77:1\n364#2,2:78\n364#2,2:80\n*S KotlinDebug\n*F\n+ 1 RsUnusedMutInspection.kt\norg/rust/ide/inspections/lints/RsUnusedMutInspection\n*L\n64#1:78,2\n65#1:80,2\n*E\n"})
public final class RsUnusedMutInspection
extends RsLintInspection {
    @NotNull
    public String getDisplayName() {
        return RsBundle.INSTANCE.message("no.mutable.required", new Object[0]);
    }

    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.UnusedMut.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsUnusedMutInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitBindingMode(RsBindingMode o) {
                boolean bl;
                block8: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                    Object object = o.getParent();
                    RsPatBinding rsPatBinding = object instanceof RsPatBinding ? (RsPatBinding)object : null;
                    if (rsPatBinding == null) {
                        return;
                    }
                    RsPatBinding patBinding = rsPatBinding;
                    if (!RsPatBindingKt.getMutability(patBinding).isMut()) {
                        return;
                    }
                    if (RsDoctestLanguageInjectorKt.isDoctestInjection(patBinding)) {
                        return;
                    }
                    Iterable iterable = RsElementKt.searchReferencesAfterExpansion(patBinding).asIterable();
                    object = this.this$0;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PsiReference it2 = (PsiReference)element$iv;
                            boolean bl2 = false;
                            PsiElement psiElement2 = it2.getElement().getParent();
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
                            if (!((RsUnusedMutInspection)((Object)object)).checkOccurrenceNeedMutable(psiElement2)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                PsiElement psiElement3 = o.getMut();
                if (psiElement3 == null) {
                    return;
                }
                PsiElement mut = psiElement3;
                RsLintInspection.registerLintProblem$default((RsLintInspection)this.this$0, this.$holder, mut, RsBundle.INSTANCE.message("inspection.message.unused.mut", new Object[0]), RsLintHighlightingType.Companion.getUNUSED_SYMBOL(), CollectionsKt.listOf((Object)((Object)new RsRemoveUnusedMutFix(mut))), null, 16, null);
            }
        };
    }

    public final boolean checkOccurrenceNeedMutable(@NotNull PsiElement occurrence) {
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        Pair<PsiElement, PsiElement> pair = PsiElementKt.contextAndThisSkipMacroExpr(occurrence);
        PsiElement parent2 = (PsiElement)pair.component1();
        PsiElement child = (PsiElement)pair.component2();
        PsiElement psiElement2 = parent2;
        if (psiElement2 instanceof RsUnaryExpr) {
            return this.isMutable((RsUnaryExpr)parent2) || ((RsUnaryExpr)parent2).getMul() != null;
        }
        if (psiElement2 instanceof RsBinaryExpr) {
            return Intrinsics.areEqual((Object)((RsBinaryExpr)parent2).getLeft(), (Object)child);
        }
        if (psiElement2 instanceof RsMethodCall) {
            RsElement rsElement = ((RsMethodCall)parent2).getReference().resolve();
            RsFunction rsFunction = rsElement instanceof RsFunction ? (RsFunction)rsElement : null;
            if (rsFunction == null) {
                return true;
            }
            RsFunction ref = rsFunction;
            RsSelfParameter rsSelfParameter = RsFunctionKt.getSelfParameter(ref);
            if (rsSelfParameter == null) {
                return true;
            }
            RsSelfParameter self = rsSelfParameter;
            return RsSelfParameterKt.getMutability(self).isMut();
        }
        if (psiElement2 instanceof RsTupleExpr) {
            PsiElement psiElement3 = PsiElementKt.contextSkipMacroExpr(parent2);
            RsUnaryExpr rsUnaryExpr = psiElement3 instanceof RsUnaryExpr ? (RsUnaryExpr)psiElement3 : null;
            if (rsUnaryExpr == null) {
                return true;
            }
            RsUnaryExpr expr = rsUnaryExpr;
            return this.isMutable(expr);
        }
        if (psiElement2 instanceof RsValueArgumentList) {
            return false;
        }
        if (psiElement2 instanceof RsExprMacroArgument || psiElement2 instanceof RsVecMacroArgument || psiElement2 instanceof RsAssertMacroArgument || psiElement2 instanceof RsAssertEqMacroArgument || psiElement2 instanceof RsConcatMacroArgument || psiElement2 instanceof RsEnvMacroArgument) {
            return false;
        }
        if (psiElement2 instanceof RsFormatMacroArg) {
            boolean isWriteMacro;
            PsiElement $this$contextOfType_u24default$iv = parent2;
            boolean withSelf$iv = false;
            boolean $i$f$contextOfType = false;
            RsFormatMacroArgument rsFormatMacroArgument = (RsFormatMacroArgument)PsiTreeUtil.getContextOfType((PsiElement)$this$contextOfType_u24default$iv, RsFormatMacroArgument.class, (boolean)true);
            if (rsFormatMacroArgument == null) {
                return true;
            }
            RsFormatMacroArgument argList = rsFormatMacroArgument;
            PsiElement $this$contextOfType_u24default$iv2 = argList;
            boolean withSelf$iv2 = false;
            boolean $i$f$contextOfType2 = false;
            RsMacroCall rsMacroCall = (RsMacroCall)PsiTreeUtil.getContextOfType((PsiElement)$this$contextOfType_u24default$iv2, RsMacroCall.class, (boolean)true);
            if (rsMacroCall == null) {
                return true;
            }
            RsMacroCall macroCall = rsMacroCall;
            String macroName = RsMacroCallKt.getMacroName(macroCall);
            boolean bl = isWriteMacro = Intrinsics.areEqual((Object)macroName, (Object)"write") || Intrinsics.areEqual((Object)macroName, (Object)"writeln");
            if (!isWriteMacro) {
                return false;
            }
            List<RsFormatMacroArg> list = argList.getFormatMacroArgList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"<get-formatMacroArgList>(...)");
            return Intrinsics.areEqual((Object)CollectionsKt.firstOrNull(list), (Object)parent2);
        }
        return true;
    }

    private final boolean isMutable(RsUnaryExpr $this$isMutable) {
        return $this$isMutable.getMut() != null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/inspections/lints/RsUnusedMutInspection$RsRemoveUnusedMutFix;", "Lorg/rust/ide/fixes/RemoveElementFix;", "mut", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "intellij.rustrover.core"})
    public static final class RsRemoveUnusedMutFix
    extends RemoveElementFix {
        public RsRemoveUnusedMutFix(@NotNull PsiElement mut) {
            Intrinsics.checkNotNullParameter((Object)mut, (String)"mut");
            super(mut, null, 2, null);
        }
    }
}

