/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.codeInspection.LocalQuickFix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.rust.RsBundle;
import org.rust.ide.fixes.AddQuestionMarkFix;
import org.rust.ide.inspections.lints.AddAwaitFix;
import org.rust.ide.inspections.lints.FixAddExpect;
import org.rust.ide.inspections.lints.FixAddLetUnderscore;
import org.rust.ide.inspections.lints.FixAddUnwrap;
import org.rust.ide.inspections.lints.InspectionResult;
import org.rust.lang.core.psi.KnownProcMacroKind;
import org.rust.lang.core.psi.ProcMacroAttribute;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsMethodCallExpr;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsItemElement;
import org.rust.lang.core.resolve.KnownItems;
import org.rust.lang.core.resolve.KnownItemsKt;
import org.rust.lang.core.types.BoundElement;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.FunctionCallContext;
import org.rust.lang.core.types.FunctionCallContextKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.core.types.ty.TyDynamic;
import org.rust.lang.core.types.ty.TyOpaque;
import org.rust.lang.core.types.ty.TyUnknown;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0002H\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0019\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a-\u0010\f\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0001*\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"returnsStdResult", "", "Lorg/rust/lang/core/psi/RsExpr;", "inspectAndProposeFixes", "Lorg/rust/ide/inspections/lints/InspectionResult;", "expr", "isAsyncHardcodedProcMacro", "function", "Lorg/rust/lang/core/psi/RsFunction;", "checkFuncMustUse", "", "Lorg/jetbrains/annotations/Nls;", "checkTypeMustUse", "type", "Lorg/rust/lang/core/types/ty/Ty;", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "hasMustUseAttr", "Lorg/rust/lang/core/psi/ext/RsItemElement;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsUnusedMustUseInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsUnusedMustUseInspection.kt\norg/rust/ide/inspections/lints/RsUnusedMustUseInspectionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1#2:187\n1761#3,3:188\n1563#3:191\n1634#3,3:192\n295#3,2:195\n*S KotlinDebug\n*F\n+ 1 RsUnusedMustUseInspection.kt\norg/rust/ide/inspections/lints/RsUnusedMustUseInspectionKt\n*L\n112#1:188,3\n150#1:191\n150#1:192,3\n151#1:195,2\n*E\n"})
public final class RsUnusedMustUseInspectionKt {
    private static final boolean returnsStdResult(RsExpr $this$returnsStdResult) {
        KnownItems knownItems = (KnownItems)ExtensionsKt.getImplLookupAndKnownItems($this$returnsStdResult).component2();
        Ty ty2 = ExtensionsKt.getType($this$returnsStdResult);
        TyAdt tyAdt = ty2 instanceof TyAdt ? (TyAdt)ty2 : null;
        if (tyAdt == null) {
            return false;
        }
        TyAdt type = tyAdt;
        return Intrinsics.areEqual((Object)type.getItem(), (Object)knownItems.getResult());
    }

    private static final InspectionResult inspectAndProposeFixes(RsExpr expr) {
        RsFunction function;
        List fixes = new ArrayList();
        RsExpr rsExpr = expr;
        if (rsExpr instanceof RsMethodCallExpr) {
            RsMethodCall rsMethodCall = ((RsMethodCallExpr)expr).getMethodCall();
            Intrinsics.checkNotNullExpressionValue((Object)rsMethodCall, (String)"getMethodCall(...)");
            FunctionCallContext functionCallContext = FunctionCallContextKt.getFunctionCallContext(rsMethodCall);
            v2 = functionCallContext != null ? functionCallContext.getFunction() : null;
        } else if (rsExpr instanceof RsCallExpr) {
            FunctionCallContext functionCallContext = FunctionCallContextKt.getFunctionCallContext((RsCallExpr)expr);
            v2 = functionCallContext != null ? functionCallContext.getFunction() : null;
        } else {
            v2 = function = null;
        }
        if (RsUnusedMustUseInspectionKt.isAsyncHardcodedProcMacro(function)) {
            return null;
        }
        String string = RsUnusedMustUseInspectionKt.checkTypeMustUse(ExtensionsKt.getType(expr), expr, fixes);
        if (string == null && (string = RsUnusedMustUseInspectionKt.checkFuncMustUse(function)) == null) {
            return null;
        }
        String description = string;
        if (RsUnusedMustUseInspectionKt.returnsStdResult(expr)) {
            AddQuestionMarkFix addQuestionMarkFix = AddQuestionMarkFix.Companion.createIfCompatible(expr, ExtensionsKt.getType(expr), null);
            if (addQuestionMarkFix != null) {
                AddQuestionMarkFix it2 = addQuestionMarkFix;
                boolean bl = false;
                ((Collection)fixes).add(it2);
            }
            ((Collection)fixes).add(new FixAddExpect(expr));
            ((Collection)fixes).add(new FixAddUnwrap(expr));
        }
        ((Collection)fixes).add(new FixAddLetUnderscore(expr));
        return new InspectionResult(description, fixes);
    }

    private static final boolean isAsyncHardcodedProcMacro(RsFunction function) {
        boolean bl;
        block4: {
            if (function == null) {
                return false;
            }
            List<KnownProcMacroKind> hardcodedProcMacros = ProcMacroAttribute.Companion.getHardcodedProcMacroAttributes(function);
            Iterable $this$any$iv = hardcodedProcMacros;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KnownProcMacroKind it2 = (KnownProcMacroKind)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(it2 == KnownProcMacroKind.ASYNC_MAIN || it2 == KnownProcMacroKind.ASYNC_TEST || it2 == KnownProcMacroKind.ASYNC_BENCH)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final String checkFuncMustUse(RsFunction function) {
        if (function == null || !RsUnusedMustUseInspectionKt.hasMustUseAttr(function)) {
            return null;
        }
        Object[] objectArray = new Object[]{String.valueOf(function.getName())};
        return RsBundle.INSTANCE.message("inspection.UnusedMustUse.description.function.attribute", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final String checkTypeMustUse(Ty type, RsExpr expr, List<LocalQuickFix> fixes) {
        Object object;
        Ty ty2 = type;
        if (ty2 instanceof TyAdt) {
            if (Intrinsics.areEqual((Object)((TyAdt)type).getItem(), (Object)KnownItemsKt.getKnownItems(expr).getBox())) {
                Ty ty3 = (Ty)CollectionsKt.firstOrNull(((TyAdt)type).getTypeArguments());
                if (ty3 == null) {
                    return null;
                }
                Ty inner = ty3;
                return RsUnusedMustUseInspectionKt.checkTypeMustUse(inner, expr, fixes);
            }
            if (RsUnusedMustUseInspectionKt.hasMustUseAttr(((TyAdt)type).getItem())) {
                if (!(ExtensionsKt.getImplLookup(expr).lookupFutureOutputTy(type, true).getValue() instanceof TyUnknown)) {
                    ((Collection)fixes).add(new AddAwaitFix(expr));
                }
                object = type.toString();
            } else {
                object = null;
            }
        } else if (ty2 instanceof TyDynamic) {
            RsTraitItem rsTraitItem = ((TyDynamic)type).getBaseTrait();
            if (rsTraitItem == null) {
                return null;
            }
            RsTraitItem trait = rsTraitItem;
            if (!RsUnusedMustUseInspectionKt.hasMustUseAttr(trait)) {
                return null;
            }
            if (Intrinsics.areEqual((Object)trait, (Object)KnownItemsKt.getKnownItems(expr).getFuture())) {
                ((Collection)fixes).add(new AddAwaitFix(expr));
            }
            object = "dyn " + trait.getName();
        } else if (ty2 instanceof TyOpaque) {
            Object v3;
            block19: {
                void $this$firstOrNull$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = ((TyOpaque)type).getTraits();
                boolean $i$f$map = false;
                Iterator iterator2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    BoundElement boundElement = (BoundElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((RsTraitItem)it2.getElement());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RsTraitItem it3 = (RsTraitItem)element$iv;
                    boolean bl = false;
                    if (!RsUnusedMustUseInspectionKt.hasMustUseAttr(it3)) continue;
                    v3 = element$iv;
                    break block19;
                }
                v3 = null;
            }
            RsTraitItem rsTraitItem = v3;
            if (rsTraitItem == null) {
                return null;
            }
            RsTraitItem trait = rsTraitItem;
            if (Intrinsics.areEqual((Object)trait, (Object)KnownItemsKt.getKnownItems(expr).getFuture())) {
                ((Collection)fixes).add(new AddAwaitFix(expr));
            }
            object = "impl " + trait.getName();
        } else {
            object = null;
        }
        if (object == null) {
            return null;
        }
        String typeText = object;
        Object[] objectArray = new Object[]{typeText};
        return RsBundle.INSTANCE.message("inspection.UnusedMustUse.description.type.attribute", objectArray);
    }

    private static final boolean hasMustUseAttr(RsItemElement $this$hasMustUseAttr) {
        return RsDocAndAttributeOwnerKt.findFirstMetaItem($this$hasMustUseAttr, "must_use") != null;
    }

    public static final /* synthetic */ InspectionResult access$inspectAndProposeFixes(RsExpr expr) {
        return RsUnusedMustUseInspectionKt.inspectAndProposeFixes(expr);
    }
}

