/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.OptimiseImportsFix;
import org.rust.ide.fixes.RemoveImportFix;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.injected.RsDoctestLanguageInjectorKt;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.PathUsageMap;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.ide.inspections.lints.RsPathUsageAnalysisKt;
import org.rust.ide.inspections.lints.RsUnusedImportInspectionKt;
import org.rust.lang.core.crate.impl.DoctestCrate;
import org.rust.lang.core.macros.proc.ProcMacroApplicationService;
import org.rust.lang.core.psi.RsUseGroup;
import org.rust.lang.core.psi.RsUseItem;
import org.rust.lang.core.psi.RsUseSpeck;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsItemsOwner;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002%&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001fH\u0002J&\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0!2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010#\u001a\u00020$H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006'"}, d2={"Lorg/rust/ide/inspections/lints/RsUnusedImportInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "ignoreDoctest", "", "getIgnoreDoctest", "()Z", "setIgnoreDoctest", "(Z)V", "enableOnlyIfProcMacrosEnabled", "getEnableOnlyIfProcMacrosEnabled", "setEnableOnlyIfProcMacrosEnabled", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "getShortName", "", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "storeUseSpeckUsage", "", "useSpeck", "Lorg/rust/lang/core/psi/RsUseSpeck;", "usage", "Lorg/rust/ide/inspections/lints/PathUsageMap;", "unusedSpeckSet", "", "markUnusedSpecks", "", "markAsUnused", "createOptionsPanel", "Ljavax/swing/JComponent;", "Helper", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsUnusedImportInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsUnusedImportInspection.kt\norg/rust/ide/inspections/lints/RsUnusedImportInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,300:1\n1869#2,2:301\n1761#2,3:303\n1869#2,2:306\n*S KotlinDebug\n*F\n+ 1 RsUnusedImportInspection.kt\norg/rust/ide/inspections/lints/RsUnusedImportInspection\n*L\n79#1:301,2\n82#1:303,3\n99#1:306,2\n*E\n"})
public final class RsUnusedImportInspection
extends RsLintInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean ignoreDoctest = true;
    private boolean enableOnlyIfProcMacrosEnabled = true;
    @NotNull
    public static final String SHORT_NAME = "RsUnusedImport";

    public final boolean getIgnoreDoctest() {
        return this.ignoreDoctest;
    }

    public final void setIgnoreDoctest(boolean bl) {
        this.ignoreDoctest = bl;
    }

    public final boolean getEnableOnlyIfProcMacrosEnabled() {
        return this.enableOnlyIfProcMacrosEnabled;
    }

    public final void setEnableOnlyIfProcMacrosEnabled(boolean bl) {
        this.enableOnlyIfProcMacrosEnabled = bl;
    }

    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.UnusedImports.INSTANCE;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsUnusedImportInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitUseItem2(RsUseItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                if (!RsUnusedImportInspectionKt.access$isApplicableForUseItem(item)) {
                    return;
                }
                if (this.this$0.getIgnoreDoctest() && item.getContainingCrate() instanceof DoctestCrate) {
                    return;
                }
                if (this.this$0.getEnableOnlyIfProcMacrosEnabled() && !ProcMacroApplicationService.Companion.isFullyEnabled() && !UtilsKt.isUnitTestMode()) {
                    return;
                }
                PsiElement psiElement2 = item.getContext();
                RsItemsOwner rsItemsOwner = psiElement2 instanceof RsItemsOwner ? (RsItemsOwner)psiElement2 : null;
                if (rsItemsOwner == null) {
                    return;
                }
                RsItemsOwner owner = rsItemsOwner;
                PathUsageMap usage = RsPathUsageAnalysisKt.getPathUsage(owner);
                RsUseSpeck rsUseSpeck = item.getUseSpeck();
                if (rsUseSpeck == null) {
                    return;
                }
                RsUseSpeck speck = rsUseSpeck;
                HashSet<E> unusedSpeckSet = new HashSet<E>();
                RsUnusedImportInspection.access$storeUseSpeckUsage(this.this$0, speck, usage, unusedSpeckSet);
                RsUnusedImportInspection.access$markUnusedSpecks(this.this$0, speck, unusedSpeckSet, this.$holder);
            }
        };
    }

    private final void storeUseSpeckUsage(RsUseSpeck useSpeck, PathUsageMap usage, Set<RsUseSpeck> unusedSpeckSet) {
        boolean isUsed;
        block7: {
            RsUseGroup group2 = useSpeck.getUseGroup();
            if (group2 == null) {
                v0 = RsUnusedImportInspectionKt.access$isUseSpeckUsed(useSpeck, usage);
            } else {
                RsUseSpeck it2;
                List<RsUseSpeck> list = group2.getUseSpeckList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getUseSpeckList(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it2 = (RsUseSpeck)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it2);
                    this.storeUseSpeckUsage(it2, usage, unusedSpeckSet);
                }
                List<RsUseSpeck> list2 = group2.getUseSpeckList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getUseSpeckList(...)");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it2 = (RsUseSpeck)element$iv;
                        boolean bl = false;
                        if (!(!unusedSpeckSet.contains(it2))) continue;
                        v0 = true;
                        break block7;
                    }
                    v0 = isUsed = false;
                }
            }
        }
        if (!isUsed) {
            unusedSpeckSet.add(useSpeck);
        }
    }

    private final void markUnusedSpecks(RsUseSpeck useSpeck, Set<? extends RsUseSpeck> unusedSpeckSet, RsProblemsHolder holder) {
        block2: {
            block1: {
                boolean used;
                boolean bl = used = !unusedSpeckSet.contains(useSpeck);
                if (used) break block1;
                this.markAsUnused(useSpeck, holder);
                break block2;
            }
            Object object = useSpeck.getUseGroup();
            if (object == null || (object = object.getUseSpeckList()) == null) break block2;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RsUseSpeck it2 = (RsUseSpeck)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it2);
                this.markUnusedSpecks(it2, unusedSpeckSet, holder);
            }
        }
    }

    private final void markAsUnused(RsUseSpeck useSpeck, RsProblemsHolder holder) {
        Object[] objectArray;
        List list;
        PsiElement element = RsUnusedImportInspectionKt.access$getHighlightElement(useSpeck);
        if (RsDoctestLanguageInjectorKt.isDoctestInjection(useSpeck)) {
            list = CollectionsKt.emptyList();
        } else {
            objectArray = new RsQuickFixBase[]{new RemoveImportFix(element), new OptimiseImportsFix(element)};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        List fixes = list;
        RsLintInspection rsLintInspection = this;
        objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)useSpeck.getText(), (String)"getText(...)");
        RsLintInspection.registerLintProblem$default(rsLintInspection, holder, element, RsBundle.INSTANCE.message("inspection.message.unused.import", objectArray), RsLintHighlightingType.Companion.getUNUSED_SYMBOL(), fixes, null, 16, null);
    }

    @NotNull
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel multipleCheckboxOptionsPanel;
        MultipleCheckboxOptionsPanel $this$createOptionsPanel_u24lambda_u240 = multipleCheckboxOptionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        boolean bl = false;
        $this$createOptionsPanel_u24lambda_u240.addCheckbox(RsBundle.INSTANCE.message("checkbox.ignore.unused.imports.in.doctests", new Object[0]), "ignoreDoctest");
        $this$createOptionsPanel_u24lambda_u240.addCheckbox(RsBundle.INSTANCE.message("checkbox.enable.inspection.only.if.procedural.macros.are.enabled", new Object[0]), "enableOnlyIfProcMacrosEnabled");
        return (JComponent)multipleCheckboxOptionsPanel;
    }

    public static final /* synthetic */ void access$storeUseSpeckUsage(RsUnusedImportInspection $this, RsUseSpeck useSpeck, PathUsageMap usage, Set unusedSpeckSet) {
        $this.storeUseSpeckUsage(useSpeck, usage, unusedSpeckSet);
    }

    public static final /* synthetic */ void access$markUnusedSpecks(RsUnusedImportInspection $this, RsUseSpeck useSpeck, Set unusedSpeckSet, RsProblemsHolder holder) {
        $this.markUnusedSpecks(useSpeck, unusedSpeckSet, holder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/inspections/lints/RsUnusedImportInspection$Companion;", "", "<init>", "()V", "SHORT_NAME", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/rust/ide/inspections/lints/RsUnusedImportInspection$Helper;", "", "<init>", "()V", "isEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "checkProcMacrosMatch", "profile", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "intellij.rustrover.core"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();

        private Helper() {
        }

        public final boolean isEnabled(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
            Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
            InspectionProfileImpl profile = inspectionProfileImpl;
            return profile.isToolEnabled(HighlightDisplayKey.find((String)RsUnusedImportInspection.SHORT_NAME)) && this.checkProcMacrosMatch(profile, project);
        }

        private final boolean checkProcMacrosMatch(InspectionProfileImpl profile, Project project) {
            InspectionToolWrapper toolWrapper;
            if (UtilsKt.isUnitTestMode()) {
                return true;
            }
            InspectionToolWrapper inspectionToolWrapper = toolWrapper = profile.getInspectionTool(RsUnusedImportInspection.SHORT_NAME, project);
            InspectionProfileEntry inspectionProfileEntry = inspectionToolWrapper != null ? inspectionToolWrapper.getTool() : null;
            RsUnusedImportInspection rsUnusedImportInspection = inspectionProfileEntry instanceof RsUnusedImportInspection ? (RsUnusedImportInspection)inspectionProfileEntry : null;
            if (rsUnusedImportInspection == null) {
                return true;
            }
            RsUnusedImportInspection tool = rsUnusedImportInspection;
            if (!tool.getEnableOnlyIfProcMacrosEnabled()) {
                return true;
            }
            return ProcMacroApplicationService.Companion.isFullyEnabled();
        }
    }
}

