/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.suggested.TextRangeUtilsKt;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.injected.RsDoctestLanguageInjectorKt;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsDeleteUnreachableCodeFix;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.lang.core.dfa.ControlFlowGraph;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/rust/ide/inspections/lints/RsUnreachableCodeInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getDisplayName", "", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "mergeRanges", "", "Lcom/intellij/openapi/util/TextRange;", "sortedRanges", "", "registerUnreachableProblem", "", "func", "Lorg/rust/lang/core/psi/RsFunction;", "range", "intellij.rustrover.core"})
public final class RsUnreachableCodeInspection
extends RsLintInspection {
    @NotNull
    public String getDisplayName() {
        return RsBundle.INSTANCE.message("inspection.message.unreachable.code", new Object[0]);
    }

    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.UnreachableCode.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsUnreachableCodeInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction2(RsFunction func) {
                void $this$mapTo$iv$iv;
                void $this$mapToMutableList$iv;
                RsElement it2;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Set<RsElement> set;
                Intrinsics.checkNotNullParameter((Object)func, (String)"func");
                if (RsDoctestLanguageInjectorKt.isDoctestInjection(func)) {
                    return;
                }
                ControlFlowGraph controlFlowGraph = ExtensionsKt.getControlFlowGraph(func);
                if (controlFlowGraph == null) {
                    return;
                }
                ControlFlowGraph controlFlowGraph2 = controlFlowGraph;
                Iterable<RsElement> it3 = set = controlFlowGraph2.getUnreachableElements();
                boolean bl = false;
                Set<RsElement> set2 = !((Collection)it3).isEmpty() ? set : null;
                if (set2 == null) {
                    return;
                }
                Set<RsElement> elementsToReport = set2;
                it3 = elementsToReport;
                boolean $i$f$filter = false;
                void var8_8 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (RsElement)element$iv$iv;
                    boolean bl2 = false;
                    if (!it2.isPhysical()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$mapToMutableList = false;
                $this$filterTo$iv$iv = $this$mapToMutableList$iv;
                destination$iv$iv = new ArrayList<E>(org.rust.stdext.CollectionsKt.collectionSizeOrDefault($this$mapToMutableList$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (RsElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(PsiElementKt.getRangeWithPrevSpace(it2));
                }
                List list = (List)destination$iv$iv;
                List $this$visitFunction2_u24lambda_u243 = list;
                boolean bl4 = false;
                Comparator comparator = Segment.BY_START_OFFSET_THEN_END_OFFSET;
                Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"BY_START_OFFSET_THEN_END_OFFSET");
                CollectionsKt.sortWith((List)$this$visitFunction2_u24lambda_u243, (Comparator)comparator);
                List it4 = list;
                boolean bl5 = false;
                Object object = !((Collection)it4).isEmpty() ? list : null;
                if (object == null) {
                    return;
                }
                List sortedRanges = object;
                Collection mergedRanges = RsUnreachableCodeInspection.access$mergeRanges(this.this$0, sortedRanges);
                for (TextRange range : mergedRanges) {
                    RsUnreachableCodeInspection.access$registerUnreachableProblem(this.this$0, this.$holder, func, range);
                }
            }
        };
    }

    private final Collection<TextRange> mergeRanges(List<? extends TextRange> sortedRanges) {
        ArrayDeque<TextRange> mergedRanges = new ArrayDeque<TextRange>();
        mergedRanges.add(sortedRanges.get(0));
        for (TextRange range : CollectionsKt.drop((Iterable)sortedRanges, (int)1)) {
            TextRange leftNeighbour = (TextRange)mergedRanges.peek();
            if (leftNeighbour.intersects(range)) {
                mergedRanges.pop();
                mergedRanges.push(leftNeighbour.union(range));
                continue;
            }
            mergedRanges.push(range);
        }
        return mergedRanges;
    }

    private final void registerUnreachableProblem(RsProblemsHolder holder, RsFunction func, TextRange range) {
        PsiFile psiFile = func.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        Object object = UtilsKt.getDocument(psiFile);
        if (object == null || (object = object.getImmutableCharSequence()) == null) {
            return;
        }
        Object chars = object;
        TextRange textRange = TextRangeUtilsKt.stripWhitespace((TextRange)range, (CharSequence)chars).shiftLeft(PsiElementKt.getStartOffset(func));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftLeft(...)");
        TextRange strippedRangeInFunction = textRange;
        PsiElement psiElement2 = func;
        String string = RsBundle.INSTANCE.message("inspection.message.unreachable.code", new Object[0]);
        RsLintHighlightingType rsLintHighlightingType = RsLintHighlightingType.Companion.getUNUSED_SYMBOL();
        PsiFile psiFile2 = func.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
        this.registerLintProblem(holder, psiElement2, string, strippedRangeInFunction, rsLintHighlightingType, CollectionsKt.listOf((Object)((Object)new RsDeleteUnreachableCodeFix(psiFile2, range))));
    }

    public static final /* synthetic */ Collection access$mergeRanges(RsUnreachableCodeInspection $this, List sortedRanges) {
        return $this.mergeRanges(sortedRanges);
    }

    public static final /* synthetic */ void access$registerUnreachableProblem(RsUnreachableCodeInspection $this, RsProblemsHolder holder, RsFunction func, TextRange range) {
        $this.registerUnreachableProblem(holder, func, range);
    }
}

