/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.ide.inspections.lints.RsRemoveReturn;
import org.rust.lang.core.macros.MacroExpansion;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsElseBranch;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsIfExpr;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsMacroExpr;
import org.rust.lang.core.psi.RsMatchArm;
import org.rust.lang.core.psi.RsMatchExpr;
import org.rust.lang.core.psi.RsRetExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsBlockKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsIfExprKt;
import org.rust.lang.core.psi.ext.RsMatchExprKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.lang.core.psi.ext.RsPossibleMacroCallKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/inspections/lints/RsUnnecessaryReturnInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "intellij.rustrover.core"})
public final class RsUnnecessaryReturnInspection
extends RsLintInspection {
    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.NeedlessReturn.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsUnnecessaryReturnInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitFunction2(RsFunction o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsBlock rsBlock = RsFunctionKt.getBlock(o);
                if (rsBlock == null) {
                    return;
                }
                this.checkFinalExpr(rsBlock);
            }

            /*
             * WARNING - void declaration
             */
            private final void checkFinalExpr(RsElement element) {
                RsElement rsElement = element;
                if (rsElement instanceof RsBlock) {
                    RsElement rsElement2 = (RsElement)SequencesKt.lastOrNull(RsBlockKt.getStmtsAndMacros((RsBlock)element));
                    if (rsElement2 == null) {
                        return;
                    }
                    this.checkFinalExpr(rsElement2);
                } else if (rsElement instanceof RsExprStmt) {
                    this.checkFinalExpr(((RsExprStmt)element).getExpr());
                } else if (rsElement instanceof RsMacroExpr) {
                    this.checkFinalExpr(((RsMacroExpr)element).getMacroCall());
                } else if (rsElement instanceof RsMacroCall) {
                    PsiElement psiElement2;
                    Object object;
                    MacroExpansion e = RsPossibleMacroCallKt.getExpansion((RsPossibleMacroCall)element);
                    PsiElement psiElement3 = e instanceof MacroExpansion.Stmts ? (PsiElement)((object = CollectionsKt.lastOrNull(((MacroExpansion.Stmts)e).getElements())) instanceof RsExprStmt ? (RsExprStmt)object : null) : (psiElement2 = e instanceof MacroExpansion.Expr ? (PsiElement)((MacroExpansion.Expr)e).getExpr() : null);
                    if (psiElement2 != null) {
                        PsiElement it2 = psiElement2;
                        boolean bl = false;
                        this.checkFinalExpr((RsElement)it2);
                    }
                } else if (rsElement instanceof RsRetExpr) {
                    RsRemoveReturn rsRemoveReturn;
                    PsiElement replacement;
                    RsExpr rsExpr = ((RsRetExpr)element).getExpr();
                    if (rsExpr == null) {
                        return;
                    }
                    RsExpr value = rsExpr;
                    PsiElement psiElement4 = replacement = ((RsRetExpr)element).getContext() instanceof RsExprStmt ? ((RsRetExpr)element).getContext() : (PsiElement)element;
                    if (psiElement4 != null) {
                        PsiElement it3 = psiElement4;
                        boolean bl = false;
                        String string = value.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        rsRemoveReturn = new RsRemoveReturn(it3, string);
                    } else {
                        rsRemoveReturn = null;
                    }
                    RsRemoveReturn fix = rsRemoveReturn;
                    RsLintInspection rsLintInspection = this.this$0;
                    PsiElement psiElement5 = ((RsRetExpr)element).getReturn();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"getReturn(...)");
                    RsLintInspection.registerLintProblem$default(rsLintInspection, this.$holder, psiElement5, RsBundle.INSTANCE.message("inspection.UnnecessaryReturn.description", new Object[0]), RsLintHighlightingType.Companion.getUNUSED_SYMBOL(), CollectionsKt.listOfNotNull((Object)((Object)fix)), null, 16, null);
                } else if (rsElement instanceof RsIfExpr) {
                    RsBlockExpr rsBlockExpr = ((RsIfExpr)element).getBlockExpr();
                    this.checkFinalExpr(rsBlockExpr != null ? rsBlockExpr.getBlock() : null);
                    RsElseBranch rsElseBranch = ((RsIfExpr)element).getElseBranch();
                    this.checkFinalExpr(rsElseBranch != null ? RsIfExprKt.getBlock(rsElseBranch) : null);
                } else if (rsElement instanceof RsMatchExpr) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = RsMatchExprKt.getArms((RsMatchExpr)element);
                    boolean $i$f$mapNotNull = false;
                    Iterable bl = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        RsExpr it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl2 = false;
                        RsMatchArm it4 = (RsMatchArm)element$iv$iv;
                        boolean bl3 = false;
                        if (it4.getExpr() == null) continue;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List arms = (List)destination$iv$iv;
                    for (RsExpr arm : arms) {
                        this.checkFinalExpr(arm);
                    }
                } else if (rsElement instanceof RsBlockExpr) {
                    this.checkFinalExpr(((RsBlockExpr)element).getBlock());
                }
            }
        };
    }
}

