/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.RemoveRedundantParenthesesFix;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.ide.refactoring.inlineValue.RsInlineValueProcessorKt;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsCondition;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsFieldLookupExpr;
import org.rust.lang.core.psi.RsForExpr;
import org.rust.lang.core.psi.RsLetDecl;
import org.rust.lang.core.psi.RsLetExpr;
import org.rust.lang.core.psi.RsMatchExpr;
import org.rust.lang.core.psi.RsNamedFieldDecl;
import org.rust.lang.core.psi.RsParenExpr;
import org.rust.lang.core.psi.RsRangeExpr;
import org.rust.lang.core.psi.RsRetExpr;
import org.rust.lang.core.psi.RsStructLiteral;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.AssignmentOp;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.psi.ext.UnaryOperator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/inspections/lints/RsUnnecessaryParenthesesInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "Helper", "intellij.rustrover.core"})
public final class RsUnnecessaryParenthesesInspection
extends RsLintInspection {
    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.UnusedParens.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsUnnecessaryParenthesesInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitParenExpr(RsParenExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsExpr rsExpr = o.getExpr();
                if (rsExpr == null) {
                    return;
                }
                if (!Helper.INSTANCE.needParens(o, rsExpr)) {
                    RemoveRedundantParenthesesFix fix = new RemoveRedundantParenthesesFix(o);
                    PsiElement psiElement2 = o.getParent();
                    String message = psiElement2 instanceof RsCondition ? RsBundle.INSTANCE.message("inspection.message.predicate.expression.has.unnecessary.parentheses", new Object[0]) : (psiElement2 instanceof RsRetExpr ? RsBundle.INSTANCE.message("inspection.message.return.expression.has.unnecessary.parentheses", new Object[0]) : (psiElement2 instanceof RsMatchExpr ? RsBundle.INSTANCE.message("inspection.message.match.expression.has.unnecessary.parentheses", new Object[0]) : (psiElement2 instanceof RsForExpr ? RsBundle.INSTANCE.message("inspection.message.for.loop.expression.has.unnecessary.parentheses", new Object[0]) : RsBundle.INSTANCE.message("inspection.rs.unnecessary.parentheses.inspection.display.name", new Object[0]))));
                    PsiElement psiElement3 = o.getRparen();
                    if (psiElement3 == null) {
                        return;
                    }
                    PsiElement rparen = psiElement3;
                    RsLintInspection rsLintInspection = this.this$0;
                    PsiElement psiElement4 = o.getLparen();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getLparen(...)");
                    RsLintInspection.registerLintProblem$default(rsLintInspection, this.$holder, psiElement4, message, RsLintHighlightingType.Companion.getUNUSED_PARENS(), CollectionsKt.listOf((Object)((Object)fix)), null, 16, null);
                    RsLintInspection.registerLintProblem$default((RsLintInspection)this.this$0, this.$holder, rparen, message, RsLintHighlightingType.Companion.getUNUSED_PARENS(), CollectionsKt.listOf((Object)((Object)fix)), null, 16, null);
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                    RsProblemsHolder.registerProblem$default(this.$holder, (PsiElement)o, message, ProblemHighlightType.INFORMATION, new TextRange(1, o.getTextLength() - 1), localQuickFixArray, false, null, 96, null);
                }
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lorg/rust/ide/inspections/lints/RsUnnecessaryParenthesesInspection$Helper;", "", "<init>", "()V", "needParens", "", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "inner", "isInsideExprOfLetDecl", "isSimpleAssignExpr", "Lorg/rust/lang/core/psi/RsBinaryExpr;", "isCallOfField", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsUnnecessaryParenthesesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsUnnecessaryParenthesesInspection.kt\norg/rust/ide/inspections/lints/RsUnnecessaryParenthesesInspection$Helper\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,97:1\n9#2:98\n124#3:99\n1255#4,2:100\n*S KotlinDebug\n*F\n+ 1 RsUnnecessaryParenthesesInspection.kt\norg/rust/ide/inspections/lints/RsUnnecessaryParenthesesInspection$Helper\n*L\n61#1:98\n69#1:99\n81#1:100,2\n*E\n"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();

        private Helper() {
        }

        public final boolean needParens(@NotNull RsExpr expr, @NotNull RsExpr inner) {
            UnaryOperator[] unaryOperatorArray;
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
            PsiElement parent2 = expr.getParent();
            if (parent2 instanceof RsParenExpr) {
                return true;
            }
            if (inner instanceof RsParenExpr) {
                return false;
            }
            if (parent2 instanceof RsRetExpr) {
                return false;
            }
            if (RsInlineValueProcessorKt.isNotSingleExpr(inner)) {
                Intrinsics.checkNotNull((Object)parent2);
                if (RsInlineValueProcessorKt.requiresSingleExprFor(parent2, expr)) {
                    return true;
                }
                PsiElement $this$ancestorStrict$iv = expr;
                boolean $i$f$ancestorStrict = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsLetExpr.class, (boolean)true) != null) {
                    return true;
                }
                if (this.isInsideExprOfLetDecl(expr)) {
                    return true;
                }
                if (parent2 instanceof RsRangeExpr) {
                    return true;
                }
            }
            if (parent2 instanceof RsBinaryExpr && !this.isSimpleAssignExpr((RsBinaryExpr)parent2)) {
                return true;
            }
            PsiElement $this$descendantOfTypeOrSelf$iv = inner;
            boolean $i$f$descendantOfTypeOrSelf = false;
            if (PsiTreeUtil.findChildOfType((PsiElement)$this$descendantOfTypeOrSelf$iv, RsStructLiteral.class, (boolean)false) != null) {
                return true;
            }
            if (parent2 instanceof RsCallExpr && this.isCallOfField(inner)) {
                return true;
            }
            return parent2 instanceof RsUnaryExpr && CollectionsKt.listOf((Object[])(unaryOperatorArray = new UnaryOperator[]{UnaryOperator.REF, UnaryOperator.REF_MUT, UnaryOperator.DEREF})).contains((Object)RsExprKt.getOperatorType((RsUnaryExpr)parent2));
        }

        private final boolean isInsideExprOfLetDecl(RsExpr expr) {
            boolean bl;
            block1: {
                Sequence<Pair<PsiElement, PsiElement>> $this$any$iv = PsiElementKt.getAncestorPairs(expr);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    PsiElement child = (PsiElement)pair.component1();
                    PsiElement parent2 = (PsiElement)pair.component2();
                    if (!(parent2 instanceof RsLetDecl && ((RsLetDecl)parent2).getLetElseBranch() != null && Intrinsics.areEqual((Object)((RsLetDecl)parent2).getExpr(), (Object)child))) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final boolean isSimpleAssignExpr(RsBinaryExpr expr) {
            return RsExprKt.getOperatorType(expr) instanceof AssignmentOp && expr.getParent() instanceof RsExprStmt;
        }

        private final boolean isCallOfField(RsExpr inner) {
            RsElement rsElement = inner instanceof RsFieldLookupExpr ? (RsFieldLookupExpr)inner : null;
            if (rsElement == null || (rsElement = rsElement.getFieldLookup()) == null) {
                return false;
            }
            RsElement fieldLookup = rsElement;
            RsElement target = fieldLookup.getReference().resolve();
            return target == null || target instanceof RsNamedFieldDecl;
        }
    }
}

