/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.RemoveCastFix;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.lang.core.psi.RsCastExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.RsLiteralWithSuffix;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.infer.FoldKt;
import org.rust.lang.core.types.infer.TypeFoldable;
import org.rust.lang.core.types.infer.TypeVisitor;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyUnknown;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/inspections/lints/RsUnnecessaryCastInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "isAlias", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "isUnsuffixedNumber", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "containsUnknown", "intellij.rustrover.core"})
public final class RsUnnecessaryCastInspection
extends RsLintInspection {
    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.UnnecessaryCast.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsUnnecessaryCastInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitCastExpr(RsCastExpr castExpr) {
                Intrinsics.checkNotNullParameter((Object)castExpr, (String)"castExpr");
                RsTypeReference rsTypeReference = castExpr.getTypeReference();
                Intrinsics.checkNotNullExpressionValue((Object)rsTypeReference, (String)"getTypeReference(...)");
                Ty typeReferenceType = ExtensionsKt.getRawType(rsTypeReference);
                RsExpr rsExpr = castExpr.getExpr();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getExpr(...)");
                Ty exprType = ExtensionsKt.getType(rsExpr);
                if (RsUnnecessaryCastInspection.access$isAlias(this.this$0, typeReferenceType)) {
                    return;
                }
                if (RsUnnecessaryCastInspection.access$isAlias(this.this$0, exprType)) {
                    return;
                }
                if (RsUnnecessaryCastInspection.access$containsUnknown(this.this$0, typeReferenceType)) {
                    return;
                }
                if (RsUnnecessaryCastInspection.access$containsUnknown(this.this$0, exprType)) {
                    return;
                }
                RsExpr rsExpr2 = castExpr.getExpr();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr2, (String)"getExpr(...)");
                if (RsUnnecessaryCastInspection.access$isUnsuffixedNumber(this.this$0, RsExprKt.unwrapMacroExpr(rsExpr2))) {
                    return;
                }
                if (exprType.isEquivalentTo(typeReferenceType)) {
                    PsiElement psiElement2 = castExpr.getAs();
                    if (psiElement2 == null) {
                        return;
                    }
                    PsiElement castAs = psiElement2;
                    this.this$0.registerLintProblem(this.$holder, (PsiElement)castExpr, RsBundle.INSTANCE.message("inspection.message.unnecessary.cast", new Object[0]), new TextRange(castAs.getTextRange().getStartOffset() - castExpr.getTextRange().getStartOffset(), castExpr.getTypeReference().getTextRange().getEndOffset() - castExpr.getTextRange().getStartOffset()), RsLintHighlightingType.Companion.getUNUSED_SYMBOL(), CollectionsKt.listOf((Object)((Object)new RemoveCastFix(castExpr))));
                }
            }
        };
    }

    private final boolean isAlias(Ty ty2) {
        TypeVisitor visitor2 = new TypeVisitor(){

            public boolean visitTy(Ty ty2) {
                Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
                return ty2.getAliasedBy() != null || ty2.superVisitWith(this);
            }
        };
        return ty2.visitWith(visitor2);
    }

    private final boolean isUnsuffixedNumber(RsExpr expr) {
        if (!(expr instanceof RsLitExpr)) {
            return false;
        }
        RsLiteralKind kind2 = RsLiteralKindKt.getKind((RsLitExpr)expr);
        if (!(kind2 instanceof RsLiteralWithSuffix)) {
            return false;
        }
        return ((RsLiteralWithSuffix)((Object)kind2)).getSuffix() == null;
    }

    private final boolean containsUnknown(Ty ty2) {
        Class[] classArray = new Class[]{TyUnknown.class};
        return FoldKt.containsTyOfClass((TypeFoldable)ty2, classArray);
    }

    public static final /* synthetic */ boolean access$isAlias(RsUnnecessaryCastInspection $this, Ty ty2) {
        return $this.isAlias(ty2);
    }

    public static final /* synthetic */ boolean access$containsUnknown(RsUnnecessaryCastInspection $this, Ty ty2) {
        return $this.containsUnknown(ty2);
    }

    public static final /* synthetic */ boolean access$isUnsuffixedNumber(RsUnnecessaryCastInspection $this, RsExpr expr) {
        return $this.isUnsuffixedNumber(expr);
    }
}

