/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.NameSuggestionFix;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.ide.inspections.lints.RsUnknownCrateTypesInspection;
import org.rust.lang.core.RsPsiPattern;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsLitExprKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u000e\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/inspections/lints/RsUnknownCrateTypesInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "isSyntaxOnly", "()Z", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "Helper", "intellij.rustrover.core"})
public final class RsUnknownCrateTypesInspection
extends RsLintInspection {
    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.UnknownCrateTypes.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsUnknownCrateTypesInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitLitExpr(RsLitExpr element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!RsPsiPattern.INSTANCE.getInsideCrateTypeAttrValue().accepts((Object)element)) {
                    return;
                }
                String string = RsLitExprKt.getStringValue(element);
                if (string == null) {
                    return;
                }
                String elementValue = string;
                if (!Helper.INSTANCE.getKNOWN_CRATE_TYPES().contains(elementValue)) {
                    List<NameSuggestionFix<PsiElement>> fixes = NameSuggestionFix.Companion.createApplicable((PsiElement)element, elementValue, Helper.INSTANCE.getKNOWN_CRATE_TYPES(), 1, arg_0 -> buildVisitor.1.visitLitExpr$lambda$0(element, arg_0));
                    RsLintInspection.registerLintProblem$default((RsLintInspection)this.this$0, this.$holder, (PsiElement)element, RsBundle.INSTANCE.message("inspection.message.invalid.crate.type.value", new Object[0]), null, fixes, null, 20, null);
                }
            }

            private static final RsExpr visitLitExpr$lambda$0(RsLitExpr $element, String it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                Project project = $element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return new RsPsiFactory(project, false, false, 6, null).createExpression("\"" + it2 + "\"");
            }
        };
    }

    @Override
    public boolean isSyntaxOnly() {
        return true;
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/rust/ide/inspections/lints/RsUnknownCrateTypesInspection$Helper;", "", "<init>", "()V", "KNOWN_CRATE_TYPES", "", "", "getKNOWN_CRATE_TYPES", "()Ljava/util/List;", "intellij.rustrover.core"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();
        @NotNull
        private static final List<String> KNOWN_CRATE_TYPES;

        private Helper() {
        }

        @NotNull
        public final List<String> getKNOWN_CRATE_TYPES() {
            return KNOWN_CRATE_TYPES;
        }

        static {
            Object[] objectArray = new String[]{"bin", "lib", "dylib", "staticlib", "cdylib", "rlib", "proc-macro"};
            KNOWN_CRATE_TYPES = CollectionsKt.listOf((Object[])objectArray);
        }
    }
}

