/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.ReplaceCastWithLiteralSuffixFix;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.RsCastExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.RsLiteralWithSuffix;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyFloat;
import org.rust.lang.core.types.ty.TyInteger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0016H\u0002R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/rust/ide/inspections/lints/RsReplaceCastWithSuffixInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "isValidSuffix", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "suffix", "", "kind", "Lorg/rust/lang/core/psi/RsLiteralWithSuffix;", "startsWithRadixPrefix", "Lorg/rust/lang/core/psi/RsLiteralKind$Integer;", "radixPrefixes", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsReplaceCastWithSuffixInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsReplaceCastWithSuffixInspection.kt\norg/rust/ide/inspections/lints/RsReplaceCastWithSuffixInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1761#2,3:87\n*S KotlinDebug\n*F\n+ 1 RsReplaceCastWithSuffixInspection.kt\norg/rust/ide/inspections/lints/RsReplaceCastWithSuffixInspection\n*L\n81#1:87,3\n*E\n"})
public final class RsReplaceCastWithSuffixInspection
extends RsLintInspection {
    @NotNull
    private final List<String> radixPrefixes;

    public RsReplaceCastWithSuffixInspection() {
        Object[] objectArray = new String[]{"0x", "0b", "0o"};
        this.radixPrefixes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.UnnecessaryCast.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsReplaceCastWithSuffixInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitCastExpr(RsCastExpr castExpr) {
                Intrinsics.checkNotNullParameter((Object)castExpr, (String)"castExpr");
                RsExpr rsExpr = castExpr.getExpr();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getExpr(...)");
                RsExpr expr = rsExpr;
                RsTypeReference rsTypeReference = castExpr.getTypeReference();
                Intrinsics.checkNotNullExpressionValue((Object)rsTypeReference, (String)"getTypeReference(...)");
                RsTypeReference typeReference = rsTypeReference;
                Ty typeReferenceType = ExtensionsKt.getRawType(typeReference);
                if (!(typeReferenceType instanceof TyInteger) && !(typeReferenceType instanceof TyFloat)) {
                    return;
                }
                if (typeReferenceType.getAliasedBy() != null) {
                    return;
                }
                String string = typeReference.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!RsReplaceCastWithSuffixInspection.access$isValidSuffix(this.this$0, expr, string)) {
                    return;
                }
                if (RsExpandedElementKt.isExpandedFromDifferentMacroCalls(castExpr)) {
                    return;
                }
                RsLintInspection.registerLintProblem$default((RsLintInspection)this.this$0, this.$holder, (PsiElement)castExpr, RsBundle.INSTANCE.message("inspection.message.can.be.replaced.with.literal.suffix", new Object[0]), RsLintHighlightingType.Companion.getWEAK_WARNING(), CollectionsKt.listOf((Object)((Object)new ReplaceCastWithLiteralSuffixFix(castExpr))), null, 16, null);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidSuffix(RsExpr expr, String suffix) {
        RsLitExpr rsLitExpr;
        RsExpr rsExpr = expr;
        if (rsExpr instanceof RsLitExpr) {
            rsLitExpr = (RsLitExpr)expr;
        } else {
            if (!(rsExpr instanceof RsUnaryExpr)) return false;
            if (((RsUnaryExpr)expr).getMinus() == null) {
                return false;
            }
            RsExpr lit = ((RsUnaryExpr)expr).getExpr();
            if (!(lit instanceof RsLitExpr)) return false;
            rsLitExpr = (RsLitExpr)lit;
        }
        RsLiteralKind kind2 = RsLiteralKindKt.getKind(rsLitExpr);
        if (!(kind2 instanceof RsLiteralWithSuffix)) {
            return false;
        }
        if (((RsLiteralWithSuffix)((Object)kind2)).getSuffix() != null) return false;
        if (!this.isValidSuffix((RsLiteralWithSuffix)((Object)kind2), suffix)) return false;
        return true;
    }

    private final boolean isValidSuffix(RsLiteralWithSuffix kind2, String suffix) {
        if (kind2 instanceof RsLiteralKind.Integer && TyFloat.Companion.getNAMES().contains(suffix) && !this.startsWithRadixPrefix((RsLiteralKind.Integer)kind2)) {
            return true;
        }
        return kind2.getValidSuffixes().contains(suffix);
    }

    private final boolean startsWithRadixPrefix(RsLiteralKind.Integer kind2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.radixPrefixes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it2 = (String)element$iv;
                    boolean bl2 = false;
                    String string = kind2.getNode().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (!StringsKt.startsWith$default((String)string, (String)it2, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$isValidSuffix(RsReplaceCastWithSuffixInspection $this, RsExpr expr, String suffix) {
        return $this.isValidSuffix(expr, suffix);
    }
}

