/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.FixRedundantSemicolons;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.ide.inspections.lints.RsRedundantSemicolonsInspection;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsEmptyStmt;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsStmt;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsItemElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u0014\u0010\u000e\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/inspections/lints/RsRedundantSemicolonsInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "isSyntaxOnly", "()Z", "isDumbAware", "intellij.rustrover.core"})
public final class RsRedundantSemicolonsInspection
extends RsLintInspection {
    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.RedundantSemicolons.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsRedundantSemicolonsInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitBlock(RsBlock block) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                super.visitBlock(block);
                List seq = new ArrayList<E>();
                PsiElement[] psiElementArray = block.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                for (PsiElement element : psiElementArray) {
                    PsiElement psiElement2 = element;
                    if (psiElement2 instanceof RsEmptyStmt) {
                        ((Collection)seq).add(element);
                        continue;
                    }
                    if (!(psiElement2 instanceof RsItemElement) && !(psiElement2 instanceof RsStmt) && !(psiElement2 instanceof RsMacroCall)) continue;
                    buildVisitor.1.visitBlock$tryRegisterProblemAndClearSeq(this.this$0, this.$holder, block, seq);
                }
                buildVisitor.1.visitBlock$tryRegisterProblemAndClearSeq(this.this$0, this.$holder, block, seq);
            }

            private static final void visitBlock$tryRegisterProblemAndClearSeq(RsRedundantSemicolonsInspection this$0, RsProblemsHolder $holder, RsBlock $block, List<RsStmt> stmts) {
                if (stmts.isEmpty()) {
                    return;
                }
                RsLintHighlightingType highlighting = RsLintHighlightingType.Companion.getUNUSED_SYMBOL();
                if (stmts.size() == 1) {
                    String description = RsBundle.INSTANCE.message("inspection.RedundantSemicolons.description.single", new Object[0]);
                    List fixes = CollectionsKt.listOf((Object)((Object)new FixRedundantSemicolons((PsiElement)CollectionsKt.first(stmts))));
                    RsLintInspection.registerLintProblem$default((RsLintInspection)this$0, $holder, (PsiElement)CollectionsKt.first(stmts), description, highlighting, fixes, null, 16, null);
                } else {
                    String description = RsBundle.INSTANCE.message("inspection.RedundantSemicolons.description.multiple", new Object[0]);
                    TextRange textRange = TextRange.create((int)((RsStmt)CollectionsKt.first(stmts)).getStartOffsetInParent(), (int)PsiElementKt.getEndOffsetInParent((PsiElement)CollectionsKt.last(stmts)));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
                    TextRange range = textRange;
                    List fixes = CollectionsKt.listOf((Object)((Object)new FixRedundantSemicolons((PsiElement)CollectionsKt.first(stmts))));
                    this$0.registerLintProblem($holder, (PsiElement)$block, description, range, highlighting, fixes);
                }
                stmts.clear();
            }
        };
    }

    @Override
    public boolean isSyntaxOnly() {
        return true;
    }

    @Override
    public boolean isDumbAware() {
        return false;
    }
}

