/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.ide.inspections.lints.RsPathStatementsInspection;
import org.rust.ide.inspections.lints.RsRemoveStatementWithNoEffectFix;
import org.rust.ide.inspections.lints.RsReplaceWithDropFix;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsStmtKt;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.infer.NeedsDropCheck;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/inspections/lints/RsPathStatementsInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "intellij.rustrover.core"})
public final class RsPathStatementsInspection
extends RsLintInspection {
    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.PathStatements.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsPathStatementsInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitExprStmt(RsExprStmt exprStmt) {
                Intrinsics.checkNotNullParameter((Object)exprStmt, (String)"exprStmt");
                super.visitExprStmt(exprStmt);
                RsExpr rsExpr = exprStmt.getExpr();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getExpr(...)");
                RsExpr expr = rsExpr;
                if (expr instanceof RsPathExpr && !RsStmtKt.isTailStmt(exprStmt)) {
                    Pair pair;
                    NeedsDropCheck needsDropCheck = new NeedsDropCheck(ExtensionsKt.getImplLookup(expr), expr);
                    RsLintHighlightingType highlighting = RsLintHighlightingType.Companion.getWEAK_WARNING();
                    switch (buildVisitor.WhenMappings.$EnumSwitchMapping$0[needsDropCheck.needsDrop(ExtensionsKt.getType(expr)).ordinal()]) {
                        case 1: {
                            String string = RsBundle.INSTANCE.message("inspection.PathStatementsInspection.description.drops.value", new Object[0]);
                            PsiElement psiElement2 = expr;
                            PsiFile psiFile = ((RsPathExpr)expr).getContainingFile();
                            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                            TextRange textRange = ((RsPathExpr)expr).getTextRange();
                            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                            pair = TuplesKt.to((Object)string, (Object)CollectionsKt.listOf((Object)((Object)new RsReplaceWithDropFix(psiElement2, psiFile, textRange, "drop(" + ((RsPathExpr)expr).getText() + ")"))));
                            break;
                        }
                        case 2: {
                            pair = TuplesKt.to((Object)RsBundle.INSTANCE.message("inspection.PathStatementsInspection.description.no.effect", new Object[0]), (Object)CollectionsKt.listOf((Object)((Object)new RsRemoveStatementWithNoEffectFix(exprStmt))));
                            break;
                        }
                        case 3: {
                            return;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    Pair pair2 = pair;
                    String description = (String)pair2.component1();
                    List fixes = (List)pair2.component2();
                    RsLintInspection.registerLintProblem$default((RsLintInspection)this.this$0, this.$holder, (PsiElement)exprStmt, description, highlighting, fixes, null, 16, null);
                }
            }
        };
    }
}

