/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPatFieldFull;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u0014\u0010\u000e\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/inspections/lints/RsNonShorthandFieldPatternsInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "isSyntaxOnly", "()Z", "isDumbAware", "UseShorthandFieldPatternFix", "intellij.rustrover.core"})
public final class RsNonShorthandFieldPatternsInspection
extends RsLintInspection {
    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.NonShorthandFieldPatterns.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsNonShorthandFieldPatternsInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitPatFieldFull(RsPatFieldFull o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                Object object = o.getIdentifier();
                if (object == null || (object = object.getText()) == null) {
                    return;
                }
                Object identifier = object;
                String binding = o.getPat().getText();
                if (!Intrinsics.areEqual((Object)identifier, (Object)binding)) {
                    return;
                }
                Object[] objectArray = new Object[]{identifier};
                RsLintInspection.registerLintProblem$default((RsLintInspection)this.this$0, this.$holder, (PsiElement)o, RsBundle.INSTANCE.message("inspection.message.in.this.pattern.redundant", objectArray), RsLintHighlightingType.Companion.getWEAK_WARNING(), CollectionsKt.listOf((Object)((Object)new UseShorthandFieldPatternFix(o, (String)identifier))), null, 16, null);
            }
        };
    }

    @Override
    public boolean isSyntaxOnly() {
        return true;
    }

    @Override
    public boolean isDumbAware() {
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/inspections/lints/RsNonShorthandFieldPatternsInspection$UseShorthandFieldPatternFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsPatFieldFull;", "element", "identifier", "", "<init>", "(Lorg/rust/lang/core/psi/RsPatFieldFull;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
    private static final class UseShorthandFieldPatternFix
    extends RsQuickFixBase<RsPatFieldFull> {
        @NotNull
        private final String identifier;

        public UseShorthandFieldPatternFix(@NotNull RsPatFieldFull element, @NotNull String identifier) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            super((PsiElement)element);
            this.identifier = identifier;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return RsBundle.INSTANCE.message("intention.family.name.use.shorthand.field.pattern", new Object[0]);
        }

        @Override
        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.identifier};
            return RsBundle.INSTANCE.message("intention.name.use.shorthand.field.pattern", objectArray);
        }

        @Override
        public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsPatFieldFull element) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            RsPsiFactory rsPsiFactory = new RsPsiFactory(project, false, false, 6, null);
            String string = element.getPat().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            RsPatBinding patBinding = RsPsiFactory.createPatBinding$default(rsPsiFactory, string, false, false, 6, null);
            element.getParent().addBefore((PsiElement)patBinding, (PsiElement)element);
            element.delete();
        }
    }
}

