/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.ElideLifetimesFix;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.ide.inspections.lints.RsNeedlessLifetimesInspectionKt;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsFunctionKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/inspections/lints/RsNeedlessLifetimesInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "registerProblem", "", "fn", "Lorg/rust/lang/core/psi/RsFunction;", "intellij.rustrover.core"})
public final class RsNeedlessLifetimesInspection
extends RsLintInspection {
    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.NeedlessLifetimes.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsNeedlessLifetimesInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitFunction2(RsFunction fn) {
                Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
                if (RsNeedlessLifetimesInspectionKt.access$couldUseElision(fn)) {
                    RsNeedlessLifetimesInspection.access$registerProblem(this.this$0, this.$holder, fn);
                }
            }
        };
    }

    private final void registerProblem(RsProblemsHolder holder, RsFunction fn) {
        int n;
        PsiElement psiElement2 = fn;
        String string = RsBundle.INSTANCE.message("inspection.message.explicit.lifetimes.given.in.parameter.types.where.they.could.be.elided", new Object[0]);
        int n2 = fn.getFn().getStartOffsetInParent();
        RsBlock rsBlock = RsFunctionKt.getBlock(fn);
        if (rsBlock != null && (rsBlock = PsiElementExtensionsKt.getPrevNonCommentSibling(rsBlock)) != null) {
            n = PsiElementKt.getEndOffsetInParent(rsBlock);
        } else {
            PsiElement psiElement3 = fn.getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getIdentifier(...)");
            n = PsiElementKt.getEndOffsetInParent(psiElement3);
        }
        this.registerLintProblem(holder, psiElement2, string, new TextRange(n2, n), RsLintHighlightingType.Companion.getWEAK_WARNING(), CollectionsKt.listOf((Object)((Object)new ElideLifetimesFix(fn))));
    }

    public static final /* synthetic */ void access$registerProblem(RsNeedlessLifetimesInspection $this, RsProblemsHolder holder, RsFunction fn) {
        $this.registerProblem(holder, fn);
    }
}

