/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RenameFix;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.lang.core.psi.RsRawIdentifiersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\"\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\nJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0003H'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/inspections/lints/RsNamingInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "elementType", "", "styleName", "elementTitle", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDisplayName", "isSyntaxOnly", "", "()Z", "isDumbAware", "inspect", "", "id", "Lcom/intellij/psi/PsiElement;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "fix", "checkName", "name", "intellij.rustrover.core"})
public abstract class RsNamingInspection
extends RsLintInspection {
    @NotNull
    private final String elementType;
    @NotNull
    private final String styleName;
    @NotNull
    private final String elementTitle;
    private final boolean isSyntaxOnly;

    public RsNamingInspection(@NotNull String elementType, @NotNull String styleName, @NotNull String elementTitle) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)styleName, (String)"styleName");
        Intrinsics.checkNotNullParameter((Object)elementTitle, (String)"elementTitle");
        this.elementType = elementType;
        this.styleName = styleName;
        this.elementTitle = elementTitle;
        this.isSyntaxOnly = true;
    }

    public /* synthetic */ RsNamingInspection(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = string;
        }
        this(string, string2, string3);
    }

    @NotNull
    public String getDisplayName() {
        Object[] objectArray = new Object[]{this.elementTitle};
        return RsBundle.INSTANCE.message("0.naming.convention", objectArray);
    }

    @Override
    public boolean isSyntaxOnly() {
        return this.isSyntaxOnly;
    }

    @Override
    public boolean isDumbAware() {
        return false;
    }

    public final void inspect(@Nullable PsiElement id, @NotNull RsProblemsHolder holder, boolean fix) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (id == null) {
            return;
        }
        String name2 = RsRawIdentifiersKt.getUnescapedText(id);
        String string = this.checkName(name2);
        if (string == null) {
            return;
        }
        String suggestedName = string;
        PsiElement fixEl = id.getParent();
        List fixes = fix && fixEl instanceof PsiNamedElement ? CollectionsKt.listOf((Object)((Object)new RenameFix((PsiNamedElement)fixEl, suggestedName, null, 4, null))) : CollectionsKt.emptyList();
        Object[] objectArray = new Object[]{this.elementType, name2, this.styleName, suggestedName};
        RsLintInspection.registerLintProblem$default((RsLintInspection)this, holder, id, RsBundle.INSTANCE.message("inspection.message.should.have.case.name.such.as", objectArray), null, fixes, null, 20, null);
    }

    public static /* synthetic */ void inspect$default(RsNamingInspection rsNamingInspection, PsiElement psiElement2, RsProblemsHolder rsProblemsHolder, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: inspect");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        rsNamingInspection.inspect(psiElement2, rsProblemsHolder, bl);
    }

    @VisibleForTesting
    @Nullable
    public abstract String checkName(@NotNull String var1);
}

