/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintLevel;
import org.rust.ide.inspections.lints.RsSuppressQuickFix;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$JG\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\r\b\u0002\u0010\u0012\u001a\u00070\f\u00a2\u0006\u0002\b\u0013H\u0004J@\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/rust/ide/inspections/lints/RsLintInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "registerLintProblem", "", "Lorg/rust/ide/inspections/RsProblemsHolder;", "descriptionTemplate", "", "lintHighlightingType", "Lorg/rust/ide/inspections/lints/RsLintHighlightingType;", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "inlineDescription", "Lorg/rust/lang/utils/InlineInspectionMessage;", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getProblemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "isSuppressedFor", "", "isDumbAware", "getBatchSuppressActions", "", "Lcom/intellij/codeInspection/SuppressQuickFix;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/codeInspection/SuppressQuickFix;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsLintInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsLintInspection.kt\norg/rust/ide/inspections/lints/RsLintInspection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,171:1\n37#2,2:172\n37#2,2:174\n*S KotlinDebug\n*F\n+ 1 RsLintInspection.kt\norg/rust/ide/inspections/lints/RsLintInspection\n*L\n41#1:172,2\n54#1:174,2\n*E\n"})
public abstract class RsLintInspection
extends RsLocalInspectionTool {
    @Nullable
    protected abstract RsLint getLint(@NotNull PsiElement var1);

    protected final void registerLintProblem(@NotNull RsProblemsHolder $this$registerLintProblem, @NotNull PsiElement element, @InspectionMessage @NotNull String descriptionTemplate, @NotNull RsLintHighlightingType lintHighlightingType, @NotNull List<? extends LocalQuickFix> fixes, @NotNull String inlineDescription) {
        Intrinsics.checkNotNullParameter((Object)$this$registerLintProblem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)descriptionTemplate, (String)"descriptionTemplate");
        Intrinsics.checkNotNullParameter((Object)lintHighlightingType, (String)"lintHighlightingType");
        Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
        Intrinsics.checkNotNullParameter((Object)inlineDescription, (String)"inlineDescription");
        Collection $this$toTypedArray$iv = fixes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
        $this$registerLintProblem.registerProblem(element, descriptionTemplate, this.getProblemHighlightType(element, lintHighlightingType), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length), inlineDescription);
    }

    public static /* synthetic */ void registerLintProblem$default(RsLintInspection rsLintInspection, RsProblemsHolder rsProblemsHolder, PsiElement psiElement2, String string, RsLintHighlightingType rsLintHighlightingType, List list, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerLintProblem");
        }
        if ((n & 4) != 0) {
            rsLintHighlightingType = RsLintHighlightingType.Companion.getDEFAULT();
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            string2 = string;
        }
        rsLintInspection.registerLintProblem(rsProblemsHolder, psiElement2, string, rsLintHighlightingType, list, string2);
    }

    protected final void registerLintProblem(@NotNull RsProblemsHolder $this$registerLintProblem, @NotNull PsiElement element, @InspectionMessage @NotNull String descriptionTemplate, @NotNull TextRange rangeInElement, @NotNull RsLintHighlightingType lintHighlightingType, @NotNull List<? extends LocalQuickFix> fixes) {
        Intrinsics.checkNotNullParameter((Object)$this$registerLintProblem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)descriptionTemplate, (String)"descriptionTemplate");
        Intrinsics.checkNotNullParameter((Object)rangeInElement, (String)"rangeInElement");
        Intrinsics.checkNotNullParameter((Object)lintHighlightingType, (String)"lintHighlightingType");
        Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
        ProblemHighlightType highlightType = this.getProblemHighlightType(element, lintHighlightingType);
        Collection $this$toTypedArray$iv = fixes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
        RsProblemsHolder.registerProblem$default($this$registerLintProblem, element, descriptionTemplate, highlightType, rangeInElement, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length), false, null, 96, null);
    }

    public static /* synthetic */ void registerLintProblem$default(RsLintInspection rsLintInspection, RsProblemsHolder rsProblemsHolder, PsiElement psiElement2, String string, TextRange textRange, RsLintHighlightingType rsLintHighlightingType, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerLintProblem");
        }
        if ((n & 8) != 0) {
            rsLintHighlightingType = RsLintHighlightingType.Companion.getDEFAULT();
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        rsLintInspection.registerLintProblem(rsProblemsHolder, psiElement2, string, textRange, rsLintHighlightingType, list);
    }

    private final ProblemHighlightType getProblemHighlightType(PsiElement element, RsLintHighlightingType lintHighlightingType) {
        RsLint rsLint = this.getLint(element);
        if (rsLint == null) {
            return ProblemHighlightType.WARNING;
        }
        RsLint lint = rsLint;
        return switch (WhenMappings.$EnumSwitchMapping$0[lint.levelFor(element).ordinal()]) {
            case 1 -> lintHighlightingType.getAllow();
            case 2 -> lintHighlightingType.getWarn();
            case 3 -> lintHighlightingType.getDeny();
            case 4 -> lintHighlightingType.getForbid();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (super.isSuppressedFor(element)) {
            return true;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return true;
        }
        RsLint rsLint = this.getLint(element);
        return (rsLint != null ? rsLint.levelFor(element) : null) == RsLintLevel.ALLOW;
    }

    @Override
    public boolean isDumbAware() {
        return false;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        Object[] objectArray = super.getBatchSuppressActions(element);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getBatchSuppressActions(...)");
        Object[] fixes = objectArray;
        if (element == null) {
            return fixes;
        }
        RsLint rsLint = this.getLint(element);
        if (rsLint == null) {
            return fixes;
        }
        RsLint lint = rsLint;
        return (SuppressQuickFix[])ArraysKt.plus((Object[])fixes, (Object[])RsSuppressQuickFix.Companion.createSuppressFixes(element, lint));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RsLintLevel.values().length];
            try {
                nArray[RsLintLevel.ALLOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RsLintLevel.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RsLintLevel.DENY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RsLintLevel.FORBID.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

