/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.RsDropRefInspectionKt;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.ide.inspections.lints.RsRemoveDropCopyTypeFix;
import org.rust.ide.inspections.lints.RsUnwrapDropCopyTypeFix;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.infer.FoldKt;
import org.rust.lang.core.types.infer.TypeFoldable;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyUnknown;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/inspections/lints/RsDropCopyTypeInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "intellij.rustrover.core"})
public final class RsDropCopyTypeInspection
extends RsLintInspection {
    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.DroppingCopyTypes.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitCallExpr(RsCallExpr expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                RsExpr rsExpr = RsDropRefInspectionKt.getSingleArgOfDropExpr(expr);
                if (rsExpr == null) {
                    return;
                }
                RsExpr arg = rsExpr;
                Ty type = ExtensionsKt.getType(arg);
                Class[] classArray = new Class[]{TyUnknown.class};
                if (FoldKt.containsTyOfClass((TypeFoldable)type, classArray)) {
                    return;
                }
                if (!ExtensionsKt.getImplLookup(expr).isCopy(type).isTrue()) {
                    return;
                }
                Collection $this$toTypedArray$iv = this.getFixes(expr, arg);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] fixes = thisCollection$iv.toArray(new LocalQuickFix[0]);
                this.$holder.registerProblem((PsiElement)expr, RsBundle.INSTANCE.message("inspection.message.invoking.drop.with.copy.type", new Object[0]), Arrays.copyOf(fixes, fixes.length));
            }

            private final List<LocalQuickFix> getFixes(RsCallExpr expr, RsExpr arg) {
                List list;
                List $this$getFixes_u24lambda_u240 = list = CollectionsKt.createListBuilder();
                boolean bl = false;
                PsiElement psiElement2 = expr.getParent();
                RsExprStmt rsExprStmt = psiElement2 instanceof RsExprStmt ? (RsExprStmt)psiElement2 : null;
                if (rsExprStmt != null) {
                    RsExprStmt stmt = rsExprStmt;
                    ((Collection)$this$getFixes_u24lambda_u240).add(new RsRemoveDropCopyTypeFix(stmt));
                    if (!(arg instanceof RsPathExpr)) {
                        ((Collection)$this$getFixes_u24lambda_u240).add(new RsUnwrapDropCopyTypeFix(arg));
                    }
                }
                return CollectionsKt.build((List)list);
            }
        };
    }
}

