/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import io.github.z4kn4fein.semver.StringExtensionsKt;
import io.github.z4kn4fein.semver.Version;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.ide.fixes.ReplaceDeprecatedWithSuggestionFix;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsDeprecationInspectionKt;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintHighlightingType;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsMetaItemArgs;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsModDeclItem;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsUseSpeck;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwner;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsMetaItemKt;
import org.rust.lang.core.psi.ext.RsOuterAttributeOwner;
import org.rust.lang.core.psi.ext.RsQualifiedNamedElement;
import org.rust.lang.core.psi.ext.RsQualifiedNamedElementKt;
import org.rust.lang.core.psi.ext.RsReferenceElement;
import org.rust.lang.core.types.ty.TyFloat;
import org.rust.lang.core.types.ty.TyInteger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u000f*\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\f\u0010\u001c\u001a\u00020\u0017*\u00020\u001dH\u0002J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0005*\b\u0012\u0004\u0012\u00020\u001d0\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0002J$\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0005H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0005H\u0002\u00a8\u0006+"}, d2={"Lorg/rust/ide/inspections/lints/RsDeprecationInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getDisplayName", "", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkAndRegisterAsDeprecated", "", "identifier", "original", "getDeprecatedMessage", "Lkotlin/Pair;", "Lorg/rust/ide/inspections/lints/RsLintHighlightingType;", "Lorg/rust/ide/inspections/lints/RsDeprecationInspection$DeprecatedAttribute;", "item", "crate", "Lorg/rust/lang/core/crate/Crate;", "isPresentlyDeprecated", "extractDeprecatedInfo", "Lorg/rust/lang/core/psi/RsMetaItem;", "getByName", "", "name", "tryCreateFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "declaration", "Lorg/rust/lang/core/psi/ext/RsOuterAttributeOwner;", "suggestionRustc", "tryReplaceNumericConstant", "path", "Lorg/rust/lang/core/psi/RsPath;", "qualifiedName", "DeprecatedAttribute", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsDeprecationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDeprecationInspection.kt\norg/rust/ide/inspections/lints/RsDeprecationInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n295#2,2:174\n9#3:176\n1#4:177\n*S KotlinDebug\n*F\n+ 1 RsDeprecationInspection.kt\norg/rust/ide/inspections/lints/RsDeprecationInspection\n*L\n102#1:174,2\n121#1:176\n*E\n"})
public final class RsDeprecationInspection
extends RsLintInspection {
    @NotNull
    public String getDisplayName() {
        return RsBundle.INSTANCE.message("deprecated.item", new Object[0]);
    }

    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.Deprecated.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsDeprecationInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitElement(RsElement ref) {
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                if (ref instanceof RsModDeclItem || !(ref instanceof RsReferenceElement)) {
                    return;
                }
                Object object = ((RsReferenceElement)ref).getReference();
                if (object == null || (object = object.resolve()) == null) {
                    return;
                }
                Object original = object;
                PsiElement psiElement2 = ((RsReferenceElement)ref).getReferenceNameElement();
                if (psiElement2 == null) {
                    return;
                }
                PsiElement identifier = psiElement2;
                if (Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(identifier), (Object)RsElementTypes.CSELF)) {
                    return;
                }
                Object object2 = original;
                Object object3 = object2 instanceof RsFile ? (RsElement)((RsFile)original).getDeclaration() : (object2 instanceof RsAbstractable ? (RsElement)(RsAbstractableKt.getOwner((RsAbstractable)original).isTraitImpl() ? RsAbstractableKt.getSuperItem((RsAbstractable)original) : (RsAbstractable)original) : original);
                if (object3 == null) {
                    return;
                }
                Object targetElement = object3;
                RsDeprecationInspection.access$checkAndRegisterAsDeprecated(this.this$0, identifier, (PsiElement)targetElement, this.$holder);
            }
        };
    }

    private final void checkAndRegisterAsDeprecated(PsiElement identifier, PsiElement original, RsProblemsHolder holder) {
        if (original instanceof RsOuterAttributeOwner) {
            RsMetaItem rsMetaItem = RsDocAndAttributeOwnerKt.getQueryPsiAttributes((RsDocAndAttributeOwner)original).getDeprecatedAttribute();
            if (rsMetaItem == null) {
                return;
            }
            RsMetaItem attr = rsMetaItem;
            DeprecatedAttribute attrInfo = this.extractDeprecatedInfo(attr);
            String string = identifier.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Pair<String, RsLintHighlightingType> pair = this.getDeprecatedMessage(attrInfo, string, ((RsOuterAttributeOwner)original).getContainingCrate());
            String message = (String)pair.component1();
            RsLintHighlightingType highlightType = (RsLintHighlightingType)pair.component2();
            LocalQuickFix fix = this.tryCreateFix(identifier, (RsOuterAttributeOwner)original, attrInfo.getSuggestion());
            RsLintInspection.registerLintProblem$default((RsLintInspection)this, holder, identifier, message, highlightType, CollectionsKt.listOfNotNull((Object)fix), null, 16, null);
        }
    }

    private final Pair<String, RsLintHighlightingType> getDeprecatedMessage(DeprecatedAttribute $this$getDeprecatedMessage, String item, Crate crate) {
        Pair pair;
        if (this.isPresentlyDeprecated($this$getDeprecatedMessage, crate)) {
            StringBuilder stringBuilder;
            StringBuilder $this$getDeprecatedMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$getDeprecatedMessage_u24lambda_u240.append("`" + item + "` is deprecated");
            if ($this$getDeprecatedMessage.getSince() != null) {
                $this$getDeprecatedMessage_u24lambda_u240.append(" since " + $this$getDeprecatedMessage.getSince());
            }
            if ($this$getDeprecatedMessage.getNote() != null) {
                $this$getDeprecatedMessage_u24lambda_u240.append(": " + $this$getDeprecatedMessage.getNote());
            }
            pair = TuplesKt.to((Object)stringBuilder.toString(), (Object)RsLintHighlightingType.Companion.getDEPRECATED());
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$getDeprecatedMessage_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$getDeprecatedMessage_u24lambda_u241.append("`" + item + "` will be deprecated");
            if (!Intrinsics.areEqual((Object)$this$getDeprecatedMessage.getSince(), (Object)"TBD")) {
                $this$getDeprecatedMessage_u24lambda_u241.append(" from " + $this$getDeprecatedMessage.getSince());
            }
            if ($this$getDeprecatedMessage.getNote() != null) {
                $this$getDeprecatedMessage_u24lambda_u241.append(": " + $this$getDeprecatedMessage.getNote());
            }
            pair = TuplesKt.to((Object)stringBuilder.toString(), (Object)RsLintHighlightingType.Companion.getWEAK_WARNING());
        }
        return pair;
    }

    private final boolean isPresentlyDeprecated(DeprecatedAttribute $this$isPresentlyDeprecated, Crate crate) {
        Version version;
        String string;
        Object object;
        Object object2;
        if (Intrinsics.areEqual((Object)$this$isPresentlyDeprecated.getSince(), (Object)"TBD")) {
            return false;
        }
        String string2 = $this$isPresentlyDeprecated.getSince();
        if (string2 == null || (string2 = StringExtensionsKt.toVersionOrNull((String)string2, (boolean)false)) == null) {
            return true;
        }
        String sinceVersion = string2;
        String string3 = crate.getOrigin() == PackageOrigin.STDLIB ? ((object2 = crate.getCargoProject()) != null && (object2 = object2.getRustcInfo()) != null && (object2 = ((RustcInfo)object2).getVersion()) != null && (object2 = ((RustcVersion)object2).getSemver()) != null ? object2.getRawVersion() : null) : ((object = crate.getCargoTarget()) != null && (object = object.getPkg()) != null ? object.getVersion() : (string = null));
        if (string == null || (version = StringExtensionsKt.toVersionOrNull$default((String)string, (boolean)false, (int)1, null)) == null) {
            return true;
        }
        Version currentVersion = version;
        return currentVersion.compareTo((Version)sinceVersion) >= 0;
    }

    private final DeprecatedAttribute extractDeprecatedInfo(RsMetaItem $this$extractDeprecatedInfo) {
        List<RsMetaItem> params;
        RsMetaItemArgs rsMetaItemArgs = $this$extractDeprecatedInfo.getMetaItemArgs();
        List<RsMetaItem> list = params = rsMetaItemArgs != null ? rsMetaItemArgs.getMetaItemList() : null;
        String note = list != null ? this.getByName(list, "note") : null;
        List<RsMetaItem> list2 = params;
        String since = list2 != null ? this.getByName(list2, "since") : null;
        List<RsMetaItem> list3 = params;
        String suggestion = list3 != null ? this.getByName(list3, "suggestion") : null;
        return new DeprecatedAttribute(note, since, suggestion);
    }

    private final String getByName(List<? extends RsMetaItem> $this$getByName, String name2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$getByName;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RsMetaItem it2 = (RsMetaItem)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)name2, (Object)RsMetaItemKt.getName(it2))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        RsMetaItem rsMetaItem = v0;
        return rsMetaItem != null ? rsMetaItem.getValue() : null;
    }

    private final LocalQuickFix tryCreateFix(PsiElement identifier, RsOuterAttributeOwner declaration, String suggestionRustc) {
        block10: {
            PsiElement parent2;
            String suggestionOur;
            Object qualifiedName;
            block12: {
                block11: {
                    Object object = declaration instanceof RsQualifiedNamedElement ? (RsQualifiedNamedElement)((Object)declaration) : null;
                    if (object == null || (object = RsQualifiedNamedElementKt.getQualifiedName((RsQualifiedNamedElement)object)) == null) {
                        return null;
                    }
                    qualifiedName = object;
                    suggestionOur = (String)RsDeprecationInspectionKt.access$getDEPRECATED_ELEMENTS_MAP$p().get(qualifiedName);
                    parent2 = identifier.getParent();
                    if (parent2 instanceof RsMethodCall) {
                        if (!Intrinsics.areEqual((Object)((RsMethodCall)parent2).getIdentifier(), (Object)identifier)) {
                            return null;
                        }
                        String string = suggestionOur;
                        if (string == null && (string = suggestionRustc) == null) {
                            return null;
                        }
                        String suggestion = string;
                        return new ReplaceDeprecatedWithSuggestionFix(identifier, suggestion, false, 4, null);
                    }
                    if (!(parent2 instanceof RsPath)) break block10;
                    if (!Intrinsics.areEqual((Object)((RsPath)parent2).getReferenceNameElement(), (Object)identifier)) {
                        return null;
                    }
                    if (((RsPath)parent2).getParent() instanceof RsPath) break block11;
                    PsiElement $this$ancestorStrict$iv = parent2;
                    boolean $i$f$ancestorStrict = false;
                    if (PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsUseSpeck.class, (boolean)true) == null) break block12;
                }
                return null;
            }
            LocalQuickFix localQuickFix = this.tryReplaceNumericConstant((RsPath)parent2, (String)qualifiedName);
            if (localQuickFix != null) {
                LocalQuickFix it2 = localQuickFix;
                boolean bl = false;
                return it2;
            }
            if (suggestionOur == null) {
                return null;
            }
            return new ReplaceDeprecatedWithSuggestionFix(parent2, suggestionOur, !((RsPath)parent2).getHasColonColon());
        }
        return null;
    }

    private final LocalQuickFix tryReplaceNumericConstant(RsPath path, String qualifiedName) {
        List numericTypes = CollectionsKt.plus((Collection)TyInteger.Companion.getNAMES(), (Iterable)TyFloat.Companion.getNAMES());
        String[] stringArray = new String[]{"::"};
        List segments = StringsKt.split$default((CharSequence)qualifiedName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (segments.size() == 3 && Intrinsics.areEqual(segments.get(0), (Object)"core") && numericTypes.contains(segments.get(1))) {
            return new ReplaceDeprecatedWithSuggestionFix(path, segments.get(1) + "::" + segments.get(2), false, 4, null);
        }
        if (segments.size() == 4 && Intrinsics.areEqual(segments.get(0), (Object)"core") && numericTypes.contains(segments.get(2))) {
            boolean bl;
            Object object = RsElementKt.getCargoProject(path);
            if (object != null && (object = object.getRustcInfo()) != null && (object = ((RustcInfo)object).getVersion()) != null && (object = ((RustcVersion)object).getSemver()) != null) {
                Object it2 = object;
                boolean bl2 = false;
                bl = it2.compareTo(RsDeprecationInspectionKt.access$getRUST_1_91_0_BETA$p()) >= 0;
            } else {
                bl = false;
            }
            if (bl) {
                return new ReplaceDeprecatedWithSuggestionFix(path, segments.get(2) + "::" + segments.get(3), false, 4, null);
            }
        }
        return null;
    }

    public static final /* synthetic */ void access$checkAndRegisterAsDeprecated(RsDeprecationInspection $this, PsiElement identifier, PsiElement original, RsProblemsHolder holder) {
        $this.checkAndRegisterAsDeprecated(identifier, original, holder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J-\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/inspections/lints/RsDeprecationInspection$DeprecatedAttribute;", "", "note", "", "since", "suggestion", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getNote", "()Ljava/lang/String;", "getSince", "getSuggestion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
    private static final class DeprecatedAttribute {
        @Nullable
        private final String note;
        @Nullable
        private final String since;
        @Nullable
        private final String suggestion;

        public DeprecatedAttribute(@Nullable String note, @Nullable String since, @Nullable String suggestion) {
            this.note = note;
            this.since = since;
            this.suggestion = suggestion;
        }

        @Nullable
        public final String getNote() {
            return this.note;
        }

        @Nullable
        public final String getSince() {
            return this.since;
        }

        @Nullable
        public final String getSuggestion() {
            return this.suggestion;
        }

        @Nullable
        public final String component1() {
            return this.note;
        }

        @Nullable
        public final String component2() {
            return this.since;
        }

        @Nullable
        public final String component3() {
            return this.suggestion;
        }

        @NotNull
        public final DeprecatedAttribute copy(@Nullable String note, @Nullable String since, @Nullable String suggestion) {
            return new DeprecatedAttribute(note, since, suggestion);
        }

        public static /* synthetic */ DeprecatedAttribute copy$default(DeprecatedAttribute deprecatedAttribute, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = deprecatedAttribute.note;
            }
            if ((n & 2) != 0) {
                string2 = deprecatedAttribute.since;
            }
            if ((n & 4) != 0) {
                string3 = deprecatedAttribute.suggestion;
            }
            return deprecatedAttribute.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "DeprecatedAttribute(note=" + this.note + ", since=" + this.since + ", suggestion=" + this.suggestion + ")";
        }

        public int hashCode() {
            int result2 = this.note == null ? 0 : this.note.hashCode();
            result2 = result2 * 31 + (this.since == null ? 0 : this.since.hashCode());
            result2 = result2 * 31 + (this.suggestion == null ? 0 : this.suggestion.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeprecatedAttribute)) {
                return false;
            }
            DeprecatedAttribute deprecatedAttribute = (DeprecatedAttribute)other;
            if (!Intrinsics.areEqual((Object)this.note, (Object)deprecatedAttribute.note)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.since, (Object)deprecatedAttribute.since)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.suggestion, (Object)deprecatedAttribute.suggestion);
        }
    }
}

