/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.lints;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.lints.RsBareTraitObjectsInspection;
import org.rust.ide.inspections.lints.RsBareTraitObjectsInspectionKt;
import org.rust.ide.inspections.lints.RsLint;
import org.rust.ide.inspections.lints.RsLintInspection;
import org.rust.lang.core.CompilerFeature;
import org.rust.lang.core.FeatureAvailability;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPathType;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsRetType;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTraitType;
import org.rust.lang.core.psi.RsTypeAlias;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.lang.core.psi.ext.RsTraitTypeKt;
import org.rust.lang.core.psi.ext.RsTypeReferenceKt;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.resolve.ref.RsPathReferenceImplKt;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/inspections/lints/RsBareTraitObjectsInspection;", "Lorg/rust/ide/inspections/lints/RsLintInspection;", "<init>", "()V", "getLint", "Lorg/rust/ide/inspections/lints/RsLint;", "element", "Lcom/intellij/psi/PsiElement;", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "AddDynKeywordFix", "AddImplKeywordFix", "intellij.rustrover.core"})
public final class RsBareTraitObjectsInspection
extends RsLintInspection {
    @Override
    @NotNull
    protected RsLint getLint(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RsLint.BareTraitObjects.INSTANCE;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitTypeReference(RsTypeReference typeReference) {
                AddImplKeywordFix addImplKeywordFix;
                boolean hasImpl;
                Object object;
                RsPath typePath;
                Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
                if (!RsElementKt.isAtLeastEdition2018(typeReference)) {
                    return;
                }
                RsTypeReference rsTypeReference = RsTypeReferenceKt.skipParens(typeReference);
                RsTraitType traitType = rsTypeReference instanceof RsTraitType ? (RsTraitType)rsTypeReference : null;
                RsTypeReference rsTypeReference2 = RsTypeReferenceKt.skipParens(typeReference);
                RsPathType rsPathType = rsTypeReference2 instanceof RsPathType ? (RsPathType)rsTypeReference2 : null;
                RsPath rsPath = typePath = rsPathType != null ? rsPathType.getPath() : null;
                boolean isTraitType = traitType != null || ((object = typePath) != null && (object = object.getReference()) != null ? RsPathReferenceImplKt.deepResolve((RsPathReference)object) : null) instanceof RsTraitItem;
                RsPath rsPath2 = typePath;
                boolean isSelf = (rsPath2 != null ? rsPath2.getCself() : null) != null;
                RsTraitType rsTraitType = traitType;
                boolean hasDyn = (rsTraitType != null ? RsTraitTypeKt.getDyn(rsTraitType) : null) != null;
                RsTraitType rsTraitType2 = traitType;
                boolean bl = hasImpl = (rsTraitType2 != null ? rsTraitType2.getImpl() : null) != null;
                if (!isTraitType || isSelf || hasDyn || hasImpl) {
                    return;
                }
                AddDynKeywordFix addDynFix = new AddDynKeywordFix(typeReference);
                buildVisitor.1 $this$visitTypeReference_u24lambda_u240 = this;
                boolean bl2 = false;
                PsiElement $this$ancestorStrict$iv = typeReference;
                boolean $i$f$ancestorStrict = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsValueParameter.class, (boolean)true) != null) {
                    addImplKeywordFix = new AddImplKeywordFix(typeReference);
                } else {
                    $this$ancestorStrict$iv = typeReference;
                    $i$f$ancestorStrict = false;
                    if (PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsRetType.class, (boolean)true) != null) {
                        addImplKeywordFix = new AddImplKeywordFix(typeReference);
                    } else {
                        $this$ancestorStrict$iv = typeReference;
                        $i$f$ancestorStrict = false;
                        if (PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorStrict$iv, RsTypeAlias.class, (boolean)true) == null) {
                            addImplKeywordFix = null;
                        } else {
                            FeatureAvailability availability = CompilerFeature.Companion.getTYPE_ALIAS_IMPORT_TRAIT().availability(typeReference);
                            switch (buildVisitor.WhenMappings.$EnumSwitchMapping$0[availability.ordinal()]) {
                                case 1: 
                                case 2: {
                                    addImplKeywordFix = new AddImplKeywordFix(typeReference);
                                    break;
                                }
                                default: {
                                    addImplKeywordFix = null;
                                }
                            }
                        }
                    }
                }
                AddImplKeywordFix addImplFix = addImplKeywordFix;
                for (RsPossibleMacroCall call2 : RsExpandedElementKt.getMacroCallExpandedFromSequence(typeReference)) {
                    Object def;
                    Object object2 = call2.getPath();
                    if (object2 == null || (object2 = object2.getReference()) == null) continue;
                    if ((object2 = object2.resolve()) == null || RsElementKt.isAtLeastEdition2018((PsiElement)(def = object2))) continue;
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{addDynFix, addImplFix};
                RsDiagnosticKt.addToHolder$default(new RsDiagnostic.TraitObjectWithNoDyn((PsiElement)typeReference, localQuickFixArray), this.$holder, false, null, 6, null);
            }
        };
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/inspections/lints/RsBareTraitObjectsInspection$AddDynKeywordFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsTypeReference;", "element", "<init>", "(Lorg/rust/lang/core/psi/RsTypeReference;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
    private static final class AddDynKeywordFix
    extends RsQuickFixBase<RsTypeReference> {
        public AddDynKeywordFix(@NotNull RsTypeReference element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super((PsiElement)element);
        }

        @Override
        @NotNull
        public String getText() {
            return RsBundle.INSTANCE.message("intention.name.add.dyn.keyword.to.trait.object", new Object[0]);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsTypeReference element) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String traitText = RsBareTraitObjectsInspectionKt.access$getTraitText(element);
            RsTraitType rsTraitType = new RsPsiFactory(project, false, false, 6, null).createDynTraitType(traitText);
            element.replace(rsTraitType);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/inspections/lints/RsBareTraitObjectsInspection$AddImplKeywordFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lorg/rust/lang/core/psi/RsTypeReference;", "element", "<init>", "(Lorg/rust/lang/core/psi/RsTypeReference;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
    private static final class AddImplKeywordFix
    extends RsQuickFixBase<RsTypeReference> {
        public AddImplKeywordFix(@NotNull RsTypeReference element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super((PsiElement)element);
        }

        @Override
        @NotNull
        public String getText() {
            return RsBundle.INSTANCE.message("intention.name.add.impl.before.trait", new Object[0]);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull RsTypeReference element) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String traitText = RsBareTraitObjectsInspectionKt.access$getTraitText(element);
            RsTraitType rsTraitType = new RsPsiFactory(project, false, false, 6, null).createImplTraitType(traitText);
            element.replace(rsTraitType);
        }
    }
}

