/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.import;

import com.intellij.codeInspection.LocalQuickFix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.fixes.QualifyPathFix;
import org.rust.ide.fixes.ReplaceWithDocAliasMethodFix;
import org.rust.ide.fixes.ReplaceWithDocAliasedPathFix;
import org.rust.ide.inspections.import.AutoImportFix;
import org.rust.ide.inspections.import.UnresolvedReferencePathType;
import org.rust.ide.inspections.import.UnresolvedReferenceResolutionContext;
import org.rust.ide.utils.import.DocAliasCandidate;
import org.rust.ide.utils.import.ImportCandidate;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.ext.RsReferenceElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/inspections/import/AutoImportFixContext;", "Lorg/rust/ide/inspections/import/UnresolvedReferenceResolutionContext;", "type", "Lorg/rust/ide/inspections/import/UnresolvedReferencePathType;", "candidates", "", "Lorg/rust/ide/utils/import/ImportCandidate;", "docAliasCandidates", "Lorg/rust/ide/utils/import/DocAliasCandidate;", "<init>", "(Lorg/rust/ide/inspections/import/UnresolvedReferencePathType;Ljava/util/List;Ljava/util/List;)V", "getCandidates", "()Ljava/util/List;", "getDocAliasCandidates", "createFixIfCompatible", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "Lorg/rust/lang/core/psi/ext/RsReferenceElement;", "Companion", "intellij.rustrover.core"})
public final class AutoImportFixContext
implements UnresolvedReferenceResolutionContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UnresolvedReferencePathType type;
    @NotNull
    private final List<ImportCandidate> candidates;
    @NotNull
    private final List<DocAliasCandidate> docAliasCandidates;

    public AutoImportFixContext(@NotNull UnresolvedReferencePathType type, @NotNull List<ImportCandidate> candidates2, @NotNull List<? extends DocAliasCandidate> docAliasCandidates) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(candidates2, (String)"candidates");
        Intrinsics.checkNotNullParameter(docAliasCandidates, (String)"docAliasCandidates");
        this.type = type;
        this.candidates = candidates2;
        this.docAliasCandidates = docAliasCandidates;
    }

    public /* synthetic */ AutoImportFixContext(UnresolvedReferencePathType unresolvedReferencePathType, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(unresolvedReferencePathType, list, list2);
    }

    @NotNull
    public final List<ImportCandidate> getCandidates() {
        return this.candidates;
    }

    @NotNull
    public final List<DocAliasCandidate> getDocAliasCandidates() {
        return this.docAliasCandidates;
    }

    @Override
    @NotNull
    public List<LocalQuickFix> createFixIfCompatible(@NotNull RsReferenceElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List fixes = new ArrayList();
        if (!((Collection)this.candidates).isEmpty()) {
            fixes.add(new AutoImportFix(element, this));
            if (element instanceof RsPath && this.type == UnresolvedReferencePathType.GENERAL_PATH && this.candidates.size() == 1) {
                fixes.add(new QualifyPathFix((RsPath)element, this.candidates.get(0).getInfo()));
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                for (DocAliasCandidate candidate : this.docAliasCandidates) {
                    fixes.add(new ReplaceWithDocAliasedPathFix(element, candidate));
                }
                break;
            }
            case 2: {
                if (!(element instanceof RsMethodCall)) break;
                for (DocAliasCandidate candidate : this.docAliasCandidates) {
                    if (!(candidate instanceof DocAliasCandidate.MethodAliasCandidate)) continue;
                    fixes.add(new ReplaceWithDocAliasMethodFix((RsMethodCall)element, (DocAliasCandidate.MethodAliasCandidate)candidate));
                }
                break;
            }
        }
        return fixes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/ide/inspections/import/AutoImportFixContext$Companion;", "", "<init>", "()V", "empty", "Lorg/rust/ide/inspections/import/AutoImportFixContext;", "type", "Lorg/rust/ide/inspections/import/UnresolvedReferencePathType;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AutoImportFixContext empty(@NotNull UnresolvedReferencePathType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new AutoImportFixContext(type, CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UnresolvedReferencePathType.values().length];
            try {
                nArray[UnresolvedReferencePathType.GENERAL_PATH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnresolvedReferencePathType.METHOD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

