/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler.feature;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.rust.RsBundle;
import org.rust.ide.fixes.AddFeatureAttributeFix;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.lang.core.CompilerFeature;
import org.rust.lang.core.FeatureAvailability;
import org.rust.lang.core.psi.RsExternAbi;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsOuterAttr;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.RsVariadic;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsLitExprKt;
import org.rust.lang.core.psi.ext.RsOuterAttributeOwner;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"checkVariadic", "", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "fn", "Lorg/rust/lang/core/psi/RsFunction;", "dot3", "Lcom/intellij/psi/PsiElement;", "checkValueParameterList", "params", "Lorg/rust/lang/core/psi/RsValueParameterList;", "checkExternAbi", "abi", "Lorg/rust/lang/core/psi/RsExternAbi;", "checkParamAttrs", "o", "Lorg/rust/lang/core/psi/ext/RsOuterAttributeOwner;", "intellij.rustrover.core"})
public final class RsCompilerFeatureIsUnavailableInspectionKt {
    private static final void checkVariadic(RsProblemsHolder holder, RsFunction fn, PsiElement dot3) {
        if (dot3 == null) {
            return;
        }
        if (fn.isUnsafe() && Intrinsics.areEqual((Object)RsFunctionKt.getActualAbiName(fn), (Object)"C")) {
            CompilerFeature.check$default(CompilerFeature.Companion.getC_VARIADIC(), holder, dot3, RsBundle.INSTANCE.message("c.variadic.functions", new Object[0]), null, null, 24, null);
        } else {
            Object[] objectArray = new Object[]{RsFunctionKt.getTitle(fn)};
            holder.registerProblem(dot3, RsBundle.INSTANCE.message("inspection.message.cannot.be.variadic", objectArray), new LocalQuickFix[0]);
        }
    }

    private static final void checkValueParameterList(RsProblemsHolder holder, RsValueParameterList params) {
        PsiElement psiElement2 = params.getParent();
        RsFunction rsFunction = psiElement2 instanceof RsFunction ? (RsFunction)psiElement2 : null;
        if (rsFunction == null) {
            return;
        }
        RsFunction fn = rsFunction;
        if (RsAbstractableKt.getOwner(fn) instanceof RsAbstractableOwner.Free) {
            RsVariadic rsVariadic = params.getVariadic();
            RsCompilerFeatureIsUnavailableInspectionKt.checkVariadic(holder, fn, (PsiElement)(rsVariadic != null ? rsVariadic.getDotdotdot() : null));
        }
    }

    private static final void checkExternAbi(RsProblemsHolder holder, RsExternAbi abi) {
        block3: {
            CompilerFeature compilerFeature;
            String abiName;
            RsLitExpr litExpr;
            block2: {
                RsLitExpr rsLitExpr = abi.getLitExpr();
                if (rsLitExpr == null) {
                    return;
                }
                litExpr = rsLitExpr;
                String string = RsLitExprKt.getStringValue(litExpr);
                if (string == null) {
                    return;
                }
                abiName = string;
                if (RsDiagnosticKt.getSUPPORTED_CALLING_CONVENTIONS().containsKey(abiName)) break block2;
                RsDiagnosticKt.addToHolder$default(new RsDiagnostic.InvalidAbi(litExpr, abiName), holder, false, null, 6, null);
                break block3;
            }
            CompilerFeature compilerFeature2 = compilerFeature = RsDiagnosticKt.getSUPPORTED_CALLING_CONVENTIONS().get(abiName);
            if (compilerFeature2 == null) break block3;
            Object[] objectArray = new Object[]{abiName};
            CompilerFeature.check$default(compilerFeature2, holder, (PsiElement)litExpr, RsBundle.INSTANCE.message("0.abi", objectArray), null, null, 24, null);
        }
    }

    private static final void checkParamAttrs(RsProblemsHolder holder, RsOuterAttributeOwner o) {
        RsDiagnostic.ExperimentalFeature experimentalFeature;
        List<RsOuterAttr> outerAttrs = o.getOuterAttrList();
        if (outerAttrs.isEmpty()) {
            return;
        }
        RsOuterAttr startElement = (RsOuterAttr)CollectionsKt.first(outerAttrs);
        RsOuterAttr endElement = (RsOuterAttr)CollectionsKt.last(outerAttrs);
        String message = RsBundle.INSTANCE.message("inspection.message.attributes.on.function.parameters.experimental", new Object[0]);
        switch (WhenMappings.$EnumSwitchMapping$0[CompilerFeature.Companion.getPARAM_ATTRS().availability(startElement).ordinal()]) {
            case 1: {
                experimentalFeature = new RsDiagnostic.ExperimentalFeature((PsiElement)startElement, endElement, message, CollectionsKt.emptyList());
                break;
            }
            case 2: {
                AddFeatureAttributeFix fix = CompilerFeature.Companion.getPARAM_ATTRS().addFeatureFix(startElement);
                experimentalFeature = new RsDiagnostic.ExperimentalFeature((PsiElement)startElement, endElement, message, CollectionsKt.listOf((Object)((Object)fix)));
                break;
            }
            default: {
                return;
            }
        }
        RsDiagnostic.ExperimentalFeature diagnostic = experimentalFeature;
        RsDiagnosticKt.addToHolder$default(diagnostic, holder, false, null, 6, null);
    }

    public static final /* synthetic */ void access$checkValueParameterList(RsProblemsHolder holder, RsValueParameterList params) {
        RsCompilerFeatureIsUnavailableInspectionKt.checkValueParameterList(holder, params);
    }

    public static final /* synthetic */ void access$checkExternAbi(RsProblemsHolder holder, RsExternAbi abi) {
        RsCompilerFeatureIsUnavailableInspectionKt.checkExternAbi(holder, abi);
    }

    public static final /* synthetic */ void access$checkParamAttrs(RsProblemsHolder holder, RsOuterAttributeOwner o) {
        RsCompilerFeatureIsUnavailableInspectionKt.checkParamAttrs(holder, o);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FeatureAvailability.values().length];
            try {
                nArray[FeatureAvailability.NOT_AVAILABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureAvailability.CAN_BE_ADDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

