/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler.feature;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.annotator.ReplaceGeneratorsWithCoroutinesFix;
import org.rust.ide.fixes.ReplaceBoxSyntaxFix;
import org.rust.ide.fixes.ReplaceWithInclusiveRangeFix;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.compiler.feature.RsCompilerFeatureIsUnavailableInspectionKt;
import org.rust.lang.core.CompilerFeature;
import org.rust.lang.core.FeatureAvailability;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsBracketConst;
import org.rust.lang.core.psi.RsCondition;
import org.rust.lang.core.psi.RsConstParameter;
import org.rust.lang.core.psi.RsEnumVariant;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExternAbi;
import org.rust.lang.core.psi.RsExternCrateItem;
import org.rust.lang.core.psi.RsForExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsInferType;
import org.rust.lang.core.psi.RsLabelDecl;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsLetDecl;
import org.rust.lang.core.psi.RsLetElseBranch;
import org.rust.lang.core.psi.RsLetExpr;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.RsMacro2;
import org.rust.lang.core.psi.RsMacroArgumentTT;
import org.rust.lang.core.psi.RsMacroMetavarExpression;
import org.rust.lang.core.psi.RsMatchArm;
import org.rust.lang.core.psi.RsMatchArmGuard;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsOrPat;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPatBox;
import org.rust.lang.core.psi.RsPatField;
import org.rust.lang.core.psi.RsPatIdent;
import org.rust.lang.core.psi.RsPatRange;
import org.rust.lang.core.psi.RsPatRest;
import org.rust.lang.core.psi.RsPatSlice;
import org.rust.lang.core.psi.RsPostfixMatchExpr;
import org.rust.lang.core.psi.RsSelfParameter;
import org.rust.lang.core.psi.RsTildeConst;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTraitRef;
import org.rust.lang.core.psi.RsTypeAlias;
import org.rust.lang.core.psi.RsTypeArgumentList;
import org.rust.lang.core.psi.RsTypeParameterList;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.RsUnderscoreExpr;
import org.rust.lang.core.psi.RsUseBound;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.RsVariadic;
import org.rust.lang.core.psi.RsVariantDiscriminant;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.RsWhereClause;
import org.rust.lang.core.psi.RsYieldExpr;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsBlockExprKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.psi.ext.RsForExprKt;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsItemElement;
import org.rust.lang.core.psi.ext.RsMacroMetavarExpressionKind;
import org.rust.lang.core.psi.ext.RsMacroMetavarExpressionKt;
import org.rust.lang.core.psi.ext.RsPatKt;
import org.rust.lang.core.psi.ext.RsPatRangeKt;
import org.rust.lang.core.psi.ext.RsTraitItemKt;
import org.rust.lang.core.psi.ext.RsTraitRefKt;
import org.rust.lang.core.psi.ext.RsTypeArgumentListKt;
import org.rust.lang.core.psi.ext.RsTypeParameterListKt;
import org.rust.lang.core.psi.ext.RsUnaryExprKt;
import org.rust.lang.core.psi.ext.RsUnderscoreExprKt;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.TyBool;
import org.rust.lang.core.types.ty.TyChar;
import org.rust.lang.core.types.ty.TyInteger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u000201H\u0002J\u0018\u00102\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00108\u001a\u000209H\u0002J\u0018\u0010:\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010;\u001a\u00020<H\u0002J\u0018\u0010=\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010>\u001a\u00020?H\u0002J\u0018\u0010@\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010C\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010D\u001a\u00020EH\u0002J\u0018\u0010F\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010G\u001a\u00020HH\u0002J\u0018\u0010I\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00105\u001a\u00020JH\u0002J\u0018\u0010K\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00105\u001a\u00020LH\u0002J\u0018\u0010M\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010N\u001a\u00020OH\u0002J\u0018\u0010P\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010Q\u001a\u00020RH\u0002J\u0018\u0010S\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010T\u001a\u00020UH\u0002J\u0018\u0010V\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010W\u001a\u00020XH\u0002J\u0018\u0010Y\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00105\u001a\u00020ZH\u0002J\u0018\u0010[\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\\\u001a\u00020]H\u0002J\u0018\u0010[\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010^\u001a\u00020_H\u0002J\u0018\u0010`\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020aH\u0002R\u0014\u0010b\u001a\u00020c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010e\u00a8\u0006f"}, d2={"Lorg/rust/ide/inspections/compiler/feature/RsCompilerFeatureIsUnavailableInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkExternCrate", "", "externCrate", "Lorg/rust/lang/core/psi/RsExternCrateItem;", "checkMacro2", "macro", "Lorg/rust/lang/core/psi/RsMacro2;", "checkCondition", "element", "Lorg/rust/lang/core/psi/RsCondition;", "checkOrPat", "orPat", "Lorg/rust/lang/core/psi/RsOrPat;", "checkTraitRef", "traitRef", "Lorg/rust/lang/core/psi/RsTraitRef;", "checkYieldExpr", "o", "Lorg/rust/lang/core/psi/RsYieldExpr;", "checkLetDecl", "letDecl", "Lorg/rust/lang/core/psi/RsLetDecl;", "checkLetElseBranch", "elseBranch", "Lorg/rust/lang/core/psi/RsLetElseBranch;", "checkMatchArmGuard", "guard", "Lorg/rust/lang/core/psi/RsMatchArmGuard;", "checkConstTraitImpl", "impl", "Lorg/rust/lang/core/psi/RsImplItem;", "checkTypeAlias", "ta", "Lorg/rust/lang/core/psi/RsTypeAlias;", "checkUnary", "Lorg/rust/lang/core/psi/RsUnaryExpr;", "checkLetExpr", "Lorg/rust/lang/core/psi/RsLetExpr;", "checkTildeConst", "Lorg/rust/lang/core/psi/RsTildeConst;", "checkBracketConst", "Lorg/rust/lang/core/psi/RsBracketConst;", "checkBlockExpr", "expr", "Lorg/rust/lang/core/psi/RsBlockExpr;", "checkEnumVariant", "variant", "Lorg/rust/lang/core/psi/RsEnumVariant;", "checkAsyncFor", "forExpr", "Lorg/rust/lang/core/psi/RsForExpr;", "checkPatBox", "box", "Lorg/rust/lang/core/psi/RsPatBox;", "checkPatRest", "patRest", "Lorg/rust/lang/core/psi/RsPatRest;", "checkPatField", "field", "Lorg/rust/lang/core/psi/RsPatField;", "checkPatRange", "range", "Lorg/rust/lang/core/psi/RsPatRange;", "checkLitExpr", "Lorg/rust/lang/core/psi/RsLitExpr;", "checkLambdaExpr", "Lorg/rust/lang/core/psi/RsLambdaExpr;", "checkConstParameter", "constParameter", "Lorg/rust/lang/core/psi/RsConstParameter;", "checkFunction", "fn", "Lorg/rust/lang/core/psi/RsFunction;", "checkPostfixMatch", "match", "Lorg/rust/lang/core/psi/RsPostfixMatchExpr;", "checkPreciseCapturing", "useBound", "Lorg/rust/lang/core/psi/RsUseBound;", "checkMacroMetavarExpression", "Lorg/rust/lang/core/psi/RsMacroMetavarExpression;", "checkGenericArgInfer", "type", "Lorg/rust/lang/core/psi/RsInferType;", "underscore", "Lorg/rust/lang/core/psi/RsUnderscoreExpr;", "checkTraitItem", "Lorg/rust/lang/core/psi/RsTraitItem;", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsCompilerFeatureIsUnavailableInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsCompilerFeatureIsUnavailableInspection.kt\norg/rust/ide/inspections/compiler/feature/RsCompilerFeatureIsUnavailableInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,402:1\n1#2:403\n364#3,2:404\n*S KotlinDebug\n*F\n+ 1 RsCompilerFeatureIsUnavailableInspection.kt\norg/rust/ide/inspections/compiler/feature/RsCompilerFeatureIsUnavailableInspection\n*L\n338#1:404,2\n*E\n"})
public final class RsCompilerFeatureIsUnavailableInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsCompilerFeatureIsUnavailableInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitCondition(RsCondition o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkCondition(this.this$0, this.$holder, o);
            }

            public void visitMacro22(RsMacro2 o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkMacro2(this.this$0, this.$holder, o);
            }

            public void visitOrPat(RsOrPat o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkOrPat(this.this$0, this.$holder, o);
            }

            public void visitTraitRef(RsTraitRef o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkTraitRef(this.this$0, this.$holder, o);
            }

            public void visitYieldExpr(RsYieldExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkYieldExpr(this.this$0, this.$holder, o);
            }

            public void visitLetDecl(RsLetDecl o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkLetDecl(this.this$0, this.$holder, o);
            }

            public void visitLetElseBranch(RsLetElseBranch o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkLetElseBranch(this.this$0, this.$holder, o);
            }

            public void visitMatchArmGuard(RsMatchArmGuard o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkMatchArmGuard(this.this$0, this.$holder, o);
            }

            public void visitImplItem2(RsImplItem o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkConstTraitImpl(this.this$0, this.$holder, o);
            }

            public void visitTypeAlias2(RsTypeAlias o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkTypeAlias(this.this$0, this.$holder, o);
            }

            public void visitUnaryExpr(RsUnaryExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkUnary(this.this$0, this.$holder, o);
            }

            public void visitLetExpr(RsLetExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkLetExpr(this.this$0, this.$holder, o);
            }

            public void visitTildeConst(RsTildeConst o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkTildeConst(this.this$0, this.$holder, o);
            }

            public void visitBracketConst(RsBracketConst o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkBracketConst(this.this$0, this.$holder, o);
            }

            public void visitBlockExpr(RsBlockExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkBlockExpr(this.this$0, this.$holder, o);
            }

            public void visitEnumVariant(RsEnumVariant o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkEnumVariant(this.this$0, this.$holder, o);
            }

            public void visitPatBox(RsPatBox o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkPatBox(this.this$0, this.$holder, o);
            }

            public void visitPatField(RsPatField o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkPatField(this.this$0, this.$holder, o);
            }

            public void visitPatRest(RsPatRest o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkPatRest(this.this$0, this.$holder, o);
            }

            public void visitPatRange(RsPatRange o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkPatRange(this.this$0, this.$holder, o);
            }

            public void visitLitExpr(RsLitExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkLitExpr(this.this$0, this.$holder, o);
            }

            public void visitLambdaExpr(RsLambdaExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkLambdaExpr(this.this$0, this.$holder, o);
            }

            public void visitConstParameter(RsConstParameter o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkConstParameter(this.this$0, this.$holder, o);
            }

            public void visitFunction2(RsFunction o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkFunction(this.this$0, this.$holder, o);
            }

            public void visitExternCrateItem2(RsExternCrateItem o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkExternCrate(this.this$0, this.$holder, o);
            }

            public void visitValueParameterList(RsValueParameterList o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspectionKt.access$checkValueParameterList(this.$holder, o);
            }

            public void visitExternAbi(RsExternAbi o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspectionKt.access$checkExternAbi(this.$holder, o);
            }

            public void visitSelfParameter(RsSelfParameter o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspectionKt.access$checkParamAttrs(this.$holder, o);
            }

            public void visitValueParameter(RsValueParameter o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspectionKt.access$checkParamAttrs(this.$holder, o);
            }

            public void visitVariadic(RsVariadic o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspectionKt.access$checkParamAttrs(this.$holder, o);
            }

            public void visitPostfixMatchExpr(RsPostfixMatchExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkPostfixMatch(this.this$0, this.$holder, o);
            }

            public void visitForExpr(RsForExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkAsyncFor(this.this$0, this.$holder, o);
            }

            public void visitMacroMetavarExpression(RsMacroMetavarExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkMacroMetavarExpression(this.this$0, this.$holder, o);
            }

            public void visitUseBound(RsUseBound o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkPreciseCapturing(this.this$0, this.$holder, o);
            }

            public void visitInferType(RsInferType o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkGenericArgInfer(this.this$0, this.$holder, o);
            }

            public void visitUnderscoreExpr(RsUnderscoreExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkGenericArgInfer(this.this$0, this.$holder, o);
            }

            public void visitTraitItem2(RsTraitItem o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsCompilerFeatureIsUnavailableInspection.access$checkTraitItem(this.this$0, this.$holder, o);
            }
        };
    }

    private final void checkExternCrate(RsProblemsHolder holder, RsExternCrateItem externCrate) {
        if (externCrate.getSelf() != null) {
            CompilerFeature.check$default(CompilerFeature.Companion.getEXTERN_CRATE_SELF(), holder, (PsiElement)externCrate, RsBundle.INSTANCE.message("extern.crate.self", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkMacro2(RsProblemsHolder holder, RsMacro2 macro) {
        CompilerFeature compilerFeature = CompilerFeature.Companion.getDECL_MACRO();
        PsiElement psiElement2 = macro.getMacroKw();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getMacroKw(...)");
        CompilerFeature.check$default(compilerFeature, holder, psiElement2, RsBundle.INSTANCE.message("macro", new Object[0]), null, null, 24, null);
    }

    private final void checkCondition(RsProblemsHolder holder, RsCondition element) {
        RsPat pat;
        RsExpr rsExpr = element.getExpr();
        RsLetExpr rsLetExpr = rsExpr instanceof RsLetExpr ? (RsLetExpr)rsExpr : null;
        RsPat rsPat = pat = rsLetExpr != null ? rsLetExpr.getPat() : null;
        if (pat instanceof RsOrPat) {
            CompilerFeature compilerFeature = CompilerFeature.Companion.getIF_WHILE_OR_PATTERNS();
            List<RsPat> list = ((RsOrPat)pat).getPatList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getPatList(...)");
            Object object = CollectionsKt.first(list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            PsiElement psiElement2 = (PsiElement)object;
            List<RsPat> list2 = ((RsOrPat)pat).getPatList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getPatList(...)");
            CompilerFeature.check$default(compilerFeature, holder, psiElement2, (PsiElement)CollectionsKt.last(list2), RsBundle.INSTANCE.message("inspection.message.multiple.patterns.in.if.let.while.let.are.unstable", new Object[0]), null, null, null, null, 240, null);
        }
    }

    private final void checkOrPat(RsProblemsHolder holder, RsOrPat orPat) {
        PsiElement parentParent;
        PsiElement parent2;
        PsiElement psiElement2 = parent2 = orPat.getContext();
        Object object = parentParent = psiElement2 != null ? psiElement2.getContext() : null;
        if (!(parent2 instanceof RsMatchArm || parent2 instanceof RsLetExpr && parentParent instanceof RsCondition)) {
            CompilerFeature.check$default(CompilerFeature.Companion.getOR_PATTERNS(), holder, (PsiElement)orPat, RsBundle.INSTANCE.message("or.patterns.syntax", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkTraitRef(RsProblemsHolder holder, RsTraitRef traitRef) {
        RsPathReference rsPathReference = traitRef.getPath().getReference();
        RsElement rsElement = rsPathReference != null ? rsPathReference.resolve() : null;
        RsItemElement rsItemElement = rsElement instanceof RsItemElement ? (RsItemElement)rsElement : null;
        if (rsItemElement == null) {
            return;
        }
        RsItemElement item = rsItemElement;
        if (RsTraitItemKt.isFnLikeTrait(item) && !RsTraitRefKt.getParenthesized(traitRef)) {
            CompilerFeature.check$default(CompilerFeature.Companion.getUNBOXED_CLOSURES(), holder, (PsiElement)traitRef, (PsiElement)traitRef, RsBundle.INSTANCE.message("inspection.message.precise.format.fn.family.traits.type.parameters.subject.to.change", new Object[0]), null, CollectionsKt.listOf((Object)((Object)CompilerFeature.Companion.getUNBOXED_CLOSURES().addFeatureFix(traitRef))), null, null, 208, null);
        }
        if (!RsTraitItemKt.isFnLikeTrait(item) && RsTraitRefKt.getParenthesized(traitRef)) {
            CompilerFeature.check$default(CompilerFeature.Companion.getUNBOXED_CLOSURES(), holder, (PsiElement)traitRef, (PsiElement)traitRef, RsBundle.INSTANCE.message("inspection.message.parenthetical.notation.only.stable.when.used.with.fn.family.traits", new Object[0]), null, CollectionsKt.listOf((Object)((Object)CompilerFeature.Companion.getUNBOXED_CLOSURES().addFeatureFix(traitRef))), null, null, 208, null);
        }
    }

    private final void checkYieldExpr(RsProblemsHolder holder, RsYieldExpr o) {
        CompilerFeature feature;
        Pair pair;
        if (CompilerFeature.Companion.getGENERATORS().availability(o) == FeatureAvailability.REMOVED) {
            if (RsExprKt.isInGen(o)) {
                pair = TuplesKt.to((Object)CompilerFeature.Companion.getGEN_BLOCKS(), null);
            } else {
                ReplaceGeneratorsWithCoroutinesFix replaceGeneratorsWithCoroutinesFix;
                RsMetaItem rsMetaItem = CompilerFeature.Companion.getGENERATORS().findMetaItem(o);
                if (rsMetaItem != null) {
                    RsMetaItem it2 = rsMetaItem;
                    boolean bl = false;
                    replaceGeneratorsWithCoroutinesFix = new ReplaceGeneratorsWithCoroutinesFix(it2);
                } else {
                    replaceGeneratorsWithCoroutinesFix = null;
                }
                ReplaceGeneratorsWithCoroutinesFix replaceFix = replaceGeneratorsWithCoroutinesFix;
                pair = TuplesKt.to((Object)CompilerFeature.Companion.getCOROUTINES(), (Object)((Object)replaceFix));
            }
        } else {
            feature = RsExprKt.isInGen(o) ? CompilerFeature.Companion.getGEN_BLOCKS() : CompilerFeature.Companion.getGENERATORS();
            pair = TuplesKt.to((Object)feature, null);
        }
        Pair pair2 = pair;
        feature = (CompilerFeature)pair2.component1();
        ReplaceGeneratorsWithCoroutinesFix fix = (ReplaceGeneratorsWithCoroutinesFix)((Object)pair2.component2());
        PsiElement psiElement2 = o.getYield();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getYield(...)");
        CompilerFeature.check$default(feature, holder, psiElement2, RsBundle.INSTANCE.message("yield.syntax", new Object[0]), CollectionsKt.listOfNotNull((Object)((Object)fix)), null, 16, null);
    }

    private final void checkLetDecl(RsProblemsHolder holder, RsLetDecl letDecl) {
        RsPat pat = letDecl.getPat();
        if (letDecl.getLetElseBranch() != null && pat != null && RsPatKt.isIrrefutable(pat)) {
            CompilerFeature.check$default(CompilerFeature.Companion.getIRREFUTABLE_LET_PATTERNS(), holder, (PsiElement)pat, RsBundle.INSTANCE.message("irrefutable.let.pattern", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkLetElseBranch(RsProblemsHolder holder, RsLetElseBranch elseBranch) {
        CompilerFeature.check$default(CompilerFeature.Companion.getLET_ELSE(), holder, (PsiElement)elseBranch, RsBundle.INSTANCE.message("let.else", new Object[0]), null, null, 24, null);
    }

    private final void checkMatchArmGuard(RsProblemsHolder holder, RsMatchArmGuard guard) {
        RsExpr expr = guard.getExpr();
        if (expr instanceof RsLetExpr) {
            CompilerFeature compilerFeature = CompilerFeature.Companion.getIF_LET_GUARD();
            PsiElement psiElement2 = ((RsLetExpr)expr).getLet();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getLet(...)");
            CompilerFeature.check$default(compilerFeature, holder, psiElement2, RsBundle.INSTANCE.message("if.let.guard", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkConstTraitImpl(RsProblemsHolder holder, RsImplItem impl) {
        PsiElement psiElement2 = impl.getConst();
        if (psiElement2 == null) {
            return;
        }
        PsiElement psiElement3 = psiElement2;
        CompilerFeature.check$default(CompilerFeature.Companion.getCONST_TRAIT_IMPL(), holder, psiElement3, RsBundle.INSTANCE.message("const.trait.impls", new Object[0]), null, null, 24, null);
    }

    private final void checkTypeAlias(RsProblemsHolder holder, RsTypeAlias ta) {
        RsAbstractableOwner owner = RsAbstractableKt.getOwner(ta);
        if (owner instanceof RsAbstractableOwner.Trait) {
            RsTypeReference rsTypeReference = ta.getTypeReference();
            if (rsTypeReference != null) {
                RsTypeReference it2 = rsTypeReference;
                boolean bl = false;
                CompilerFeature.check$default(CompilerFeature.Companion.getASSOCIATED_TYPE_DEFAULTS(), holder, (PsiElement)it2, RsBundle.INSTANCE.message("associated.type.defaults", new Object[0]), null, null, 24, null);
            }
            RsTypeParameterList typeParameterList = ta.getTypeParameterList();
            if (typeParameterList != null && !((Collection)RsTypeParameterListKt.getExpandedGenericParameters$default(typeParameterList, false, false, false, 7, null)).isEmpty()) {
                CompilerFeature.check$default(CompilerFeature.Companion.getGENERIC_ASSOCIATED_TYPES(), holder, (PsiElement)typeParameterList, RsBundle.INSTANCE.message("generic.associated.types", new Object[0]), null, null, 24, null);
            }
            for (RsWhereClause whereClause : ta.getWhereClauseList()) {
                CompilerFeature compilerFeature = CompilerFeature.Companion.getGENERIC_ASSOCIATED_TYPES();
                Intrinsics.checkNotNull((Object)whereClause);
                CompilerFeature.check$default(compilerFeature, holder, (PsiElement)whereClause, RsBundle.INSTANCE.message("where.clauses.on.associated.types", new Object[0]), null, null, 24, null);
            }
        } else if (owner instanceof RsAbstractableOwner.Impl) {
            RsTypeParameterList typeParameterList;
            if (((RsAbstractableOwner.Impl)owner).isInherent()) {
                CompilerFeature.check$default(CompilerFeature.Companion.getINHERENT_ASSOCIATED_TYPES(), holder, (PsiElement)ta, RsBundle.INSTANCE.message("inherent.associated.types", new Object[0]), null, null, 24, null);
            }
            if ((typeParameterList = ta.getTypeParameterList()) != null && !((Collection)RsTypeParameterListKt.getExpandedGenericParameters$default(typeParameterList, false, false, false, 7, null)).isEmpty()) {
                CompilerFeature.check$default(CompilerFeature.Companion.getGENERIC_ASSOCIATED_TYPES(), holder, (PsiElement)typeParameterList, RsBundle.INSTANCE.message("generic.associated.types", new Object[0]), null, null, 24, null);
            }
            for (RsWhereClause whereClause : ta.getWhereClauseList()) {
                CompilerFeature compilerFeature = CompilerFeature.Companion.getGENERIC_ASSOCIATED_TYPES();
                Intrinsics.checkNotNull((Object)whereClause);
                CompilerFeature.check$default(compilerFeature, holder, (PsiElement)whereClause, RsBundle.INSTANCE.message("where.clauses.on.associated.types", new Object[0]), null, null, 24, null);
            }
        } else if (owner instanceof RsAbstractableOwner.Foreign) {
            CompilerFeature.check$default(CompilerFeature.Companion.getEXTERN_TYPES(), holder, (PsiElement)ta, RsBundle.INSTANCE.message("extern.types", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkUnary(RsProblemsHolder holder, RsUnaryExpr o) {
        PsiElement raw;
        PsiElement box = o.getBox();
        if (box != null) {
            ReplaceBoxSyntaxFix fix = new ReplaceBoxSyntaxFix(o);
            CompilerFeature.check$default(CompilerFeature.Companion.getBOX_SYNTAX(), holder, box, RsBundle.INSTANCE.message("box.expression.syntax", new Object[0]), null, CollectionsKt.listOf((Object)((Object)fix)), 8, null);
        }
        if ((raw = RsUnaryExprKt.getRaw(o)) != null) {
            CompilerFeature.check$default(CompilerFeature.Companion.getRAW_REF_OP(), holder, raw, RsBundle.INSTANCE.message("raw.address.of.syntax", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkLetExpr(RsProblemsHolder holder, RsLetExpr element) {
        RsPat pat;
        PsiElement parent2 = element.getContext();
        if (!(parent2 instanceof RsCondition) && !(parent2 instanceof RsMatchArmGuard)) {
            CompilerFeature.check$default(CompilerFeature.Companion.getLET_CHAINS(), holder, (PsiElement)element, null, RsBundle.INSTANCE.message("inspection.message.let.expressions.in.this.position.are.unstable", new Object[0]), null, null, null, null, 240, null);
        }
        if ((pat = element.getPat()) != null && RsPatKt.isIrrefutable(pat)) {
            CompilerFeature.check$default(CompilerFeature.Companion.getIRREFUTABLE_LET_PATTERNS(), holder, (PsiElement)pat, RsBundle.INSTANCE.message("irrefutable.let.pattern", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkTildeConst(RsProblemsHolder holder, RsTildeConst o) {
        CompilerFeature.check$default(CompilerFeature.Companion.getCONST_TRAIT_IMPL(), holder, (PsiElement)o, RsBundle.INSTANCE.message("const.trait.impls", new Object[0]), null, null, 24, null);
        CompilerFeature.check$default(CompilerFeature.Companion.getCONST_FN_TRAIT_BOUND(), holder, (PsiElement)o, RsBundle.INSTANCE.message("const.fn.trait.bound", new Object[0]), null, null, 24, null);
    }

    private final void checkBracketConst(RsProblemsHolder holder, RsBracketConst o) {
        CompilerFeature.check$default(CompilerFeature.Companion.getCONST_TRAIT_IMPL(), holder, (PsiElement)o, RsBundle.INSTANCE.message("const.trait.impls", new Object[0]), null, null, 24, null);
        CompilerFeature.check$default(CompilerFeature.Companion.getCONST_FN_TRAIT_BOUND(), holder, (PsiElement)o, RsBundle.INSTANCE.message("const.fn.trait.bound", new Object[0]), null, null, 24, null);
    }

    private final void checkBlockExpr(RsProblemsHolder holder, RsBlockExpr expr) {
        PsiElement psiElement2;
        RsLabelDecl label = expr.getLabelDecl();
        if (label != null) {
            CompilerFeature.check$default(CompilerFeature.Companion.getLABEL_BREAK_VALUE(), holder, (PsiElement)label, RsBundle.INSTANCE.message("label.on.block", new Object[0]), null, null, 24, null);
        }
        if ((psiElement2 = expr.getConst()) != null) {
            if (expr.getContext() instanceof RsPat) {
                CompilerFeature.check$default(CompilerFeature.Companion.getINLINE_CONST_PAT(), holder, psiElement2, RsBundle.INSTANCE.message("inline.const.pat", new Object[0]), null, null, 24, null);
            } else {
                CompilerFeature.check$default(CompilerFeature.Companion.getINLINE_CONST(), holder, psiElement2, RsBundle.INSTANCE.message("inline.const", new Object[0]), null, null, 24, null);
            }
        }
        if (RsBlockExprKt.isGen(expr)) {
            CompilerFeature compilerFeature = CompilerFeature.Companion.getGEN_BLOCKS();
            PsiElement psiElement3 = RsBlockExprKt.getGen(expr);
            if (psiElement3 == null) {
                psiElement3 = expr;
            }
            CompilerFeature.check$default(compilerFeature, holder, psiElement3, RsBundle.INSTANCE.message("gen.syntax", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkEnumVariant(RsProblemsHolder holder, RsEnumVariant variant) {
        RsVariantDiscriminant rsVariantDiscriminant = variant.getVariantDiscriminant();
        if (rsVariantDiscriminant == null) {
            return;
        }
        RsVariantDiscriminant discr = rsVariantDiscriminant;
        if (variant.getBlockFields() != null || variant.getTupleFields() != null) {
            RsExpr rsExpr = discr.getExpr();
            CompilerFeature.check$default(CompilerFeature.Companion.getARBITRARY_ENUM_DISCRIMINANT(), holder, (PsiElement)(rsExpr != null ? (RsElement)rsExpr : (RsElement)discr), RsBundle.INSTANCE.message("discriminant.on.a.non.unit.variant", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkAsyncFor(RsProblemsHolder holder, RsForExpr forExpr) {
        PsiElement await = RsForExprKt.getAwait(forExpr);
        if (await != null) {
            CompilerFeature.check$default(CompilerFeature.Companion.getASYNC_FOR_LOOP(), holder, await, RsBundle.INSTANCE.message("async.for.syntax", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkPatBox(RsProblemsHolder holder, RsPatBox box) {
        CompilerFeature compilerFeature = CompilerFeature.Companion.getBOX_PATTERNS();
        PsiElement psiElement2 = box.getBox();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getBox(...)");
        CompilerFeature.check$default(compilerFeature, holder, psiElement2, RsBundle.INSTANCE.message("box.pattern.syntax", new Object[0]), null, null, 24, null);
    }

    private final void checkPatRest(RsProblemsHolder holder, RsPatRest patRest) {
        PsiElement parent2 = patRest.getContext();
        if (parent2 instanceof RsPatSlice || parent2 instanceof RsPatIdent && ((RsPatIdent)parent2).getContext() instanceof RsPatSlice) {
            CompilerFeature.check$default(CompilerFeature.Companion.getSLICE_PATTERNS(), holder, (PsiElement)patRest, RsBundle.INSTANCE.message("subslice.patterns", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkPatField(RsProblemsHolder holder, RsPatField field) {
        PsiElement psiElement2 = field.getBox();
        if (psiElement2 == null) {
            return;
        }
        PsiElement box = psiElement2;
        CompilerFeature.check$default(CompilerFeature.Companion.getBOX_PATTERNS(), holder, box, RsBundle.INSTANCE.message("box.pattern.syntax", new Object[0]), null, null, 24, null);
    }

    private final void checkPatRange(RsProblemsHolder holder, RsPatRange range) {
        if (RsPatRangeKt.isExclusive(range) && RsPatRangeKt.getEnd(range) != null) {
            CompilerFeature.check$default(CompilerFeature.Companion.getEXCLUSIVE_RANGE_PATTERN(), holder, (PsiElement)range, RsBundle.INSTANCE.message("exclusive.range.patterns", new Object[0]), CollectionsKt.listOf((Object)((Object)new ReplaceWithInclusiveRangeFix(range))), null, 16, null);
        }
        if (RsPatRangeKt.getStart(range) == null && RsPatRangeKt.getEnd(range) != null) {
            CompilerFeature.check$default(CompilerFeature.Companion.getHALF_OPEN_RANGE_PATTERNS(), holder, (PsiElement)range, RsBundle.INSTANCE.message("half.open.range.patterns", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkLitExpr(RsProblemsHolder holder, RsLitExpr expr) {
        RsLiteralKind kind2 = RsLiteralKindKt.getKind(expr);
        if (kind2 instanceof RsLiteralKind.String && ((RsLiteralKind.String)kind2).isCStr() && !(expr.getParent() instanceof RsMacroArgumentTT)) {
            CompilerFeature.check$default(CompilerFeature.Companion.getC_STR_LITERAL(), holder, (PsiElement)expr, RsBundle.INSTANCE.message("c.str.literals", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkLambdaExpr(RsProblemsHolder holder, RsLambdaExpr expr) {
        PsiElement psiElement2 = expr.getConst();
        if (psiElement2 == null) {
            return;
        }
        PsiElement psiElement3 = psiElement2;
        CompilerFeature.check$default(CompilerFeature.Companion.getCONST_CLOSURES(), holder, psiElement3, RsBundle.INSTANCE.message("const.closures", new Object[0]), null, null, 24, null);
    }

    private final void checkConstParameter(RsProblemsHolder holder, RsConstParameter constParameter) {
        RsTypeReference typeReference;
        Object object;
        CompilerFeature.check$default(CompilerFeature.Companion.getMIN_CONST_GENERICS(), holder, (PsiElement)constParameter, RsBundle.INSTANCE.message("min.const.generics", new Object[0]), null, null, 24, null);
        RsExpr rsExpr = constParameter.getExpr();
        if (rsExpr != null) {
            CompilerFeature.check$default(CompilerFeature.Companion.getCONST_GENERICS_DEFAULTS(), holder, (PsiElement)rsExpr, RsBundle.INSTANCE.message("const.generics.defaults", new Object[0]), null, null, 24, null);
        }
        if ((object = (typeReference = constParameter.getTypeReference())) == null || (object = ExtensionsKt.getRawType((RsTypeReference)object)) == null) {
            return;
        }
        Object ty2 = object;
        if (!(ty2 instanceof TyInteger || ty2 instanceof TyBool || ty2 instanceof TyChar)) {
            CompilerFeature.check$default(CompilerFeature.Companion.getADT_CONST_PARAMS(), holder, (PsiElement)typeReference, RsBundle.INSTANCE.message("adt.const.params", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkFunction(RsProblemsHolder holder, RsFunction fn) {
        if (RsFunctionKt.isGen(fn)) {
            CompilerFeature compilerFeature = CompilerFeature.Companion.getGEN_BLOCKS();
            PsiElement psiElement2 = RsFunctionKt.getGen(fn);
            if (psiElement2 == null) {
                psiElement2 = fn;
            }
            CompilerFeature.check$default(compilerFeature, holder, psiElement2, RsBundle.INSTANCE.message("gen.syntax", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkPostfixMatch(RsProblemsHolder holder, RsPostfixMatchExpr match2) {
        CompilerFeature compilerFeature = CompilerFeature.Companion.getPOSTFIX_MATCH();
        PsiElement psiElement2 = match2.getMatch();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getMatch(...)");
        CompilerFeature.check$default(compilerFeature, holder, psiElement2, RsBundle.INSTANCE.message("postfix.match.syntax", new Object[0]), null, null, 24, null);
    }

    private final void checkPreciseCapturing(RsProblemsHolder holder, RsUseBound useBound) {
        CompilerFeature.check$default(CompilerFeature.Companion.getPRECISE_CAPTURING(), holder, (PsiElement)useBound, RsBundle.INSTANCE.message("precise.capturing", new Object[0]), null, null, 24, null);
    }

    private final void checkMacroMetavarExpression(RsProblemsHolder holder, RsMacroMetavarExpression expr) {
        if (Intrinsics.areEqual((Object)RsMacroMetavarExpressionKt.getKind(expr), (Object)RsMacroMetavarExpressionKind.Concat.INSTANCE)) {
            CompilerFeature.check$default(CompilerFeature.Companion.getMACRO_METAVAR_EXPR_CONCAT(), holder, (PsiElement)expr, RsBundle.INSTANCE.message("macro.metavar.expr.concat", new Object[0]), null, null, 24, null);
        } else {
            CompilerFeature.check$default(CompilerFeature.Companion.getMACRO_METAVAR_EXPR(), holder, (PsiElement)expr, RsBundle.INSTANCE.message("macro.metavar.expr", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkGenericArgInfer(RsProblemsHolder holder, RsInferType type) {
        PsiElement $this$contextOfType_u24default$iv = type;
        boolean withSelf$iv = false;
        boolean $i$f$contextOfType = false;
        Object object = (RsTypeArgumentList)PsiTreeUtil.getContextOfType((PsiElement)$this$contextOfType_u24default$iv, RsTypeArgumentList.class, (boolean)true);
        boolean bl = object != null && (object = RsTypeArgumentListKt.getConstArguments((RsTypeArgumentList)object)) != null ? object.contains(type) : false;
        if (bl) {
            CompilerFeature.check$default(CompilerFeature.Companion.getGENERIC_ARG_INFER(), holder, (PsiElement)type, RsBundle.INSTANCE.message("generic.arg.infer", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkGenericArgInfer(RsProblemsHolder holder, RsUnderscoreExpr underscore) {
        if (RsUnderscoreExprKt.isCtPlaceholder(underscore)) {
            CompilerFeature.check$default(CompilerFeature.Companion.getGENERIC_ARG_INFER(), holder, (PsiElement)underscore, RsBundle.INSTANCE.message("generic.arg.infer", new Object[0]), null, null, 24, null);
        }
    }

    private final void checkTraitItem(RsProblemsHolder holder, RsTraitItem o) {
        PsiElement constKw = o.getConst();
        if (constKw != null) {
            CompilerFeature.check$default(CompilerFeature.Companion.getCONST_TRAIT_IMPL(), holder, constKw, RsBundle.INSTANCE.message("const.trait", new Object[0]), null, null, 24, null);
        }
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkCondition(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsCondition element) {
        $this.checkCondition(holder, element);
    }

    public static final /* synthetic */ void access$checkMacro2(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsMacro2 macro) {
        $this.checkMacro2(holder, macro);
    }

    public static final /* synthetic */ void access$checkOrPat(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsOrPat orPat) {
        $this.checkOrPat(holder, orPat);
    }

    public static final /* synthetic */ void access$checkTraitRef(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsTraitRef traitRef) {
        $this.checkTraitRef(holder, traitRef);
    }

    public static final /* synthetic */ void access$checkYieldExpr(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsYieldExpr o) {
        $this.checkYieldExpr(holder, o);
    }

    public static final /* synthetic */ void access$checkLetDecl(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsLetDecl letDecl) {
        $this.checkLetDecl(holder, letDecl);
    }

    public static final /* synthetic */ void access$checkLetElseBranch(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsLetElseBranch elseBranch) {
        $this.checkLetElseBranch(holder, elseBranch);
    }

    public static final /* synthetic */ void access$checkMatchArmGuard(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsMatchArmGuard guard) {
        $this.checkMatchArmGuard(holder, guard);
    }

    public static final /* synthetic */ void access$checkConstTraitImpl(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsImplItem impl) {
        $this.checkConstTraitImpl(holder, impl);
    }

    public static final /* synthetic */ void access$checkTypeAlias(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsTypeAlias ta) {
        $this.checkTypeAlias(holder, ta);
    }

    public static final /* synthetic */ void access$checkUnary(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsUnaryExpr o) {
        $this.checkUnary(holder, o);
    }

    public static final /* synthetic */ void access$checkLetExpr(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsLetExpr element) {
        $this.checkLetExpr(holder, element);
    }

    public static final /* synthetic */ void access$checkTildeConst(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsTildeConst o) {
        $this.checkTildeConst(holder, o);
    }

    public static final /* synthetic */ void access$checkBracketConst(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsBracketConst o) {
        $this.checkBracketConst(holder, o);
    }

    public static final /* synthetic */ void access$checkBlockExpr(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsBlockExpr expr) {
        $this.checkBlockExpr(holder, expr);
    }

    public static final /* synthetic */ void access$checkEnumVariant(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsEnumVariant variant) {
        $this.checkEnumVariant(holder, variant);
    }

    public static final /* synthetic */ void access$checkPatBox(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsPatBox box) {
        $this.checkPatBox(holder, box);
    }

    public static final /* synthetic */ void access$checkPatField(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsPatField field) {
        $this.checkPatField(holder, field);
    }

    public static final /* synthetic */ void access$checkPatRest(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsPatRest patRest) {
        $this.checkPatRest(holder, patRest);
    }

    public static final /* synthetic */ void access$checkPatRange(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsPatRange range) {
        $this.checkPatRange(holder, range);
    }

    public static final /* synthetic */ void access$checkLitExpr(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsLitExpr expr) {
        $this.checkLitExpr(holder, expr);
    }

    public static final /* synthetic */ void access$checkLambdaExpr(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsLambdaExpr expr) {
        $this.checkLambdaExpr(holder, expr);
    }

    public static final /* synthetic */ void access$checkConstParameter(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsConstParameter constParameter) {
        $this.checkConstParameter(holder, constParameter);
    }

    public static final /* synthetic */ void access$checkFunction(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsFunction fn) {
        $this.checkFunction(holder, fn);
    }

    public static final /* synthetic */ void access$checkExternCrate(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsExternCrateItem externCrate) {
        $this.checkExternCrate(holder, externCrate);
    }

    public static final /* synthetic */ void access$checkPostfixMatch(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsPostfixMatchExpr match2) {
        $this.checkPostfixMatch(holder, match2);
    }

    public static final /* synthetic */ void access$checkAsyncFor(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsForExpr forExpr) {
        $this.checkAsyncFor(holder, forExpr);
    }

    public static final /* synthetic */ void access$checkMacroMetavarExpression(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsMacroMetavarExpression expr) {
        $this.checkMacroMetavarExpression(holder, expr);
    }

    public static final /* synthetic */ void access$checkPreciseCapturing(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsUseBound useBound) {
        $this.checkPreciseCapturing(holder, useBound);
    }

    public static final /* synthetic */ void access$checkGenericArgInfer(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsInferType type) {
        $this.checkGenericArgInfer(holder, type);
    }

    public static final /* synthetic */ void access$checkGenericArgInfer(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsUnderscoreExpr underscore) {
        $this.checkGenericArgInfer(holder, underscore);
    }

    public static final /* synthetic */ void access$checkTraitItem(RsCompilerFeatureIsUnavailableInspection $this, RsProblemsHolder holder, RsTraitItem o) {
        $this.checkTraitItem(holder, o);
    }
}

