/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.compiler.RsUnsafeErrorInspectionKt;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFieldLookupExpr;
import org.rust.lang.core.psi.RsForeignModItem;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsMacroExpr;
import org.rust.lang.core.psi.RsMethodCallExpr;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.AssignmentOp;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsConstantKind;
import org.rust.lang.core.psi.ext.RsConstantKt;
import org.rust.lang.core.psi.ext.RsDotExpr;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsMacroCallKt;
import org.rust.lang.core.psi.ext.RsMacroDefinitionBase;
import org.rust.lang.core.psi.ext.RsStructItemKt;
import org.rust.lang.core.psi.ext.RsStructKind;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElement;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.stubs.RsPlaceholderStub;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.core.types.ty.TyRawPtr;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lorg/rust/ide/inspections/compiler/RsUnsafeErrorInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "annotateUnsafeCall", "", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "annotateUnsafeStaticRef", "Lorg/rust/lang/core/psi/RsPathExpr;", "element", "Lorg/rust/lang/core/psi/RsConstant;", "checkDotExpr", "o", "Lorg/rust/lang/core/psi/ext/RsDotExpr;", "isLhsOfBinaryAssignExpr", "checkCall", "Lorg/rust/lang/core/psi/RsCallExpr;", "checkPathExpr", "checkUnary", "Lorg/rust/lang/core/psi/RsUnaryExpr;", "checkMacroExpr", "macroExpr", "Lorg/rust/lang/core/psi/RsMacroExpr;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsUnsafeErrorInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsUnsafeErrorInspection.kt\norg/rust/ide/inspections/compiler/RsUnsafeErrorInspection\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,122:1\n19#2:123\n*S KotlinDebug\n*F\n+ 1 RsUnsafeErrorInspection.kt\norg/rust/ide/inspections/compiler/RsUnsafeErrorInspection\n*L\n56#1:123\n*E\n"})
public final class RsUnsafeErrorInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsUnsafeErrorInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitCallExpr(RsCallExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsUnsafeErrorInspection.access$checkCall(this.this$0, o, this.$holder);
            }

            public void visitFieldLookupExpr(RsFieldLookupExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsUnsafeErrorInspection.access$checkDotExpr(this.this$0, o, this.$holder);
            }

            public void visitMethodCallExpr(RsMethodCallExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsUnsafeErrorInspection.access$checkDotExpr(this.this$0, o, this.$holder);
            }

            public void visitPathExpr(RsPathExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsUnsafeErrorInspection.access$checkPathExpr(this.this$0, o, this.$holder);
            }

            public void visitUnaryExpr(RsUnaryExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsUnsafeErrorInspection.access$checkUnary(this.this$0, o, this.$holder);
            }

            public void visitMacroExpr(RsMacroExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsUnsafeErrorInspection.access$checkMacroExpr(this.this$0, o, this.$holder);
            }
        };
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    private final void annotateUnsafeCall(RsExpr expr, RsProblemsHolder holder) {
        if (!CfgUtilsKt.getExistsAfterExpansion(expr)) {
            return;
        }
        if (!RsExprKt.isInUnsafeContext(expr)) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnsafeError(expr, RsBundle.INSTANCE.message("inspection.message.call.to.unsafe.function.requires.unsafe.function.or.block", new Object[0])), holder, false, null, 6, null);
        }
    }

    private final void annotateUnsafeStaticRef(RsPathExpr expr, RsConstant element, RsProblemsHolder holder) {
        String string;
        if (RsConstantKt.getKind(element) == RsConstantKind.MUT_STATIC) {
            string = RsBundle.INSTANCE.message("inspection.message.mutable", new Object[0]);
        } else if (RsConstantKt.getKind(element) == RsConstantKind.STATIC && element.getContext() instanceof RsForeignModItem) {
            string = RsBundle.INSTANCE.message("inspection.message.extern", new Object[0]);
        } else {
            return;
        }
        String constantType = string;
        if (!RsExprKt.isInUnsafeContext(expr)) {
            Object[] objectArray = new Object[]{constantType};
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnsafeError(expr, RsBundle.INSTANCE.message("inspection.message.use.static.unsafe.requires.unsafe.function.or.block", objectArray)), holder, false, null, 6, null);
        }
    }

    private final void checkDotExpr(RsDotExpr o, RsProblemsHolder holder) {
        RsElement rsElement;
        RsDotExpr $this$asSafely$iv = o;
        boolean $i$f$asSafely = false;
        RsDotExpr rsDotExpr = $this$asSafely$iv;
        if (!(rsDotExpr instanceof RsMethodCallExpr)) {
            rsDotExpr = null;
        }
        if ((rsElement = (RsMethodCallExpr)rsDotExpr) != null && (rsElement = rsElement.getMethodCall()) != null) {
            RsElement it2 = rsElement;
            boolean bl = false;
            RsElement rsElement2 = it2.getReference().resolve();
            RsFunction rsFunction = rsElement2 instanceof RsFunction ? (RsFunction)rsElement2 : null;
            if (rsFunction == null) {
                return;
            }
            RsFunction fn = rsFunction;
            if (RsFunctionKt.getUnsafetyStatus(fn).isActuallyUnsafe(o)) {
                this.annotateUnsafeCall(o, holder);
            }
        }
        if (this.isLhsOfBinaryAssignExpr(o)) {
            return;
        }
        if (o instanceof RsFieldLookupExpr) {
            RsExpr rsExpr = ((RsFieldLookupExpr)o).getReceiver();
            Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"<get-receiver>(...)");
            Ty type = ExtensionsKt.getType(rsExpr);
            if (!(type instanceof TyAdt)) {
                return;
            }
            RsStructOrEnumItemElement item = ((TyAdt)type).getItem();
            if (!(item instanceof RsStructItem)) {
                return;
            }
            if (RsStructItemKt.getKind((RsStructItem)item) == RsStructKind.UNION) {
                RsExpr rsExpr2 = ((RsFieldLookupExpr)o).getReceiver();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr2, (String)"<get-receiver>(...)");
                if (!RsExprKt.isInUnsafeContext(rsExpr2)) {
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnsafeError(o, RsBundle.INSTANCE.message("inspection.message.access.to.union.field.unsafe.requires.unsafe.function.or.block", new Object[0])), holder, false, null, 6, null);
                }
            }
        }
    }

    private final boolean isLhsOfBinaryAssignExpr(RsDotExpr o) {
        Pair<PsiElement, PsiElement> pair = PsiElementKt.contextAndThisSkipMacroExpr(o);
        PsiElement binaryExpr = (PsiElement)pair.component1();
        PsiElement child = (PsiElement)pair.component2();
        return binaryExpr instanceof RsBinaryExpr && Intrinsics.areEqual((Object)RsExprKt.getOperatorType((RsBinaryExpr)binaryExpr), (Object)AssignmentOp.EQ.INSTANCE) && Intrinsics.areEqual((Object)((RsBinaryExpr)binaryExpr).getLeft(), (Object)child);
    }

    private final void checkCall(RsCallExpr element, RsProblemsHolder holder) {
        RsExpr rsExpr = element.getExpr();
        StubBasedPsiElement<RsPlaceholderStub<?>> stubBasedPsiElement = rsExpr instanceof RsPathExpr ? (RsPathExpr)rsExpr : null;
        if (stubBasedPsiElement == null || (stubBasedPsiElement = stubBasedPsiElement.getPath()) == null) {
            return;
        }
        StubBasedPsiElement<RsPlaceholderStub<?>> path = stubBasedPsiElement;
        RsPathReference rsPathReference = path.getReference();
        RsElement rsElement = rsPathReference != null ? rsPathReference.resolve() : null;
        RsFunction rsFunction = rsElement instanceof RsFunction ? (RsFunction)rsElement : null;
        if (rsFunction == null) {
            return;
        }
        RsFunction fn = rsFunction;
        if (RsFunctionKt.getUnsafetyStatus(fn).isActuallyUnsafe(element)) {
            this.annotateUnsafeCall(element, holder);
        }
    }

    private final void checkPathExpr(RsPathExpr expr, RsProblemsHolder holder) {
        RsPathReference rsPathReference = expr.getPath().getReference();
        RsElement rsElement = rsPathReference != null ? rsPathReference.resolve() : null;
        RsConstant rsConstant = rsElement instanceof RsConstant ? (RsConstant)rsElement : null;
        if (rsConstant == null) {
            return;
        }
        RsConstant constant = rsConstant;
        this.annotateUnsafeStaticRef(expr, constant, holder);
    }

    private final void checkUnary(RsUnaryExpr element, RsProblemsHolder holder) {
        PsiElement psiElement2 = element.getMul();
        if (psiElement2 == null) {
            return;
        }
        PsiElement mul = psiElement2;
        RsExpr rsExpr = element.getExpr();
        if (!((rsExpr != null ? ExtensionsKt.getType(rsExpr) : null) instanceof TyRawPtr)) {
            return;
        }
        if (!RsExprKt.isInUnsafeContext(element)) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnsafeError(element, RsBundle.INSTANCE.message("inspection.message.dereference.raw.pointer.requires.unsafe.function.or.block", new Object[0])), holder, false, null, 6, null);
        }
    }

    private final void checkMacroExpr(RsMacroExpr macroExpr, RsProblemsHolder holder) {
        RsMacroDefinitionBase macroDef;
        RsMacroCall rsMacroCall = macroExpr.getMacroCall();
        Intrinsics.checkNotNullExpressionValue((Object)rsMacroCall, (String)"getMacroCall(...)");
        RsMacroCall macroCall = rsMacroCall;
        String macroName = RsMacroCallKt.getMacroName(macroCall);
        if (RsUnsafeErrorInspectionKt.access$getUNSAFE_MACRO_LIST$p().contains(macroName) && (macroDef = RsMacroCallKt.resolveToMacro(macroCall)) != null && macroDef.getHasRustcBuiltinMacro() && !RsExprKt.isInUnsafeContext(macroExpr)) {
            Object[] objectArray = new Object[]{macroName};
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.UnsafeError(macroExpr, RsBundle.INSTANCE.message("inspection.message.use.unsafe.requires.unsafe.function.or.block", objectArray)), holder, false, null, 6, null);
        }
    }

    public static final /* synthetic */ void access$checkCall(RsUnsafeErrorInspection $this, RsCallExpr element, RsProblemsHolder holder) {
        $this.checkCall(element, holder);
    }

    public static final /* synthetic */ void access$checkDotExpr(RsUnsafeErrorInspection $this, RsDotExpr o, RsProblemsHolder holder) {
        $this.checkDotExpr(o, holder);
    }

    public static final /* synthetic */ void access$checkPathExpr(RsUnsafeErrorInspection $this, RsPathExpr expr, RsProblemsHolder holder) {
        $this.checkPathExpr(expr, holder);
    }

    public static final /* synthetic */ void access$checkUnary(RsUnsafeErrorInspection $this, RsUnaryExpr element, RsProblemsHolder holder) {
        $this.checkUnary(element, holder);
    }

    public static final /* synthetic */ void access$checkMacroExpr(RsUnsafeErrorInspection $this, RsMacroExpr macroExpr, RsProblemsHolder holder) {
        $this.checkMacroExpr(macroExpr, holder);
    }
}

