/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.fixes.AddMissingSupertraitImplFix;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.compiler.RsSuperTraitIsNotImplementedInspectionKt;
import org.rust.ide.presentation.RsPsiRendererKt;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.MacroExpansionMode;
import org.rust.lang.core.psi.RsBound;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsPolybound;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTraitRef;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsTraitRefKt;
import org.rust.lang.core.resolve.ImplLookup;
import org.rust.lang.core.types.BoundElement;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.Substitution;
import org.rust.lang.core.types.SubstitutionKt;
import org.rust.lang.core.types.TraitRef;
import org.rust.lang.core.types.infer.FoldKt;
import org.rust.lang.core.types.infer.ObligationCause;
import org.rust.lang.core.types.infer.RsInferenceContext;
import org.rust.lang.core.types.infer.TypeFoldable;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyTypeParameter;
import org.rust.lang.core.types.ty.TyUnknown;
import org.rust.lang.utils.QuickFixWithRange;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;
import org.rust.lang.utils.RsErrorCode;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/inspections/compiler/RsSuperTraitIsNotImplementedInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsSuperTraitIsNotImplementedInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitImplItem2(RsImplItem o) {
                Collection destination$iv$iv;
                Class[] classArray;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (!UtilsKt.isUnitTestMode()) {
                    Project project = o.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    if (!(MacroExpansionManagerKt.getMacroExpansionManager(project).getMacroExpansionMode() instanceof MacroExpansionMode.New)) {
                        return;
                    }
                }
                RsTraitRef rsTraitRef = o.getTraitRef();
                if (rsTraitRef == null) {
                    return;
                }
                RsTraitRef traitRef = rsTraitRef;
                RsTraitItem rsTraitItem = RsTraitRefKt.resolveToTrait(traitRef);
                if (rsTraitItem == null) {
                    return;
                }
                RsTraitItem trait = rsTraitItem;
                RsTypeReference rsTypeReference = o.getTypeReference();
                if (rsTypeReference == null) {
                    return;
                }
                RsTypeReference typeRef = rsTypeReference;
                Ty type = ExtensionsKt.getNormType(typeRef);
                if (FoldKt.containsTyOfClass((TypeFoldable)type, classArray = new Class[]{TyUnknown.class})) {
                    return;
                }
                Object object = trait.getTypeParamBounds();
                if (object != null && (object = object.getPolyboundList()) != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)object;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        RsBound it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        RsPolybound it2 = (RsPolybound)element$iv$iv;
                        boolean bl2 = false;
                        if (it2.getBound() == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                } else {
                    return;
                }
                List supertraits = (List)destination$iv$iv;
                ImplLookup lookup2 = ExtensionsKt.getImplLookup(o);
                Substitution selfSubst = SubstitutionKt.toTypeSubst(MapsKt.mapOf((Pair)TuplesKt.to((Object)TyTypeParameter.Companion.self(), (Object)type)));
                TypeFoldable<BoundElement<E>> typeFoldable = o.getImplementedTrait();
                if (typeFoldable == null || (typeFoldable = ((BoundElement)typeFoldable).getSubst()) == null) {
                    typeFoldable = SubstitutionKt.getEmptySubstitution();
                }
                Substitution substitution = ((Substitution)typeFoldable).substituteInValues(selfSubst).plus(selfSubst);
                boolean fixRegistered = false;
                for (RsBound bound : supertraits) {
                    RsDiagnostic.SuperTraitIsNotImplemented superTraitIsNotImplemented;
                    BoundElement<RsTraitItem> boundTrait;
                    RsTraitRef requiredTrait;
                    if (bound.getTraitRef() == null || RsTraitRefKt.resolveToBoundTrait(requiredTrait) == null) continue;
                    BoundElement locallyBoundTrait = (BoundElement)lookup2.getCtx().fullyNormalizeAssociatedTypesIn(FoldKt.substitute((TypeFoldable)boundTrait, substitution));
                    RsInferenceContext.MutingReason mutedError = lookup2.getCtx().shouldMuteObligationError(new ObligationCause.Misc(traitRef), type, locallyBoundTrait, RsSuperTraitIsNotImplementedInspectionKt.access$getIGNORED_TYPES_FOR_SUPER_TRAIT_CHECK$p());
                    if (mutedError != null) {
                        mutedError.report(traitRef, RsErrorCode.E0277);
                        continue;
                    }
                    boolean canSelect = ImplLookup.canSelect$default(lookup2, new TraitRef(type, locallyBoundTrait), 0, 2, null);
                    if (canSelect) continue;
                    String missingTrait = RsPsiRendererKt.getStubOnlyText$default(requiredTrait, substitution, false, 2, null);
                    if (!fixRegistered) {
                        fixRegistered = true;
                        AddMissingSupertraitImplFix fix = new AddMissingSupertraitImplFix(o);
                        PsiElement psiElement2 = o.getImpl();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getImpl(...)");
                        TextRange range = new TextRange(PsiElementKt.getStartOffset(psiElement2), PsiElementKt.getEndOffset(typeRef));
                        superTraitIsNotImplemented = new RsDiagnostic.SuperTraitIsNotImplemented(traitRef, type, missingTrait, new QuickFixWithRange(fix, range));
                    } else {
                        superTraitIsNotImplemented = new RsDiagnostic.SuperTraitIsNotImplemented(traitRef, type, missingTrait, null);
                    }
                    RsDiagnosticKt.addToHolder$default(superTraitIsNotImplemented, this.$holder, false, null, 6, null);
                }
            }
        };
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }
}

