/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.compiler.RsRemoveSuperStructsFix;
import org.rust.lang.core.psi.RsSuperStructs;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002R$\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/rust/ide/inspections/compiler/RsStructInheritanceInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkSuperStructs", "", "element", "Lorg/rust/lang/core/psi/RsSuperStructs;", "combinedRange", "Lcom/intellij/openapi/util/TextRange;", "", "Lcom/intellij/psi/PsiElement;", "getCombinedRange", "([Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/util/TextRange;", "isSyntaxOnly", "()Z", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsStructInheritanceInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsStructInheritanceInspection.kt\norg/rust/ide/inspections/compiler/RsStructInheritanceInspection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n37#2,2:48\n1563#3:50\n1634#3,3:51\n2783#3,7:54\n*S KotlinDebug\n*F\n+ 1 RsStructInheritanceInspection.kt\norg/rust/ide/inspections/compiler/RsStructInheritanceInspection\n*L\n24#1:48,2\n37#1:50\n37#1:51,3\n38#1:54,7\n*E\n"})
public final class RsStructInheritanceInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsStructInheritanceInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitSuperStructs(RsSuperStructs o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsStructInheritanceInspection.access$checkSuperStructs(this.this$0, this.$holder, o);
            }
        };
    }

    private final void checkSuperStructs(RsProblemsHolder holder, RsSuperStructs element) {
        List<RsTypeReference> list = element.getTypeReferenceList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeReferenceList(...)");
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TextRange textRange = this.getCombinedRange(thisCollection$iv.toArray(new RsTypeReference[0]));
        if (textRange == null) {
            return;
        }
        TextRange range = textRange;
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RsRemoveSuperStructsFix(element)};
        RsProblemsHolder.registerProblem$default(holder, (PsiElement)element, new TextRange(range.getStartOffset() - element.getTextRange().getStartOffset(), range.getEndOffset() - element.getTextRange().getStartOffset()), RsBundle.INSTANCE.message("error.message.struct.inheritance.is.not.supported", new Object[0]), localQuickFixArray, false, null, null, 112, null);
    }

    /*
     * WARNING - void declaration
     */
    private final TextRange getCombinedRange(PsiElement[] $this$combinedRange) {
        TextRange textRange;
        if ($this$combinedRange.length == 0) {
            textRange = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ArraysKt.filterNotNull((Object[])$this$combinedRange);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                PsiElement psiElement2 = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.getTextRange());
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p1;
                TextRange $i$f$mapTo2 = (TextRange)iterator$iv.next();
                TextRange p0 = (TextRange)accumulator$iv;
                boolean bl = false;
                accumulator$iv = p0.union((TextRange)p1);
            }
            textRange = (TextRange)accumulator$iv;
        }
        return textRange;
    }

    @Override
    public boolean isSyntaxOnly() {
        return true;
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkSuperStructs(RsStructInheritanceInspection $this, RsProblemsHolder holder, RsSuperStructs element) {
        $this.checkSuperStructs(holder, element);
    }
}

