/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.MakePublicFix;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.compiler.RsReferenceIsNotPublicInspectionKt;
import org.rust.lang.core.psi.RsDebuggerExpressionCodeFragment;
import org.rust.lang.core.psi.RsFieldLookup;
import org.rust.lang.core.psi.RsFieldLookupExpr;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsMethodCallExpr;
import org.rust.lang.core.psi.RsNamedFieldDecl;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsStructLiteralField;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsItemElement;
import org.rust.lang.core.psi.ext.RsItemElementKt;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsPathKt;
import org.rust.lang.core.psi.ext.RsReferenceElement;
import org.rust.lang.core.psi.ext.RsVisibilityKt;
import org.rust.lang.core.psi.ext.RsVisibilityOwner;
import org.rust.lang.core.psi.ext.RsVisible;
import org.rust.lang.core.resolve.ref.RsReference;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;
import org.rust.lang.utils.RsErrorCode;
import org.rust.stdext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/inspections/compiler/RsReferenceIsNotPublicInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsReferenceIsNotPublicInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPath(RsPath o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (RsPathKt.isInsideDocLink(o)) {
                    return;
                }
                if (RsPathKt.isSelfImport(o)) {
                    return;
                }
                this.checkReferenceIsPublic(o, o, this.$holder);
            }

            public void visitFieldLookupExpr(RsFieldLookupExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsFieldLookup rsFieldLookup = o.getFieldLookup();
                Intrinsics.checkNotNullExpressionValue((Object)rsFieldLookup, (String)"getFieldLookup(...)");
                this.checkReferenceIsPublic(rsFieldLookup, o, this.$holder);
            }

            public void visitMethodCallExpr(RsMethodCallExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsMethodCall rsMethodCall = o.getMethodCall();
                Intrinsics.checkNotNullExpressionValue((Object)rsMethodCall, (String)"getMethodCall(...)");
                this.checkReferenceIsPublic(rsMethodCall, o, this.$holder);
            }

            public void visitStructLiteralField(RsStructLiteralField o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                this.checkReferenceIsPublic(o, o, this.$holder);
            }

            private final void checkReferenceIsPublic(RsReferenceElement ref, RsElement o, RsProblemsHolder holder) {
                RsDiagnostic rsDiagnostic;
                RsElement rsElement;
                if (o.getContainingFile() instanceof RsDebuggerExpressionCodeFragment) {
                    return;
                }
                RsReference rsReference = ref.getReference();
                if (rsReference == null) {
                    return;
                }
                RsReference reference = rsReference;
                PsiElement psiElement2 = ref.getReferenceNameElement();
                if (psiElement2 == null) {
                    return;
                }
                PsiElement highlightedElement = psiElement2;
                String string = ref.getReferenceName();
                if (string == null) {
                    return;
                }
                String referenceName = string;
                if (ref instanceof RsStructLiteralField) {
                    Object v3;
                    block17: {
                        Iterable $this$firstOrNull$iv = reference.multiResolve();
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            RsElement it2 = (RsElement)element$iv;
                            boolean bl = false;
                            if (!(it2 instanceof RsVisible)) continue;
                            v3 = element$iv;
                            break block17;
                        }
                        v3 = null;
                    }
                    rsElement = v3;
                } else {
                    rsElement = reference.resolve();
                }
                RsElement rsElement2 = rsElement;
                RsVisible rsVisible = rsElement2 instanceof RsVisible ? (RsVisible)rsElement2 : null;
                if (rsVisible == null) {
                    return;
                }
                RsVisible resolvedElement = rsVisible;
                if (RsReferenceIsNotPublicInspectionKt.access$checkQualifiedPathAccessError(ref, highlightedElement, resolvedElement, referenceName, holder)) {
                    return;
                }
                PsiElement $this$contextStrict$iv = o;
                boolean $i$f$contextStrict = false;
                RsMod rsMod = (RsMod)PsiTreeUtil.getContextOfType((PsiElement)$this$contextStrict$iv, RsMod.class, (boolean)true);
                if (rsMod == null) {
                    return;
                }
                RsMod oMod = rsMod;
                if (RsVisibilityKt.isVisibleFrom(resolvedElement, oMod)) {
                    return;
                }
                boolean withinOneCrate = Intrinsics.areEqual((Object)resolvedElement.getCrateRoot(), (Object)o.getCrateRoot());
                RsVisible $i$f$firstOrNull = resolvedElement;
                RsVisibilityOwner rsVisibilityOwner = $i$f$firstOrNull instanceof RsVisibilityOwner ? (RsVisibilityOwner)resolvedElement : ($i$f$firstOrNull instanceof RsFile ? (RsVisibilityOwner)((RsFile)resolvedElement).getDeclaration() : null);
                if (rsVisibilityOwner == null) {
                    return;
                }
                RsVisibilityOwner element = rsVisibilityOwner;
                if (element instanceof RsNamedFieldDecl) {
                    PsiElement $this$contextStrict$iv2 = element;
                    boolean $i$f$contextStrict2 = false;
                    Object object = (RsStructItem)PsiTreeUtil.getContextOfType((PsiElement)$this$contextStrict$iv2, RsStructItem.class, (boolean)true);
                    if (object == null || (object = object.getCrateRelativePath()) == null || (object = StringsKt.removePrefix((String)object, (CharSequence)"::")) == null) {
                        object = "";
                    }
                    Object structName = object;
                    rsDiagnostic = new RsDiagnostic.StructFieldAccessError(highlightedElement, referenceName, (String)structName, MakePublicFix.Companion.createIfCompatible(element, ((RsNamedFieldDecl)element).getName(), withinOneCrate));
                } else if (ref instanceof RsMethodCall) {
                    rsDiagnostic = new RsDiagnostic.AccessError(highlightedElement, RsErrorCode.E0624, RsBundle.INSTANCE.message("inspection.message.method", new Object[0]), MakePublicFix.Companion.createIfCompatible(element, referenceName, withinOneCrate));
                } else {
                    String itemType = UtilsKt.capitalized(element instanceof RsItemElement ? RsItemElementKt.getItemKindName((RsItemElement)element) : RsBundle.INSTANCE.message("item", new Object[0]));
                    rsDiagnostic = new RsDiagnostic.AccessError(highlightedElement, RsErrorCode.E0603, itemType, MakePublicFix.Companion.createIfCompatible(element, referenceName, withinOneCrate));
                }
                RsDiagnostic error = rsDiagnostic;
                RsDiagnosticKt.addToHolder$default(error, holder, false, null, 6, null);
            }
        };
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }
}

