/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.annotator.AnnotatorUtilsKt;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsFnPointerType;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPatConst;
import org.rust.lang.core.psi.RsPatIdent;
import org.rust.lang.core.psi.RsPatMacro;
import org.rust.lang.core.psi.RsPatRange;
import org.rust.lang.core.psi.RsPatWild;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsBindingModeKind;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsPatBindingKt;
import org.rust.lang.core.psi.ext.RsPatKt;
import org.rust.lang.core.psi.ext.RsPatRangeKt;
import org.rust.lang.core.types.ty.Mutability;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0016H\u0002R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/rust/ide/inspections/compiler/RsPatternsAreNotAllowedInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkGeneralPat", "", "element", "Lorg/rust/lang/core/psi/RsPat;", "checkFunctionParameterPatIsSimple", "fn", "Lorg/rust/lang/core/psi/RsFunction;", "checkFunctionPointerTypeParameterPatIsSimple", "isComplexPattern", "pat", "checkPat", "checkPatRange", "Lorg/rust/lang/core/psi/RsPatRange;", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsPatternsAreNotAllowedInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsPatternsAreNotAllowedInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitPat(RsPat o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsPatternsAreNotAllowedInspection.access$checkGeneralPat(this.this$0, o, this.$holder);
                RsPatternsAreNotAllowedInspection.access$checkPat(this.this$0, this.$holder, o);
            }
        };
    }

    private final void checkGeneralPat(RsPat element, RsProblemsHolder holder) {
        PsiElement valueParameter = element.getParent();
        if (!(valueParameter instanceof RsValueParameter)) {
            return;
        }
        PsiElement psiElement2 = ((RsValueParameter)valueParameter).getParent().getParent();
        if (psiElement2 == null) {
            return;
        }
        PsiElement fn = psiElement2;
        PsiElement psiElement3 = fn;
        if (psiElement3 instanceof RsFunction) {
            this.checkFunctionParameterPatIsSimple((RsFunction)fn, element, holder);
        } else if (psiElement3 instanceof RsFnPointerType) {
            this.checkFunctionPointerTypeParameterPatIsSimple(element, holder);
        }
    }

    private final void checkFunctionParameterPatIsSimple(RsFunction fn, RsPat element, RsProblemsHolder holder) {
        boolean isComplexPattern = this.isComplexPattern(element);
        RsAbstractableOwner rsAbstractableOwner = RsAbstractableKt.getOwner(fn);
        if (rsAbstractableOwner instanceof RsAbstractableOwner.Foreign) {
            if (isComplexPattern) {
                RsDiagnosticKt.addToHolder$default(new RsDiagnostic.PatternArgumentInForeignFunctionError(element), holder, false, null, 6, null);
            }
        } else if (rsAbstractableOwner instanceof RsAbstractableOwner.Trait && isComplexPattern && RsFunctionKt.getBlock(fn) == null) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.PatternArgumentInFunctionWithoutBodyError(element), holder, false, null, 6, null);
        }
    }

    private final void checkFunctionPointerTypeParameterPatIsSimple(RsPat element, RsProblemsHolder holder) {
        boolean isComplexPattern = this.isComplexPattern(element);
        if (isComplexPattern || element instanceof RsPatMacro) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.PatternArgumentInFunctionPointerTypeError(element), holder, false, null, 6, null);
        }
    }

    private final boolean isComplexPattern(RsPat pat) {
        boolean bl;
        RsPat rsPat = pat;
        if (rsPat == null || rsPat instanceof RsPatWild) {
            bl = false;
        } else if (rsPat instanceof RsPatIdent) {
            RsPatBinding rsPatBinding = ((RsPatIdent)pat).getPatBinding();
            Intrinsics.checkNotNullExpressionValue((Object)rsPatBinding, (String)"getPatBinding(...)");
            RsPatBinding binding = rsPatBinding;
            bl = RsPatBindingKt.getMutability(binding) == Mutability.MUTABLE || RsPatBindingKt.getKind(binding) instanceof RsBindingModeKind.BindByReference || ((RsPatIdent)pat).getAt() != null;
        } else {
            if (rsPat instanceof RsPatMacro) {
                RsPat expansion = RsPatKt.getExpandedPat((RsPatMacro)pat);
                return expansion != null && this.isComplexPattern(expansion);
            }
            bl = true;
        }
        return bl;
    }

    private final void checkPat(RsProblemsHolder holder, RsPat element) {
        if (element instanceof RsPatRange) {
            this.checkPatRange(holder, (RsPatRange)element);
        }
    }

    private final void checkPatRange(RsProblemsHolder holder, RsPatRange element) {
        RsPatConst start2 = RsPatRangeKt.getStart(element);
        RsPatConst end = RsPatRangeKt.getEnd(element);
        if (element.getDotdot() != null) {
            if (start2 == null && end == null) {
                AnnotatorUtilsKt.deny$default(element.getDotdot(), holder, RsBundle.INSTANCE.message("inspection.message.unexpected3", new Object[0]), null, 8, null);
            }
        } else if (element.getDotdoteq() != null) {
            if (start2 == null && end == null) {
                AnnotatorUtilsKt.deny$default(element.getDotdoteq(), holder, RsBundle.INSTANCE.message("inspection.message.unexpected2", new Object[0]), null, 8, null);
            }
        } else if (element.getDotdotdot() != null) {
            if (start2 == null && end == null) {
                AnnotatorUtilsKt.deny$default(element.getDotdotdot(), holder, RsBundle.INSTANCE.message("inspection.message.unexpected", new Object[0]), null, 8, null);
            } else if (start2 == null) {
                AnnotatorUtilsKt.deny$default(element.getDotdotdot(), holder, RsBundle.INSTANCE.message("inspection.message.range.to.patterns.with.are.not.allowed", new Object[0]), null, 8, null);
            }
        }
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkGeneralPat(RsPatternsAreNotAllowedInspection $this, RsPat element, RsProblemsHolder holder) {
        $this.checkGeneralPat(element, holder);
    }

    public static final /* synthetic */ void access$checkPat(RsPatternsAreNotAllowedInspection $this, RsProblemsHolder holder, RsPat element) {
        $this.checkPat(holder, element);
    }
}

