/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.fixes.AddFieldToStructTypeFix;
import org.rust.ide.fixes.RemoveFieldPatFix;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPatField;
import org.rust.lang.core.psi.RsPatFieldFull;
import org.rust.lang.core.psi.RsPatRest;
import org.rust.lang.core.psi.RsPatStruct;
import org.rust.lang.core.psi.RsPatTupleStruct;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsFieldDecl;
import org.rust.lang.core.psi.ext.RsFieldsOwner;
import org.rust.lang.core.psi.ext.RsFieldsOwnerKt;
import org.rust.lang.core.psi.ext.RsModKt;
import org.rust.lang.core.psi.ext.RsPatFieldKt;
import org.rust.lang.core.psi.ext.RsPatStructKt;
import org.rust.lang.core.psi.ext.RsPatTupleStructKt;
import org.rust.lang.core.psi.ext.RsStructItemKt;
import org.rust.lang.core.psi.ext.RsStructKind;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.resolve.ref.RsPathReferenceImplKt;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/rust/ide/inspections/compiler/RsPatStructInvalidFieldsInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkRsPatStruct", "", "patStruct", "Lorg/rust/lang/core/psi/RsPatStruct;", "checkRepeatedPatStructFields", "pats", "", "Lorg/rust/lang/core/psi/RsPatField;", "checkRsPatTupleStruct", "patTupleStruct", "Lorg/rust/lang/core/psi/RsPatTupleStruct;", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsPatStructInvalidFieldsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsPatStructInvalidFieldsInspection.kt\norg/rust/ide/inspections/compiler/RsPatStructInvalidFieldsInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1563#2:97\n1634#2,3:98\n774#2:101\n865#2,2:102\n1563#2:104\n1634#2,3:105\n774#2:108\n865#2,2:109\n827#2:111\n855#2,2:112\n*S KotlinDebug\n*F\n+ 1 RsPatStructInvalidFieldsInspection.kt\norg/rust/ide/inspections/compiler/RsPatStructInvalidFieldsInspection\n*L\n25#1:97\n25#1:98,3\n27#1:101\n27#1:102,2\n44#1:104\n44#1:105,3\n45#1:108\n45#1:109,2\n80#1:111\n80#1:112,2\n*E\n"})
public final class RsPatStructInvalidFieldsInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsPatStructInvalidFieldsInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitPatStruct(RsPatStruct o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsPatStructInvalidFieldsInspection.access$checkRsPatStruct(this.this$0, this.$holder, o);
            }

            public void visitPatTupleStruct(RsPatTupleStruct o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsPatStructInvalidFieldsInspection.access$checkRsPatTupleStruct(this.this$0, this.$holder, o);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRsPatStruct(RsProblemsHolder holder, RsPatStruct patStruct) {
        void $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        RsPathReference rsPathReference = patStruct.getPath().getReference();
        RsElement rsElement = rsPathReference != null ? RsPathReferenceImplKt.deepResolve(rsPathReference) : null;
        RsFieldsOwner rsFieldsOwner = rsElement instanceof RsFieldsOwner ? (RsFieldsOwner)rsElement : null;
        if (rsFieldsOwner == null) {
            return;
        }
        RsFieldsOwner declaration = rsFieldsOwner;
        Iterable $this$map$iv = RsFieldsOwnerKt.getExpandedFields(declaration);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it2;
            RsFieldDecl rsFieldDecl = (RsFieldDecl)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getName());
        }
        List declarationFieldNames = (List)destination$iv$iv;
        List<RsPatField> bodyFields = RsPatStructKt.getExpandedPatFieldList(patStruct);
        Iterable $this$filter$iv = bodyFields;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RsPatField it3 = (RsPatField)element$iv$iv;
            boolean bl = false;
            if (!(!declarationFieldNames.contains(RsPatFieldKt.getFieldName(RsPatFieldKt.getKind(it3))))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List extraFields = (List)destination$iv$iv2;
        boolean needsPub = !RsModKt.isDescendantOf(patStruct.getContainingMod(), declaration.getContainingMod());
        for (RsPatField extraField : extraFields) {
            RsQuickFixBase[] $i$f$filterTo2 = new RsQuickFixBase[]{AddFieldToStructTypeFix.Companion.createIfCompatible(declaration, RsPatFieldKt.getFieldName(RsPatFieldKt.getKind(extraField)), needsPub), new RemoveFieldPatFix(extraField)};
            List fixes = CollectionsKt.listOfNotNull((Object[])$i$f$filterTo2);
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.ExtraFieldInStructPattern(declaration, extraField, fixes), holder, false, null, 6, null);
        }
        if (declaration instanceof RsStructItem && RsStructItemKt.getKind((RsStructItem)declaration) == RsStructKind.UNION) {
            if (bodyFields.isEmpty()) {
                RsDiagnosticKt.addToHolder$default(new RsDiagnostic.MissingFieldsInUnionPattern(patStruct), holder, false, null, 6, null);
            } else if (bodyFields.size() > 1) {
                RsDiagnosticKt.addToHolder$default(new RsDiagnostic.TooManyFieldsInUnionPattern(patStruct), holder, false, null, 6, null);
            }
        } else {
            void $this$filterTo$iv$iv2;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = bodyFields;
            boolean $i$f$map2 = false;
            Iterable $i$f$filterTo2 = $this$map$iv2;
            Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it4;
                RsPatField rsPatField = (RsPatField)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(RsPatFieldKt.getFieldName(RsPatFieldKt.getKind((RsPatField)it4)));
            }
            List bodyFieldNames = (List)destination$iv$iv3;
            Iterable $this$filter$iv2 = RsFieldsOwnerKt.getExpandedFields(declaration);
            boolean $i$f$filter2 = false;
            destination$iv$iv3 = $this$filter$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                RsFieldDecl it5 = (RsFieldDecl)element$iv$iv;
                boolean bl = false;
                if (!(!CollectionsKt.contains((Iterable)bodyFieldNames, (Object)it5.getName()))) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List missingFields = (List)destination$iv$iv4;
            if (!((Collection)missingFields).isEmpty() && patStruct.getPatRest() == null) {
                RsDiagnosticKt.addToHolder$default(new RsDiagnostic.MissingFieldsInStructPattern(patStruct, declaration, missingFields), holder, false, null, 6, null);
            }
            List<RsPatField> list = patStruct.getPatFieldList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getPatFieldList(...)");
            this.checkRepeatedPatStructFields(holder, list);
        }
    }

    private final void checkRepeatedPatStructFields(RsProblemsHolder holder, List<? extends RsPatField> pats) {
        Set visitedFields = new LinkedHashSet();
        for (RsPatField rsPatField : pats) {
            String string;
            RsPatBinding binding = rsPatField.getPatBinding();
            RsPatFieldFull fieldFull = rsPatField.getPatFieldFull();
            if (binding != null) {
                string = binding.getIdentifier().getText();
            } else if (fieldFull == null || (string = fieldFull.getIdentifier()) == null || (string = string.getText()) == null) continue;
            String name2 = string;
            if (visitedFields.contains(name2)) {
                Intrinsics.checkNotNull((Object)name2);
                RsDiagnosticKt.addToHolder$default(new RsDiagnostic.RepeatedFieldInStructPattern(rsPatField, name2), holder, false, null, 6, null);
                continue;
            }
            Intrinsics.checkNotNull((Object)name2);
            visitedFields.add(name2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRsPatTupleStruct(RsProblemsHolder holder, RsPatTupleStruct patTupleStruct) {
        void $this$filterNotTo$iv$iv;
        RsPathReference rsPathReference = patTupleStruct.getPath().getReference();
        RsElement rsElement = rsPathReference != null ? RsPathReferenceImplKt.deepResolve(rsPathReference) : null;
        RsFieldsOwner rsFieldsOwner = rsElement instanceof RsFieldsOwner ? (RsFieldsOwner)rsElement : null;
        if (rsFieldsOwner == null) {
            return;
        }
        RsFieldsOwner declaration = rsFieldsOwner;
        int declarationFieldsAmount = RsFieldsOwnerKt.getExpandedFields(declaration).size();
        List<RsPat> list = patTupleStruct.getPatList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPatList(...)");
        Iterable $this$filterNot$iv = list;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            RsPat it2 = (RsPat)element$iv$iv;
            boolean bl = false;
            if (it2 instanceof RsPatRest) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int bodyFieldsAmount = ((List)destination$iv$iv).size();
        if (bodyFieldsAmount < declarationFieldsAmount && RsPatTupleStructKt.getPatRest(patTupleStruct) == null) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.MissingFieldsInTuplePattern(patTupleStruct, declaration, declarationFieldsAmount, bodyFieldsAmount), holder, false, null, 6, null);
        } else if (bodyFieldsAmount > declarationFieldsAmount) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.ExtraFieldInTupleStructPattern(patTupleStruct, bodyFieldsAmount, declarationFieldsAmount), holder, false, null, 6, null);
        }
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkRsPatStruct(RsPatStructInvalidFieldsInspection $this, RsProblemsHolder holder, RsPatStruct patStruct) {
        $this.checkRsPatStruct(holder, patStruct);
    }

    public static final /* synthetic */ void access$checkRsPatTupleStruct(RsPatStructInvalidFieldsInspection $this, RsProblemsHolder holder, RsPatTupleStruct patTupleStruct) {
        $this.checkRsPatTupleStruct(holder, patTupleStruct);
    }
}

