/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsBreakExpr;
import org.rust.lang.core.psi.RsContExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsLabelReferenceOwner;
import org.rust.lang.core.psi.ext.RsLooplikeExpr;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/inspections/compiler/RsLoopOnlyKeywordOutsideOfLoopInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkLabelRefOwnerPlacementCorrectness", "", "expr", "Lorg/rust/lang/core/psi/ext/RsLabelReferenceOwner;", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsLoopOnlyKeywordOutsideOfLoopInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsLoopOnlyKeywordOutsideOfLoopInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitBreakExpr(RsBreakExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsLoopOnlyKeywordOutsideOfLoopInspection.access$checkLabelRefOwnerPlacementCorrectness(this.this$0, this.$holder, o);
            }

            public void visitContExpr(RsContExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsLoopOnlyKeywordOutsideOfLoopInspection.access$checkLabelRefOwnerPlacementCorrectness(this.this$0, this.$holder, o);
            }
        };
    }

    private final void checkLabelRefOwnerPlacementCorrectness(RsProblemsHolder holder, RsLabelReferenceOwner expr) {
        for (PsiElement ancestor : PsiElementKt.getContexts(expr)) {
            if (ancestor instanceof RsLooplikeExpr) {
                return;
            }
            if (ancestor instanceof RsBlockExpr && ((RsBlockExpr)ancestor).getLabelDecl() != null) {
                return;
            }
            if (ancestor instanceof RsFunction) break;
            if (!(ancestor instanceof RsLambdaExpr)) continue;
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.LoopOnlyKeywordUsedInClosureError(expr.getOperator()), holder, false, null, 6, null);
            return;
        }
        RsDiagnosticKt.addToHolder$default(new RsDiagnostic.LoopOnlyKeywordUsedOutsideOfLoopError(expr.getOperator()), holder, false, null, 6, null);
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkLabelRefOwnerPlacementCorrectness(RsLoopOnlyKeywordOutsideOfLoopInspection $this, RsProblemsHolder holder, RsLabelReferenceOwner expr) {
        $this.checkLabelRefOwnerPlacementCorrectness(holder, expr);
    }
}

