/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.RsLiteralWithSuffix;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.stdext.ASTNodeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0014\u0010\n\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/inspections/compiler/RsInvalidLiteralSuffixInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "isSyntaxOnly", "()Z", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "checkLitExpr", "", "expr", "Lorg/rust/lang/core/psi/RsLitExpr;", "intellij.rustrover.core"})
public final class RsInvalidLiteralSuffixInspection
extends RsLocalInspectionTool {
    private final boolean isSyntaxOnly;

    public RsInvalidLiteralSuffixInspection() {
        this.isSyntaxOnly = true;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsInvalidLiteralSuffixInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitLitExpr(RsLitExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsInvalidLiteralSuffixInspection.access$checkLitExpr(this.this$0, o, this.$holder);
            }
        };
    }

    @Override
    public boolean isSyntaxOnly() {
        return this.isSyntaxOnly;
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    private final void checkLitExpr(RsLitExpr expr, RsProblemsHolder holder) {
        block3: {
            RsLiteralKind literal = RsLiteralKindKt.getKind(expr);
            if (!(literal instanceof RsLiteralKind.Integer) && !(literal instanceof RsLiteralKind.Float) && !(literal instanceof RsLiteralKind.String) && !(literal instanceof RsLiteralKind.Char)) break block3;
            RsLiteralWithSuffix cfr_ignored_0 = (RsLiteralWithSuffix)((Object)literal);
            String suffix = ((RsLiteralWithSuffix)((Object)literal)).getSuffix();
            List<String> validSuffixes = ((RsLiteralWithSuffix)((Object)literal)).getValidSuffixes();
            KClass[] kClassArray = (KClass[])suffix;
            if (!(kClassArray == null || kClassArray.length() == 0) && !validSuffixes.contains(suffix) && PsiTreeUtilKt.parentOfTypes$default((PsiElement)expr, (KClass[])(kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(RsMacroCall.class), Reflection.getOrCreateKotlinClass(RsMetaItem.class)}), (boolean)false, (int)2, null) == null) {
                String string;
                if (!((Collection)validSuffixes).isEmpty()) {
                    String validSuffixesStr = CollectionsKt.joinToString$default((Iterable)validSuffixes, null, null, null, (int)0, null, RsInvalidLiteralSuffixInspection::checkLitExpr$lambda$0, (int)31, null);
                    Object[] objectArray = new Object[]{suffix, ASTNodeKt.getDisplayName(literal.getNode()), validSuffixesStr};
                    string = RsBundle.INSTANCE.message("inspection.message.invalid.suffix.for.suffix.must.be.one", objectArray);
                } else {
                    Object[] objectArray = new Object[]{ASTNodeKt.getDisplayName(literal.getNode())};
                    string = RsBundle.INSTANCE.message("inspection.message.with.suffix.invalid", objectArray);
                }
                String message = string;
                holder.registerProblem((PsiElement)expr, message, new LocalQuickFix[0]);
            }
        }
    }

    private static final CharSequence checkLitExpr$lambda$0(String it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return "`" + it2 + "`";
    }

    public static final /* synthetic */ void access$checkLitExpr(RsInvalidLiteralSuffixInspection $this, RsLitExpr expr, RsProblemsHolder holder) {
        $this.checkLitExpr(expr, holder);
    }
}

