/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsLifetime;
import org.rust.lang.core.psi.RsLifetimeParameter;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsLifetimeKt;
import org.rust.lang.core.psi.ext.RsLifetimeParameterKt;
import org.rust.lang.core.resolve.ref.RsReference;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;
import org.rust.util.UtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/inspections/compiler/RsInvalidLifetimeNameInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkLifetimeParameter", "", "lifetimeParameter", "Lorg/rust/lang/core/psi/RsLifetimeParameter;", "checkLifetime", "lifetime", "Lorg/rust/lang/core/psi/RsLifetime;", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsInvalidLifetimeNameInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsInvalidLifetimeNameInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitLifetime(RsLifetime o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsInvalidLifetimeNameInspection.access$checkLifetime(this.this$0, this.$holder, o);
            }

            public void visitLifetimeParameter(RsLifetimeParameter o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsInvalidLifetimeNameInspection.access$checkLifetimeParameter(this.this$0, this.$holder, o);
            }
        };
    }

    private final void checkLifetimeParameter(RsProblemsHolder holder, RsLifetimeParameter lifetimeParameter) {
        String string = lifetimeParameter.getName();
        boolean bl = string != null ? UtilKt.isIllegalLifetimeName(string, RsElementKt.getEdition(lifetimeParameter)) : false;
        if (bl) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.IllegalLifetimeName(lifetimeParameter), holder, false, null, 6, null);
        } else if (RsLifetimeParameterKt.getHasEmptyName(lifetimeParameter)) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.LifetimeWithoutName(lifetimeParameter), holder, false, null, 6, null);
        }
    }

    private final void checkLifetime(RsProblemsHolder holder, RsLifetime lifetime) {
        String string = lifetime.getName();
        boolean bl = string != null ? UtilKt.isIllegalLifetimeName(string, RsElementKt.getEdition(lifetime)) : false;
        if (bl) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.IllegalLifetimeName(lifetime), holder, false, null, 6, null);
        }
        if (!RsLifetimeKt.isPredefined(lifetime) && ((RsReference)lifetime.getReference()).multiResolve().isEmpty() && RsLifetimeKt.getHasEmptyName(lifetime)) {
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.LifetimeWithoutName(lifetime), holder, false, null, 6, null);
        }
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkLifetime(RsInvalidLifetimeNameInspection $this, RsProblemsHolder holder, RsLifetime lifetime) {
        $this.checkLifetime(holder, lifetime);
    }

    public static final /* synthetic */ void access$checkLifetimeParameter(RsInvalidLifetimeNameInspection $this, RsProblemsHolder holder, RsLifetimeParameter lifetimeParameter) {
        $this.checkLifetimeParameter(holder, lifetimeParameter);
    }
}

