/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.stdext.ASTNodeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0014\u0010\n\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/inspections/compiler/RsInvalidCharLiteralLengthInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "isSyntaxOnly", "()Z", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "checkLitExpr", "", "expr", "Lorg/rust/lang/core/psi/RsLitExpr;", "intellij.rustrover.core"})
public final class RsInvalidCharLiteralLengthInspection
extends RsLocalInspectionTool {
    private final boolean isSyntaxOnly;

    public RsInvalidCharLiteralLengthInspection() {
        this.isSyntaxOnly = true;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsInvalidCharLiteralLengthInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitLitExpr(RsLitExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsInvalidCharLiteralLengthInspection.access$checkLitExpr(this.this$0, o, this.$holder);
            }
        };
    }

    @Override
    public boolean isSyntaxOnly() {
        return this.isSyntaxOnly;
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    private final void checkLitExpr(RsLitExpr expr, RsProblemsHolder holder) {
        RsLiteralKind literal = RsLiteralKindKt.getKind(expr);
        if (literal instanceof RsLiteralKind.Char) {
            String errorMessage;
            String value = ((RsLiteralKind.Char)literal).getValue();
            Object[] objectArray = (Object[])value;
            if (objectArray == null || objectArray.length() == 0) {
                objectArray = new Object[]{ASTNodeKt.getDisplayName(((RsLiteralKind.Char)literal).getNode())};
                v0 = RsBundle.INSTANCE.message("empty.0", objectArray);
            } else if (value.codePointCount(0, value.length()) > 1) {
                objectArray = new Object[]{ASTNodeKt.getDisplayName(((RsLiteralKind.Char)literal).getNode())};
                v0 = RsBundle.INSTANCE.message("too.many.characters.in.0", objectArray);
            } else {
                v0 = errorMessage = null;
            }
            if (errorMessage != null) {
                holder.registerProblem((PsiElement)expr, errorMessage, new LocalQuickFix[0]);
            }
        }
    }

    public static final /* synthetic */ void access$checkLitExpr(RsInvalidCharLiteralLengthInspection $this, RsLitExpr expr, RsProblemsHolder holder) {
        $this.checkLitExpr(expr, holder);
    }
}

