/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.fixes.ChangeFunctionSignatureFix;
import org.rust.ide.fixes.FillFunctionArgumentsFix;
import org.rust.ide.fixes.RemoveRedundantFunctionArgumentsFix;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsValueArgumentList;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.QueryAttributes;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwner;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.types.FunctionCallContext;
import org.rust.lang.core.types.FunctionCallContextKt;
import org.rust.lang.utils.QuickFixWithRange;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/inspections/compiler/RsIncorrectFunctionArgumentCountInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "getChangeSignatureFixes", "", "Lorg/rust/ide/fixes/ChangeFunctionSignatureFix;", "function", "Lorg/rust/lang/core/psi/RsFunction;", "args", "Lorg/rust/lang/core/psi/RsValueArgumentList;", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsIncorrectFunctionArgumentCountInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsIncorrectFunctionArgumentCountInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitValueArgumentList(RsValueArgumentList o) {
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                FunctionCallContext functionCallContext = FunctionCallContextKt.getFunctionCallContext(o);
                if (functionCallContext == null) {
                    return;
                }
                FunctionCallContext functionCallContext2 = functionCallContext;
                int expectedCount = functionCallContext2.component1();
                RsDiagnostic.IncorrectFunctionArgumentCountError.FunctionType functionType = functionCallContext2.component2();
                RsFunction function = functionCallContext2.component3();
                Object object = function;
                boolean bl = object != null && (object = RsDocAndAttributeOwnerKt.getQueryAttributes((RsDocAndAttributeOwner)object)) != null ? ((QueryAttributes)object).hasAttribute("rustc_legacy_const_generics") : false;
                if (bl) {
                    return;
                }
                List<RsExpr> list = o.getExprList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo2 = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    RsExpr it2 = (RsExpr)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it2);
                    if (!CfgUtilsKt.isEnabledByCfg(it2)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                int realCount = ((List)destination$iv$iv).size();
                if (realCount < expectedCount) {
                    void $this$mapTo$iv$iv;
                    PsiElement psiElement2 = o.getRparen();
                    if (psiElement2 == null) {
                        return;
                    }
                    PsiElement rparen = psiElement2;
                    $this$filterTo$iv$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)new FillFunctionArgumentsFix(o))), (Iterable)RsIncorrectFunctionArgumentCountInspection.access$getChangeSignatureFixes(this.this$0, function, o));
                    boolean $i$f$map = false;
                    void $i$f$filterTo2 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it3;
                        RsQuickFixBase rsQuickFixBase = (RsQuickFixBase)((Object)item$iv$iv);
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(new QuickFixWithRange((LocalQuickFix)it3, o.getTextRange()));
                    }
                    List fixesWithRange = (List)destination$iv$iv;
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.IncorrectFunctionArgumentCountError(rparen, null, expectedCount, realCount, functionType, fixesWithRange), this.$holder, false, null, 6, null);
                } else if (!functionType.getVariadic() && realCount > expectedCount) {
                    List<RsExpr> list2 = o.getExprList();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getExprList(...)");
                    List extraArgs = CollectionsKt.drop((Iterable)list2, (int)expectedCount);
                    $this$map$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)new RemoveRedundantFunctionArgumentsFix(o, expectedCount))), (Iterable)RsIncorrectFunctionArgumentCountInspection.access$getChangeSignatureFixes(this.this$0, function, o));
                    boolean $i$f$map = false;
                    Iterable $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        RsQuickFixBase it3 = (RsQuickFixBase)((Object)item$iv$iv);
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(new QuickFixWithRange(it3, o.getTextRange()));
                    }
                    List fixesWithRange = (List)destination$iv$iv;
                    RsExpr rsExpr = (RsExpr)CollectionsKt.firstOrNull((List)extraArgs);
                    RsDiagnosticKt.addToHolder$default(new RsDiagnostic.IncorrectFunctionArgumentCountError((PsiElement)(rsExpr != null ? (RsElement)rsExpr : (RsElement)o), extraArgs.size() <= 1 ? null : (RsExpr)CollectionsKt.last((List)extraArgs), expectedCount, realCount, functionType, fixesWithRange), this.$holder, false, null, 6, null);
                }
            }
        };
    }

    private final List<ChangeFunctionSignatureFix> getChangeSignatureFixes(RsFunction function, RsValueArgumentList args) {
        return function != null ? ChangeFunctionSignatureFix.Companion.createIfCompatible(args, function) : CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ List access$getChangeSignatureFixes(RsIncorrectFunctionArgumentCountInspection $this, RsFunction function, RsValueArgumentList args) {
        return $this.getChangeSignatureFixes(function, args);
    }
}

