/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.annotator.AnnotatorUtilsKt;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.compiler.RsAddDummyParameterNameFix;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsOuterAttr;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsFunctionKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/rust/ide/inspections/compiler/RsFunctionCannotHaveAnonymousParametersInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "isSyntaxOnly", "", "()Z", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "checkValueParameter", "", "param", "Lorg/rust/lang/core/psi/RsValueParameter;", "checkValueParameterInFunction", "fn", "Lorg/rust/lang/core/psi/RsFunction;", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsFunctionCannotHaveAnonymousParametersInspection
extends RsLocalInspectionTool {
    private final boolean isSyntaxOnly;

    public RsFunctionCannotHaveAnonymousParametersInspection() {
        this.isSyntaxOnly = true;
    }

    @Override
    public boolean isSyntaxOnly() {
        return this.isSyntaxOnly;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsFunctionCannotHaveAnonymousParametersInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitValueParameter(RsValueParameter o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsFunctionCannotHaveAnonymousParametersInspection.access$checkValueParameter(this.this$0, this.$holder, o);
            }
        };
    }

    private final void checkValueParameter(RsProblemsHolder holder, RsValueParameter param) {
        PsiElement psiElement2 = param.getParent().getParent();
        if (psiElement2 == null) {
            return;
        }
        PsiElement parent2 = psiElement2;
        if (parent2 instanceof RsFunction) {
            this.checkValueParameterInFunction((RsFunction)parent2, param, holder);
        }
    }

    private final void checkValueParameterInFunction(RsFunction fn, RsValueParameter param, RsProblemsHolder holder) {
        RsAbstractableOwner rsAbstractableOwner;
        RsPat pat = param.getPat();
        if (pat == null) {
            List<RsOuterAttr> list = param.getOuterAttrList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"<get-outerAttrList>(...)");
            if (!((Collection)list).isEmpty()) {
                return;
            }
        }
        if ((rsAbstractableOwner = RsAbstractableKt.getOwner(fn)) instanceof RsAbstractableOwner.Free || rsAbstractableOwner instanceof RsAbstractableOwner.Impl) {
            Object[] objectArray = new Object[]{RsFunctionKt.getTitle(fn)};
            AnnotatorUtilsKt.require(pat, holder, RsBundle.INSTANCE.message("inspection.message.cannot.have.anonymous.parameters", objectArray), param);
        } else if (rsAbstractableOwner instanceof RsAbstractableOwner.Foreign) {
            Object[] objectArray = new Object[]{RsFunctionKt.getTitle(fn)};
            AnnotatorUtilsKt.require(pat, holder, RsBundle.INSTANCE.message("inspection.message.cannot.have.anonymous.parameters", objectArray), param);
        } else if (rsAbstractableOwner instanceof RsAbstractableOwner.Trait) {
            if (pat == null) {
                String message = RsBundle.INSTANCE.message("inspection.message.anonymous.functions.parameters.are.deprecated.rfc", new Object[0]);
                PsiFile psiFile = param.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                TextRange textRange = param.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                RsAddDummyParameterNameFix fix = new RsAddDummyParameterNameFix(psiFile, textRange, "_: " + param.getText());
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                RsProblemsHolder.registerProblem$default(holder, param, message, ProblemHighlightType.WARNING, localQuickFixArray, null, 16, null);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkValueParameter(RsFunctionCannotHaveAnonymousParametersInspection $this, RsProblemsHolder holder, RsValueParameter param) {
        $this.checkValueParameter(holder, param);
    }
}

