/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.annotator.RsEditionHighlighter;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.inspections.compiler.RsEditionKeywordsInspectionKt;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/rust/ide/inspections/compiler/RsEditionKeywordsInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "Lorg/rust/ide/annotator/RsEditionHighlighter;", "editionYear", "", "<init>", "(Ljava/lang/String;)V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public abstract class RsEditionKeywordsInspection
extends RsLocalInspectionTool
implements RsEditionHighlighter {
    @NotNull
    private final String editionYear;
    @NotNull
    private final AutoApplicabilityForFullLine useInFullLine;

    public RsEditionKeywordsInspection(@NotNull String editionYear) {
        Intrinsics.checkNotNullParameter((Object)editionYear, (String)"editionYear");
        this.editionYear = editionYear;
        this.useInFullLine = AutoApplicabilityForFullLine.AutoApplicable;
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsEditionKeywordsInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (RsElementKt.getEdition(element) == null) {
                    return;
                }
                if (!this.this$0.isEditionKeyword(element)) {
                    return;
                }
                boolean isAtLeastEdition = this.this$0.isAtLeastEdition(element);
                boolean isIdentifier = Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(element), (Object)RsElementTypes.IDENTIFIER);
                if (isAtLeastEdition && isIdentifier && RsEditionKeywordsInspectionKt.access$isNameIdentifier(element)) {
                    Object[] objectArray = new Object[2];
                    Intrinsics.checkNotNullExpressionValue((Object)element.getText(), (String)"getText(...)");
                    objectArray[1] = RsEditionKeywordsInspection.access$getEditionYear$p(this.this$0);
                    this.$holder.registerProblem(element, RsBundle.INSTANCE.message("inspection.message.reserved.keyword.in.edition", objectArray), new LocalQuickFix[0]);
                } else if (!isAtLeastEdition && !isIdentifier) {
                    Object[] objectArray = new Object[]{RsEditionKeywordsInspection.access$getEditionYear$p(this.this$0)};
                    this.$holder.registerProblem(element, RsBundle.INSTANCE.message("inspection.message.this.feature.only.available.in.edition", objectArray), new LocalQuickFix[0]);
                }
            }
        };
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return this.useInFullLine;
    }

    public static final /* synthetic */ String access$getEditionYear$p(RsEditionKeywordsInspection $this) {
        return $this.editionYear;
    }
}

