/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.RemoveElementFix;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsTypeParamBounds;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsTypeParamBoundsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/inspections/compiler/RsDynOrImplInTraitBoundsInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkTypeParamBounds", "", "bounds", "Lorg/rust/lang/core/psi/RsTypeParamBounds;", "isSyntaxOnly", "()Z", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "RsRemoveImplKeywordFix", "RsRemoveDynKeywordFix", "intellij.rustrover.core"})
public final class RsDynOrImplInTraitBoundsInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsDynOrImplInTraitBoundsInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitTypeParamBounds(RsTypeParamBounds o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsDynOrImplInTraitBoundsInspection.access$checkTypeParamBounds(this.this$0, this.$holder, o);
            }
        };
    }

    private final void checkTypeParamBounds(RsProblemsHolder holder, RsTypeParamBounds bounds) {
        PsiElement dyn;
        PsiElement impl = bounds.getImpl();
        if (impl != null) {
            RsRemoveImplKeywordFix fix = new RsRemoveImplKeywordFix(impl);
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
            holder.registerProblem(impl, RsBundle.INSTANCE.message("inspection.message.expected.trait.bound.found.impl.trait.type", new Object[0]), localQuickFixArray);
        }
        if ((dyn = RsTypeParamBoundsKt.getDyn(bounds)) != null) {
            RsRemoveDynKeywordFix fix = new RsRemoveDynKeywordFix(dyn);
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
            holder.registerProblem(dyn, RsBundle.INSTANCE.message("inspection.message.invalid.dyn.keyword", new Object[0]), localQuickFixArray);
        }
    }

    @Override
    public boolean isSyntaxOnly() {
        return true;
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkTypeParamBounds(RsDynOrImplInTraitBoundsInspection $this, RsProblemsHolder holder, RsTypeParamBounds bounds) {
        $this.checkTypeParamBounds(holder, bounds);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/inspections/compiler/RsDynOrImplInTraitBoundsInspection$RsRemoveDynKeywordFix;", "Lorg/rust/ide/fixes/RemoveElementFix;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "intellij.rustrover.core"})
    public static final class RsRemoveDynKeywordFix
    extends RemoveElementFix {
        public RsRemoveDynKeywordFix(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super(element, RsBundle.INSTANCE.message("dyn.keyword", new Object[0]));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/inspections/compiler/RsDynOrImplInTraitBoundsInspection$RsRemoveImplKeywordFix;", "Lorg/rust/ide/fixes/RemoveElementFix;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "intellij.rustrover.core"})
    public static final class RsRemoveImplKeywordFix
    extends RemoveElementFix {
        public RsRemoveImplKeywordFix(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super(element, RsBundle.INSTANCE.message("impl.keyword", new Object[0]));
        }
    }
}

