/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.fixes.RsAddLabelFix;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsBreakExpr;
import org.rust.lang.core.psi.RsCondition;
import org.rust.lang.core.psi.RsContExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.RsWhileExpr;
import org.rust.lang.core.psi.ext.RsItemElement;
import org.rust.lang.core.psi.ext.RsLabelReferenceOwner;
import org.rust.lang.core.psi.ext.RsLooplikeExpr;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/inspections/compiler/RsControlFlowExprInWhileConditionWithoutLoopInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkLabelInWhileCondition", "", "item", "Lorg/rust/lang/core/psi/ext/RsLabelReferenceOwner;", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsControlFlowExprInWhileConditionWithoutLoopInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsControlFlowExprInWhileConditionWithoutLoopInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitBreakExpr(RsBreakExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsControlFlowExprInWhileConditionWithoutLoopInspection.access$checkLabelInWhileCondition(this.this$0, this.$holder, o);
            }

            public void visitContExpr(RsContExpr o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsControlFlowExprInWhileConditionWithoutLoopInspection.access$checkLabelInWhileCondition(this.this$0, this.$holder, o);
            }
        };
    }

    private final void checkLabelInWhileCondition(RsProblemsHolder holder, RsLabelReferenceOwner item) {
        if (item.getLabel() != null) {
            return;
        }
        Class[] classArray = new Class[]{RsLooplikeExpr.class, RsItemElement.class};
        RsCondition rsCondition = (RsCondition)PsiTreeUtil.getParentOfType((PsiElement)item, RsCondition.class, (boolean)true, (Class[])classArray);
        if (rsCondition == null) {
            return;
        }
        RsCondition condition = rsCondition;
        if (condition.getContext() instanceof RsWhileExpr) {
            RsAddLabelFix fix = RsAddLabelFix.Companion.createIfCompatible(item);
            String string = item.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            RsDiagnosticKt.addToHolder$default(new RsDiagnostic.BreakContinueInWhileConditionWithoutLoopError(item, string, fix), holder, false, null, 6, null);
        }
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkLabelInWhileCondition(RsControlFlowExprInWhileConditionWithoutLoopInspection $this, RsProblemsHolder holder, RsLabelReferenceOwner item) {
        $this.checkLabelInWhileCondition(holder, item);
    }
}

