/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.fixes.AddTypeFix;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsConstantKt;
import org.rust.lang.core.types.ExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/inspections/compiler/RsConstantMissingTypeInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkConstantType", "", "element", "Lorg/rust/lang/core/psi/RsConstant;", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsConstantMissingTypeInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsConstantMissingTypeInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitConstant2(RsConstant o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsConstantMissingTypeInspection.access$checkConstantType(this.this$0, this.$holder, o);
            }
        };
    }

    private final void checkConstantType(RsProblemsHolder holder, RsConstant element) {
        if (element.getColon() == null && element.getTypeReference() == null) {
            AddTypeFix[] addTypeFixArray;
            PsiElement nameElement = RsConstantKt.getNameLikeElement(element);
            String typeText = RsConstantKt.isConst(element) ? "const" : "static";
            Object[] objectArray = new Object[]{typeText};
            String message = RsBundle.INSTANCE.message("inspection.message.missing.type.for.item", objectArray);
            RsExpr expr = element.getExpr();
            if (expr != null) {
                AddTypeFix[] addTypeFixArray2 = new AddTypeFix[]{new AddTypeFix(nameElement, ExtensionsKt.getType(expr))};
                addTypeFixArray = addTypeFixArray2;
            } else {
                addTypeFixArray = new AddTypeFix[]{};
            }
            AddTypeFix[] fixes = addTypeFixArray;
            RsProblemsHolder.registerProblem$default(holder, nameElement, message, ProblemHighlightType.ERROR, Arrays.copyOf(fixes, fixes.length), null, 16, null);
        }
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkConstantType(RsConstantMissingTypeInspection $this, RsProblemsHolder holder, RsConstant element) {
        $this.checkConstantType(holder, element);
    }
}

