/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.compiler;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.annotator.AnnotatorUtilsKt;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsConstantKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/inspections/compiler/RsConstSyntaxInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "checkConstant", "", "const", "Lorg/rust/lang/core/psi/RsConstant;", "isSyntaxOnly", "()Z", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsConstSyntaxInspection
extends RsLocalInspectionTool {
    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(this, holder){
            final /* synthetic */ RsConstSyntaxInspection this$0;
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitConstant2(RsConstant o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                RsConstSyntaxInspection.access$checkConstant(this.this$0, this.$holder, o);
            }
        };
    }

    private final void checkConstant(RsProblemsHolder holder, RsConstant rsConstant) {
        String string;
        Object object;
        String name2 = RsConstantKt.getNameLikeElement(rsConstant).getText();
        if (rsConstant.getStatic() != null) {
            object = new Object[1];
            Intrinsics.checkNotNull((Object)name2);
            object[0] = name2;
            string = RsBundle.INSTANCE.message("inspection.message.static.constant", object);
        } else {
            object = new Object[1];
            Intrinsics.checkNotNull((Object)name2);
            object[0] = name2;
            string = RsBundle.INSTANCE.message("inspection.message.constant", object);
        }
        String title = string;
        object = RsAbstractableKt.getOwner(rsConstant);
        if (object instanceof RsAbstractableOwner.Free) {
            Object[] objectArray = new Object[]{title};
            AnnotatorUtilsKt.deny$default(RsConstantKt.getDefault(rsConstant), holder, RsBundle.INSTANCE.message("inspection.message.cannot.have.default.qualifier", objectArray), null, 8, null);
            objectArray = new Object[]{title};
            AnnotatorUtilsKt.deny$default(rsConstant.getUnsafe(), holder, RsBundle.INSTANCE.message("inspection.message.cannot.have.unsafe.qualifier", objectArray), null, 8, null);
            objectArray = new Object[]{title};
            AnnotatorUtilsKt.deny$default(RsConstantKt.getSafe(rsConstant), holder, RsBundle.INSTANCE.message("inspection.message.cannot.have.safe.qualifier", objectArray), null, 8, null);
            objectArray = new Object[]{title};
            AnnotatorUtilsKt.require(rsConstant.getExpr(), holder, RsBundle.INSTANCE.message("inspection.message.must.have.value", objectArray), rsConstant);
        } else if (object instanceof RsAbstractableOwner.Foreign) {
            Object[] objectArray = new Object[]{title};
            AnnotatorUtilsKt.deny$default(RsConstantKt.getDefault(rsConstant), holder, RsBundle.INSTANCE.message("inspection.message.cannot.have.default.qualifier", objectArray), null, 8, null);
            AnnotatorUtilsKt.require(rsConstant.getStatic(), holder, RsBundle.INSTANCE.message("inspection.message.only.static.constants.are.allowed.in.extern.blocks", new Object[0]), rsConstant.getConst());
            AnnotatorUtilsKt.deny$default(rsConstant.getExpr(), holder, RsBundle.INSTANCE.message("inspection.message.static.constants.in.extern.blocks.cannot.have.values", new Object[0]), null, 8, null);
        } else if (object instanceof RsAbstractableOwner.Trait) {
            Object[] objectArray = new Object[]{title};
            AnnotatorUtilsKt.deny$default(rsConstant.getVis(), holder, RsBundle.INSTANCE.message("inspection.message.cannot.have.pub.qualifier", objectArray), null, 8, null);
            objectArray = new Object[]{title};
            AnnotatorUtilsKt.deny$default(RsConstantKt.getDefault(rsConstant), holder, RsBundle.INSTANCE.message("inspection.message.cannot.have.default.qualifier", objectArray), null, 8, null);
            AnnotatorUtilsKt.deny$default(rsConstant.getStatic(), holder, RsBundle.INSTANCE.message("inspection.message.static.constants.are.not.allowed.in.traits", new Object[0]), null, 8, null);
            objectArray = new Object[]{title};
            AnnotatorUtilsKt.deny$default(rsConstant.getUnsafe(), holder, RsBundle.INSTANCE.message("inspection.message.cannot.have.unsafe.qualifier", objectArray), null, 8, null);
            objectArray = new Object[]{title};
            AnnotatorUtilsKt.deny$default(RsConstantKt.getSafe(rsConstant), holder, RsBundle.INSTANCE.message("inspection.message.cannot.have.safe.qualifier", objectArray), null, 8, null);
        } else if (object instanceof RsAbstractableOwner.Impl) {
            AnnotatorUtilsKt.deny$default(rsConstant.getStatic(), holder, RsBundle.INSTANCE.message("inspection.message.static.constants.are.not.allowed.in.impl.blocks", new Object[0]), null, 8, null);
            Object[] objectArray = new Object[]{title};
            AnnotatorUtilsKt.require(rsConstant.getExpr(), holder, RsBundle.INSTANCE.message("inspection.message.must.have.value", objectArray), rsConstant);
            objectArray = new Object[]{title};
            AnnotatorUtilsKt.deny$default(rsConstant.getUnsafe(), holder, RsBundle.INSTANCE.message("inspection.message.cannot.have.unsafe.qualifier", objectArray), null, 8, null);
            objectArray = new Object[]{title};
            AnnotatorUtilsKt.deny$default(RsConstantKt.getSafe(rsConstant), holder, RsBundle.INSTANCE.message("inspection.message.cannot.have.safe.qualifier", objectArray), null, 8, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public boolean isSyntaxOnly() {
        return true;
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }

    public static final /* synthetic */ void access$checkConstant(RsConstSyntaxInspection $this, RsProblemsHolder holder, RsConstant rsConstant) {
        $this.checkConstant(holder, rsConstant);
    }
}

