/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.inspections.checkMatch;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.inspections.AutoApplicabilityForFullLine;
import org.rust.ide.inspections.RsLocalInspectionTool;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.ide.inspections.RsWithMacrosInspectionVisitor;
import org.rust.ide.utils.checkMatch.CheckMatchUtilsKt;
import org.rust.ide.utils.checkMatch.Pattern;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsMatchExpr;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.TyInteger;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/inspections/checkMatch/RsNonExhaustiveMatchInspection;", "Lorg/rust/ide/inspections/RsLocalInspectionTool;", "<init>", "()V", "getDisplayName", "", "buildVisitor", "Lorg/rust/lang/core/psi/RsVisitor;", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "isOnTheFly", "", "useInFullLine", "Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "getUseInFullLine", "()Lorg/rust/ide/inspections/AutoApplicabilityForFullLine;", "intellij.rustrover.core"})
public final class RsNonExhaustiveMatchInspection
extends RsLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        return RsBundle.INSTANCE.message("non.exhaustive.match", new Object[0]);
    }

    @Override
    @NotNull
    public RsVisitor buildVisitor(@NotNull RsProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new RsWithMacrosInspectionVisitor(holder){
            final /* synthetic */ RsProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitMatchExpr(RsMatchExpr matchExpr2) {
                Intrinsics.checkNotNullParameter((Object)matchExpr2, (String)"matchExpr");
                Object object = matchExpr2.getScrutinee();
                if (object == null || (object = ExtensionsKt.getType((RsExpr)object)) == null) {
                    return;
                }
                Object type = object;
                if (type instanceof TyInteger.U8 || type instanceof TyInteger.I8) {
                    return;
                }
                List<Pattern> list = CheckMatchUtilsKt.checkExhaustive(matchExpr2);
                if (list == null) {
                    return;
                }
                List<Pattern> patterns = list;
                RsDiagnosticKt.addToHolder$default(new RsDiagnostic.NonExhaustiveMatch(matchExpr2, patterns), this.$holder, false, null, 6, null);
            }
        };
    }

    @Override
    @NotNull
    public AutoApplicabilityForFullLine getUseInFullLine() {
        return AutoApplicabilityForFullLine.AutoApplicable;
    }
}

